/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.datasources;

import java.io.IOException;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import jrm.aui.basic.AbstractSrcDstResult;
import jrm.aui.basic.SDRList;
import jrm.aui.basic.SrcDstResult;
import jrm.misc.SettingsEnum;
import jrm.server.shared.datasources.XMLRequest;
import jrm.server.shared.datasources.XMLResponse;
import jrm.xml.SimpleAttribute;

abstract class SDRXMLResponse
extends XMLResponse {
    protected static final String SRC_IS_MISSING_IN_REQUEST = "Src is missing in request";
    protected static final String RESULT = "result";
    protected static final String RECORD = "record";
    protected static final String SELECTED = "selected";
    protected static final String RESPONSE = "response";
    protected static final String STATUS = "status";

    protected SDRXMLResponse(XMLRequest request) throws IOException, XMLStreamException {
        super(request);
    }

    protected void writeRecord(AbstractSrcDstResult sdr) throws XMLStreamException {
        this.writer.writeElement(RECORD, new SimpleAttribute[]{new SimpleAttribute("id", (Object)sdr.getId()), new SimpleAttribute("src", (Object)sdr.getSrc()), new SimpleAttribute("dst", (Object)Optional.ofNullable(sdr.getDst()).orElse("")), new SimpleAttribute(RESULT, (Object)sdr.getResult()), new SimpleAttribute(SELECTED, (Object)sdr.isSelected())});
    }

    protected void writeResponse(XMLRequest.Operation operation, SDRList<SrcDstResult> sdrl) throws XMLStreamException {
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        this.fetchList(operation, sdrl, (sdr, idx) -> this.writeRecord((AbstractSrcDstResult)sdr));
        this.writer.writeEndElement();
    }

    protected void writeResponseSingle(AbstractSrcDstResult sdr) throws XMLStreamException {
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        this.writer.writeStartElement("data");
        this.writeRecord(sdr);
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    protected void writeResponseKey(AbstractSrcDstResult sdr) throws XMLStreamException {
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        this.writer.writeStartElement("data");
        this.writer.writeElement(RECORD, new SimpleAttribute[]{new SimpleAttribute("id", (Object)sdr.getId())});
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    protected void needSave(SDRList<SrcDstResult> sdrl, SettingsEnum ppt) {
        if (sdrl.isNeedSave()) {
            this.request.getSession().getUser().getSettings().setProperty((Enum)ppt, AbstractSrcDstResult.toJSON(sdrl));
            this.request.getSession().getUser().getSettings().saveSettings();
        }
    }
}

