/*
 * Decompiled with CFR 0.152.
 */
package jrm.fullserver.db;

import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.math.NumberUtils;

public interface SQLUtils {
    default public String backquote(String name) {
        if (name == null) {
            return name;
        }
        return "`" + name + "`";
    }

    default public void append(StringBuilder str, String separator, CharSequence toAppend) {
        if (toAppend.length() > 0) {
            if (str.length() > 0) {
                str.append(separator);
            }
            str.append(toAppend);
        }
    }

    default public void appendComma(StringBuilder str, CharSequence toAppend) {
        if (str.length() > 0) {
            str.append(", ");
        }
        str.append(toAppend);
    }

    default public void prependComma(StringBuilder str, CharSequence toPrepend) {
        if (str.length() > 0) {
            str.insert(0, ", ");
        }
        str.insert(0, toPrepend);
    }

    default public CharSequence appendParam(StringBuilder str, int count) {
        if (str == null) {
            str = new StringBuilder();
        }
        for (int i = 0; i < count; ++i) {
            this.appendComma(str, "?");
        }
        return str;
    }

    default public CharSequence appendParam(int count) {
        return this.appendParam(null, count);
    }

    default public CharSequence makeCols(Collection<String> cols, boolean withParenthesis) {
        StringBuilder set = new StringBuilder();
        cols.forEach(col -> this.appendComma(set, this.backquote((String)col)));
        if (withParenthesis && cols.size() > 1) {
            set.insert(0, '(').append(')');
        }
        return set;
    }

    default public <T> Iterable<T> getIterable(Collection<T> coll) {
        return coll::iterator;
    }

    default public <T> Iterable<T> getReversedIterable(Collection<T> coll) {
        return () -> new LinkedList(coll).descendingIterator();
    }

    default public CharSequence makeCols(Iterable<String> cols) {
        StringBuilder set = new StringBuilder();
        for (String col : cols) {
            this.appendComma(set, this.backquote(col));
        }
        return set;
    }

    default public CharSequence makeCols(Collection<String> cols) {
        return this.makeCols(cols, false);
    }

    default public CharSequence makeSet(Collection<String> cols) {
        StringBuilder set = new StringBuilder();
        cols.forEach(col -> this.appendComma(set, this.backquote((String)col) + "=?"));
        return set;
    }

    default public CharSequence makeSet(LinkedHashMap<String, Object> map) {
        StringBuilder set = new StringBuilder();
        map.forEach((col, value) -> this.appendComma(set, this.backquote((String)col) + "=?"));
        return set;
    }

    default public CharSequence makeSet(Set<Map.Entry<String, Object>> map) {
        StringBuilder set = new StringBuilder();
        map.forEach(entry -> this.appendComma(set, this.backquote((String)entry.getKey()) + "=?"));
        return set;
    }

    default public String notNull(boolean required) {
        return required ? "NOT NULL" : "NULL";
    }

    default public String getSQLValue(String value, boolean isStr, boolean notNull) {
        if (isStr) {
            if (value == null) {
                return notNull ? "''" : "NULL";
            }
            return "'" + value + "'";
        }
        if (value == null || value.length() == 0) {
            return notNull ? "0" : "NULL";
        }
        return value;
    }

    public Connection getDb();

    public String getContext();

    default public String getSQLTable(String table) throws SQLException {
        return this.getSQLTable(table, this.getContext());
    }

    default public String getSQLTable(String table, String context) throws SQLException {
        if (context != null && this.getDb().getMetaData().supportsSchemasInDataManipulation()) {
            return this.backquote(context) + "." + this.backquote(table);
        }
        return this.backquote(table);
    }

    default public String getDefaultValue(String value, JDBCType type, boolean notNull) {
        switch (type) {
            case VARCHAR: 
            case LONGNVARCHAR: 
            case LONGVARCHAR: 
            case CLOB: 
            case CHAR: 
            case NCHAR: 
            case NCLOB: {
                return this.getCharDefaultValue(value, notNull);
            }
            case BOOLEAN: {
                return this.getBoolDefaultValue(value, notNull);
            }
            case INTEGER: 
            case TINYINT: 
            case SMALLINT: {
                return this.getIntDefaultValue(value, notNull);
            }
        }
        if (value == null || value.length() == 0) {
            return " DEFAULT " + (notNull ? "0" : "NULL");
        }
        if (value.length() > 0) {
            return " DEFAULT " + value;
        }
        return "";
    }

    default public String getIntDefaultValue(String value, boolean notNull) {
        if (value == null || value.length() == 0) {
            return " DEFAULT " + (notNull ? "0" : "NULL");
        }
        if (value.length() > 0) {
            return " DEFAULT " + value;
        }
        return "";
    }

    default public String getBoolDefaultValue(String value, boolean notNull) {
        if (value == null || value.length() == 0) {
            return " DEFAULT " + (notNull ? "FALSE" : "NULL");
        }
        if (value.length() > 0) {
            return " DEFAULT " + value;
        }
        return "";
    }

    default public String getCharDefaultValue(String value, boolean notNull) {
        if (value == null || value.length() == 0) {
            return " DEFAULT " + (notNull ? "''" : "NULL");
        }
        return " DEFAULT '" + value + "'";
    }

    default public Number val(String str) {
        return this.val(str, false);
    }

    default public Number val(String str, boolean strict) {
        if (strict) {
            return NumberUtils.createNumber((String)str);
        }
        StringBuilder validStr = new StringBuilder();
        boolean seenDot = false;
        boolean seenDigit = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '.' && !seenDot) {
                seenDot = true;
                validStr.append(c);
                continue;
            }
            if (!(c != '-' && c != '+' || seenDigit)) {
                validStr.append(c);
                continue;
            }
            if (Character.isDigit(c)) {
                seenDigit = true;
                validStr.append(c);
                continue;
            }
            if (!Character.isWhitespace(c)) break;
        }
        return NumberUtils.createNumber((String)validStr.toString());
    }

    default public String str(String v) {
        return "'" + v.replace("'", "''") + "'";
    }

    default public String str(String v, boolean doubleBackSlashes) {
        if (doubleBackSlashes) {
            return this.str(v).replace("\\", "\\\\");
        }
        return this.str(v);
    }

    public Long count(String var1, Object ... var2) throws SQLException;

    public Long countTbl(String var1, String var2) throws SQLException;

    public Long getLongValue(String var1, Object ... var2) throws SQLException;

    public int update(String var1, Object ... var2) throws SQLException;

    public void dropTable(String var1) throws SQLException;

    public List<Map<String, Object>> query(String var1, Object ... var2) throws SQLException;

    public Map<String, Object> queryFirst(String var1, Object ... var2) throws SQLException;

    public <T> List<T> getColumnList(String var1, int var2) throws SQLException;
}

