/*
 * Decompiled with CFR 0.152.
 */
package jrm.fullserver.security;

import java.io.IOException;
import java.security.Principal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.function.Function;
import javax.security.auth.Subject;
import jrm.fullserver.ServerSettings;
import jrm.fullserver.db.DB;
import jrm.fullserver.db.SQL;
import jrm.fullserver.security.CryptCredential;
import jrm.misc.Log;
import jrm.server.shared.WebSession;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.RolePrincipal;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.security.UserPrincipal;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.util.security.Credential;

public class Login
extends SQL
implements LoginService {
    private static final String ADMIN = "admin";
    protected IdentityService identityService = new DefaultIdentityService();
    private static final HashMap<String, UserIdentity> cache = new HashMap();
    private static long cachetime = System.currentTimeMillis();

    public Login() throws IOException, SQLException {
        super(true, new ServerSettings());
        this.db = DB.getInstance(this.getSettings()).connectToDB("Server.sys", false, true);
        this.update("CREATE TABLE IF NOT EXISTS USERS(LOGIN VARCHAR_IGNORECASE(255) PRIMARY KEY, PASSWORD VARCHAR(255), ROLES VARCHAR(255))", new Object[0]);
        if (this.count("SELECT * FROM USERS", new Object[0]) == 0L) {
            this.update("INSERT INTO USERS VALUES(?, ?, ?)", ADMIN, CryptCredential.hash(ADMIN), ADMIN);
        }
    }

    public String getName() {
        return "Authentication";
    }

    public UserIdentity login(String username, Object credentials, Request request, Function<Boolean, Session> getOrCreateSession) {
        String sessionid = null;
        WebSession sess = null;
        if (request instanceof Request) {
            Request r = request;
            Session session = getOrCreateSession.apply(true);
            if (session != null && (sessionid = session.getId()) != null) {
                sess = (WebSession)session.getAttribute("session");
            }
        }
        return this.login(username, credentials, sessionid, sess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserIdentity login(String username, Object credentials, String sessionid, WebSession sess) {
        HashMap<String, UserIdentity> hashMap = cache;
        synchronized (hashMap) {
            if (60000L < System.currentTimeMillis() - cachetime) {
                cache.clear();
                cachetime = System.currentTimeMillis();
            }
            if (sessionid != null && cache.containsKey(username + ":" + sessionid)) {
                return cache.get(username + ":" + sessionid);
            }
            CryptCredential credential = new CryptCredential(username, this);
            if (credential.check(credentials)) {
                String[] roles;
                UserPrincipal principal = new UserPrincipal(credential.getUser().getLogin(), (Credential)credential);
                Subject subject = new Subject();
                subject.getPrincipals().add((Principal)principal);
                subject.getPublicCredentials().add(username + ":" + sessionid);
                for (String role : roles = credential.getUser().getRoles().split(";")) {
                    subject.getPrincipals().add((Principal)new RolePrincipal(role));
                }
                UserIdentity identity = this.identityService.newUserIdentity(subject, (Principal)principal, roles);
                if (sessionid != null) {
                    cache.put(username + ":" + sessionid, identity);
                    sess.setUser(username, roles);
                }
                return identity;
            }
        }
        return null;
    }

    public boolean validate(UserIdentity user) {
        Log.debug((Object)"validate");
        for (Object credential : user.getSubject().getPublicCredentials()) {
            if (!cache.containsKey(credential)) continue;
            return true;
        }
        return false;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService service) {
    }

    public void logout(UserIdentity user) {
        for (Object credential : user.getSubject().getPublicCredentials()) {
            cache.remove(credential);
        }
    }

    @Override
    public String getContext() {
        return null;
    }
}

