/*
 * Decompiled with CFR 0.152.
 */
package jrm.fullserver.security;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import jrm.misc.Log;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SSLReload
extends TimerTask {
    private Timer timer = new Timer(true);
    private SslContextFactory sslcontext;

    private SSLReload(SslContextFactory sslcontext) {
        this.sslcontext = sslcontext;
    }

    public static SSLReload getInstance(SslContextFactory sslcontext) {
        return new SSLReload(sslcontext);
    }

    @Override
    public void run() {
        try {
            this.sslcontext.reload(scc -> Log.info((Object)"SSL certificate reloaded"));
        }
        catch (Exception e) {
            Log.err((String)"Error while reloading SSL certificate", (Throwable)e);
        }
        this.cancel();
        this.schedule();
    }

    private Date getTomorrowMidNight() {
        LocalDate tomorrow = LocalDate.now().plusDays(1L);
        return Date.from(tomorrow.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    private void schedule() {
        this.timer.schedule((TimerTask)this, this.getTomorrowMidNight());
    }

    public void start() {
        this.schedule();
    }
}

