/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.datasources;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import jrm.misc.Log;
import jrm.profile.data.Anyware;
import jrm.profile.data.AnywareList;
import jrm.profile.data.Machine;
import jrm.profile.data.MachineList;
import jrm.server.shared.datasources.XMLRequest;
import jrm.server.shared.datasources.XMLResponse;
import jrm.xml.SimpleAttribute;

public class AnywareListXMLResponse
extends XMLResponse {
    private static final String RESPONSE = "response";
    private static final String NAME = "name";
    private static final String SELECTED = "selected";
    private static final String SAMPLEOF = "sampleof";
    private static final String ROMOF = "romof";
    private static final String CLONEOF = "cloneof";
    private static final String DESCRIPTION = "description";
    private static final String STATUS = "status";

    public AnywareListXMLResponse(XMLRequest request) throws IOException, XMLStreamException {
        super(request);
    }

    private AnywareList<? extends Anyware> getList(XMLRequest.Operation operation) {
        String list = operation.getData("list");
        Object al = list == null ? null : (list.equals("*") ? (AnywareList)this.request.session.getCurrProfile().getMachineListList().get(0) : this.request.session.getCurrProfile().getMachineListList().getSoftwareListList().getByName(list));
        return al;
    }

    private Predicate<Anyware> getFilter(XMLRequest.Operation operation) {
        Set lstatus = operation.hasData(STATUS) ? Stream.of(operation.getData(STATUS).split(",")).collect(Collectors.toSet()) : null;
        String lname = operation.hasData(NAME) ? operation.getData(NAME).toLowerCase() : null;
        String ldesc = operation.hasData(DESCRIPTION) ? operation.getData(DESCRIPTION).toLowerCase() : null;
        String lcloneof = operation.hasData(CLONEOF) ? operation.getData(CLONEOF).toLowerCase() : null;
        String lromof = operation.hasData(ROMOF) ? operation.getData(ROMOF).toLowerCase() : null;
        String lsampleof = operation.hasData(SAMPLEOF) ? operation.getData(SAMPLEOF).toLowerCase() : null;
        Boolean lselected = operation.hasData(SELECTED) ? Boolean.valueOf(operation.getData(SELECTED)) : null;
        return ware -> !this.filterStatus(lstatus, (Anyware)ware) && !this.filterSelected(lselected, (Anyware)ware) && !this.filterName(lname, (Anyware)ware) && !this.filteDesc(ldesc, (Anyware)ware) && !this.filterCloneOf(lcloneof, (Anyware)ware) && !this.filterRomOf(lromof, (Anyware)ware) && !this.filterSampleOf(lsampleof, (Anyware)ware);
    }

    private boolean filterSampleOf(String lsampleof, Anyware ware) {
        Machine m;
        return lsampleof != null && ware instanceof Machine && ((m = (Machine)ware).getSampleof() == null || !m.getSampleof().toLowerCase().contains(lsampleof));
    }

    private boolean filterRomOf(String lromof, Anyware ware) {
        Machine m;
        return lromof != null && ware instanceof Machine && ((m = (Machine)ware).getRomof() == null || !m.getRomof().toLowerCase().contains(lromof));
    }

    private boolean filterCloneOf(String lcloneof, Anyware ware) {
        return lcloneof != null && (ware.getCloneof() == null || !ware.getCloneof().toLowerCase().contains(lcloneof));
    }

    private boolean filteDesc(String ldesc, Anyware ware) {
        return ldesc != null && !ware.description.toString().toLowerCase().contains(ldesc);
    }

    private boolean filterName(String lname, Anyware ware) {
        return lname != null && !ware.getBaseName().toLowerCase().contains(lname);
    }

    private boolean filterSelected(Boolean lselected, Anyware ware) {
        return lselected != null && ware.isSelected() != lselected.booleanValue();
    }

    private boolean filterStatus(Set<String> lstatus, Anyware ware) {
        return lstatus != null && !lstatus.contains(ware.getStatus().toString());
    }

    private Comparator<Anyware> getSorter(XMLRequest.Operation operation) {
        return (o1, o2) -> {
            if (operation.getSort().isEmpty()) {
                return o1.getBaseName().compareToIgnoreCase(o2.getBaseName());
            }
            for (XMLRequest.Operation.Sorter s : operation.getSort()) {
                switch (s.getName()) {
                    case "name": {
                        int ret = this.sortByName((Anyware)o1, (Anyware)o2, s);
                        if (ret == 0) break;
                        return ret;
                    }
                    case "description": {
                        int ret = this.sortByDesc((Anyware)o1, (Anyware)o2, s);
                        if (ret == 0) break;
                        return ret;
                    }
                }
            }
            return 0;
        };
    }

    private int sortByDesc(Anyware o1, Anyware o2, XMLRequest.Operation.Sorter s) {
        return (s.isDesc() ? o2 : o1).description.toString().compareToIgnoreCase((s.isDesc() ? o1 : o2).description.toString());
    }

    private int sortByName(Anyware o1, Anyware o2, XMLRequest.Operation.Sorter s) {
        return (s.isDesc() ? o2 : o1).getBaseName().compareToIgnoreCase((s.isDesc() ? o1 : o2).getBaseName());
    }

    private Stream<? extends Anyware> buildStream(AnywareList<? extends Anyware> al, XMLRequest.Operation operation) {
        return al.getFilteredList().stream().filter(this.getFilter(operation)).sorted(this.getSorter(operation));
    }

    private List<Anyware> buildList(AnywareList<?> al, XMLRequest.Operation operation) {
        return al.getFilteredList().stream().filter(this.getFilter(operation)).sorted(this.getSorter(operation)).collect(Collectors.toList());
    }

    private void writeRecord(AnywareList<?> al, Anyware aw) {
        try {
            this.writer.writeEmptyElement("record");
            this.writer.writeAttribute("list", al instanceof MachineList ? "*" : al.getBaseName());
            this.writer.writeAttribute(STATUS, aw.getStatus().toString());
            this.writer.writeAttribute(NAME, aw.getBaseName());
            this.writer.writeAttribute(DESCRIPTION, aw.getDescription().toString());
            this.writer.writeAttribute("have", String.format("%d/%d", aw.countHave(), aw.countAll()));
            if (aw.getCloneof() != null) {
                this.writer.writeAttribute(CLONEOF, aw.getCloneof());
                this.writer.writeAttribute("cloneof_status", ((Anyware)al.getByName(aw.getCloneof())).getStatus().toString());
            }
            if (aw instanceof Machine) {
                Machine m = (Machine)aw;
                MachineList ml = (MachineList)al;
                if (m.isIsbios()) {
                    this.writer.writeAttribute("type", "BIOS");
                } else if (m.isIsdevice()) {
                    this.writer.writeAttribute("type", "DEVICE");
                } else if (m.isIsmechanical()) {
                    this.writer.writeAttribute("type", "MECHANICAL");
                } else {
                    this.writer.writeAttribute("type", "STANDARD");
                }
                if (m.getRomof() != null) {
                    this.writer.writeAttribute(ROMOF, m.getRomof());
                    this.writer.writeAttribute("romof_status", ((Anyware)al.getByName(m.getRomof())).getStatus().toString());
                }
                if (m.getSampleof() != null) {
                    this.writer.writeAttribute(SAMPLEOF, m.getSampleof());
                    this.writer.writeAttribute("sampleof_status", ml.samplesets.getByName(m.getSampleof()).getStatus().toString());
                }
            }
            this.writer.writeAttribute(SELECTED, Boolean.toString(aw.isSelected()));
        }
        catch (XMLStreamException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void fetch(XMLRequest.Operation operation) throws XMLStreamException {
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        boolean reset = Boolean.parseBoolean(operation.getData("reset"));
        AnywareList<? extends Anyware> al = this.getList(operation);
        if (al != null) {
            if (reset) {
                al.resetCache();
            }
            this.fetchStream(operation, this.buildStream(al, operation), rec -> this.writeRecord(al, (Anyware)rec));
        }
        this.writer.writeEndElement();
    }

    @Override
    protected void update(XMLRequest.Operation operation) throws XMLStreamException {
        Anyware aw;
        String name;
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        AnywareList<? extends Anyware> al = this.getList(operation);
        if (al != null && (name = operation.getData(NAME)) != null && (aw = (Anyware)al.getByName(name)) != null) {
            Boolean selected = Boolean.valueOf(operation.getData(SELECTED));
            if (selected != null) {
                aw.setSelected(selected.booleanValue());
            }
            this.writeRecord(al, aw);
        }
        this.writer.writeEndElement();
    }

    @Override
    protected void custom(XMLRequest.Operation operation) throws XMLStreamException {
        if (operation.getOperationId().toString().equals("find")) {
            this.find(operation);
        } else if (operation.getOperationId().toString().equals("selectNone")) {
            this.selectNone(operation);
        } else if (operation.getOperationId().toString().equals("selectAll")) {
            this.selectAll(operation);
        } else if (operation.getOperationId().toString().equals("selectInvert")) {
            this.selectInvert(operation);
        } else {
            this.failure("custom operation with id " + String.valueOf(operation.getOperationId()) + " not implemented");
        }
    }

    private void selectInvert(XMLRequest.Operation operation) throws XMLStreamException {
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        AnywareList<? extends Anyware> al = this.getList(operation);
        if (al != null) {
            List<Anyware> list = this.buildList(al, operation);
            for (Anyware aw : list) {
                aw.setSelected(!aw.isSelected());
            }
        }
        this.writer.writeEndElement();
    }

    private void selectAll(XMLRequest.Operation operation) throws XMLStreamException {
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        AnywareList<? extends Anyware> al = this.getList(operation);
        if (al != null) {
            List<Anyware> list = this.buildList(al, operation);
            for (Anyware aw : list) {
                aw.setSelected(true);
            }
        }
        this.writer.writeEndElement();
    }

    private void selectNone(XMLRequest.Operation operation) throws XMLStreamException {
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        AnywareList<? extends Anyware> al = this.getList(operation);
        if (al != null) {
            List<Anyware> list = this.buildList(al, operation);
            for (Anyware aw : list) {
                aw.setSelected(false);
            }
        }
        this.writer.writeEndElement();
    }

    private void find(XMLRequest.Operation operation) throws XMLStreamException {
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        AnywareList<? extends Anyware> al = this.getList(operation);
        if (al != null && operation.hasData("find")) {
            List<Anyware> list = this.buildList(al, operation);
            String find = operation.getData("find");
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get(i).getBaseName().equals(find)) continue;
                this.writer.writeElement("found", (CharSequence)Integer.toString(i), new SimpleAttribute[0]);
                break;
            }
        }
        this.writer.writeEndElement();
    }
}

