/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.datasources;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import jrm.misc.Log;
import jrm.profile.data.Anyware;
import jrm.profile.data.AnywareList;
import jrm.profile.data.Disk;
import jrm.profile.data.EntityBase;
import jrm.profile.data.MachineList;
import jrm.profile.data.Rom;
import jrm.profile.data.Sample;
import jrm.server.shared.datasources.XMLRequest;
import jrm.server.shared.datasources.XMLResponse;
import jrm.xml.SimpleAttribute;

public class AnywareXMLResponse
extends XMLResponse {
    private static final String STATUS = "status";

    public AnywareXMLResponse(XMLRequest request) throws IOException, XMLStreamException {
        super(request);
    }

    private AnywareList<?> getList(XMLRequest.Operation operation) {
        String list = operation.getData("list");
        Object al = list == null ? null : (list.equals("*") ? (AnywareList)this.request.session.getCurrProfile().getMachineListList().get(0) : this.request.session.getCurrProfile().getMachineListList().getSoftwareListList().getByName(list));
        return al;
    }

    private Anyware getWare(AnywareList<?> al, XMLRequest.Operation operation) {
        String ware = operation.getData("ware");
        Anyware aw = ware == null || al == null ? null : (Anyware)al.getByName(ware);
        return aw;
    }

    private void writeRecord(AnywareList<?> al, Anyware aw, EntityBase e) {
        try {
            this.writer.writeEmptyElement("record");
            this.writer.writeAttribute("list", al instanceof MachineList ? "*" : al.getBaseName());
            this.writer.writeAttribute("ware", aw.getBaseName());
            this.writer.writeAttribute("name", e.getBaseName());
            this.writer.writeAttribute(STATUS, e.getStatus().toString());
            if (e instanceof Rom) {
                Rom r = (Rom)e;
                this.writeRomInfos(r);
            } else if (e instanceof Disk) {
                Disk dsk = (Disk)e;
                this.writeDiskInfos(dsk);
            } else if (e instanceof Sample) {
                this.writer.writeAttribute("type", "SAMPLE");
            }
        }
        catch (XMLStreamException ex) {
            Log.err((String)ex.getMessage(), (Throwable)ex);
        }
    }

    protected void writeDiskInfos(Disk d) throws XMLStreamException {
        this.writer.writeAttribute("type", "DISK");
        if (d.getSize() > 0L) {
            this.writer.writeAttribute("size", Long.toString(d.getSize()));
        }
        if (d.getCrc() != null) {
            this.writer.writeAttribute("crc", d.getCrc());
        }
        if (d.getMd5() != null) {
            this.writer.writeAttribute("md5", d.getMd5());
        }
        if (d.getSha1() != null) {
            this.writer.writeAttribute("sha1", d.getSha1());
        }
        if (d.getMerge() != null) {
            this.writer.writeAttribute("merge", d.getMerge());
        }
        if (d.getDumpStatus() != null) {
            this.writer.writeAttribute("dumpstatus", d.getDumpStatus().toString());
        }
    }

    protected void writeRomInfos(Rom r) throws XMLStreamException {
        this.writer.writeAttribute("type", "ROM");
        if (r.getSize() > 0L) {
            this.writer.writeAttribute("size", Long.toString(r.getSize()));
        }
        if (r.getCrc() != null) {
            this.writer.writeAttribute("crc", r.getCrc());
        }
        if (r.getMd5() != null) {
            this.writer.writeAttribute("md5", r.getMd5());
        }
        if (r.getSha1() != null) {
            this.writer.writeAttribute("sha1", r.getSha1());
        }
        if (r.getMerge() != null) {
            this.writer.writeAttribute("merge", r.getMerge());
        }
        if (r.getDumpStatus() != null) {
            this.writer.writeAttribute("dumpstatus", r.getDumpStatus().toString());
        }
    }

    @Override
    protected void fetch(XMLRequest.Operation operation) throws XMLStreamException {
        this.writer.writeStartElement("response");
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        Set lstatus = operation.hasData(STATUS) ? Stream.of(operation.getData(STATUS).split(",")).collect(Collectors.toSet()) : null;
        boolean reset = Boolean.parseBoolean(operation.getData("reset"));
        AnywareList<?> al = this.getList(operation);
        Anyware aw = this.getWare(al, operation);
        if (aw != null) {
            if (reset) {
                aw.resetCache();
            }
            ArrayList<EntityBase> faw = new ArrayList<EntityBase>();
            for (int i2 = 0; i2 < aw.count(); ++i2) {
                EntityBase a2 = aw.getObject(i2);
                if (lstatus != null && !lstatus.contains(a2.getStatus().toString())) continue;
                faw.add(a2);
            }
            this.fetchList(operation, faw, (a, i) -> this.writeRecord(al, aw, (EntityBase)a));
        }
        this.writer.writeEndElement();
    }
}

