/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.lpr;

import com.eclipsesource.json.Json;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jrm.misc.Log;
import jrm.server.shared.WebSession;
import jrm.server.shared.actions.ActionsMgr;

public class LongPollingReqMgr
implements ActionsMgr {
    private static final Map<String, LongPollingReqMgr> cmds = new HashMap<String, LongPollingReqMgr>();
    private WebSession session;

    public LongPollingReqMgr(WebSession session) {
        this.setSession(session);
    }

    public void process(String msg) {
        Log.debug((Object)msg);
        this.processActions(this, Json.parse((String)msg).asObject());
    }

    @Override
    public void setSession(WebSession session) {
        if (session == null) {
            throw new NullPointerException("Session not found");
        }
        cmds.put(session.getSessionId(), this);
        this.session = session;
    }

    @Override
    public void unsetSession(WebSession session) {
        this.saveSettings();
        cmds.remove(session.getSessionId());
    }

    @Override
    public void send(String msg) throws IOException {
        this.session.getLprMsg().add(msg);
    }

    @Override
    public void sendOptional(String msg) throws IOException {
        if (this.session.getLprMsg().isEmpty()) {
            this.session.getLprMsg().add(msg);
        }
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public WebSession getSession() {
        return this.session;
    }

    private void saveSettings() {
        if (this.session != null) {
            if (this.session.getCurrProfile() != null) {
                this.session.getCurrProfile().saveSettings();
            }
            this.session.getUser().getSettings().saveSettings();
            this.session = null;
        }
    }

    public static void saveAllSettings() {
        cmds.forEach((id, socket) -> socket.saveSettings());
    }
}

