/*
 * Decompiled with CFR 0.152.
 */
package jrm.fullserver;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.security.Provider;
import java.security.Security;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jrm.fullserver.handlers.FullDataSourceServlet;
import jrm.fullserver.handlers.SessionServlet;
import jrm.fullserver.security.Login;
import jrm.fullserver.security.SSLReload;
import jrm.misc.DefaultEnvironmentProperties;
import jrm.misc.Log;
import jrm.misc.URIUtils;
import jrm.server.AbstractServer;
import jrm.server.SessionListener;
import jrm.server.shared.handlers.ActionServlet;
import jrm.server.shared.handlers.DownloadServlet;
import jrm.server.shared.handlers.ImageServlet;
import jrm.server.shared.handlers.UploadServlet;
import org.apache.commons.daemon.DaemonContext;
import org.conscrypt.OpenSSLProvider;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.ee9.nested.ServletConstraint;
import org.eclipse.jetty.ee9.security.Authenticator;
import org.eclipse.jetty.ee9.security.ConstraintMapping;
import org.eclipse.jetty.ee9.security.ConstraintSecurityHandler;
import org.eclipse.jetty.ee9.security.SecurityHandler;
import org.eclipse.jetty.ee9.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.ee9.servlet.FilterHolder;
import org.eclipse.jetty.ee9.servlet.ServletContextHandler;
import org.eclipse.jetty.ee9.servlet.ServletHolder;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.AcceptRateLimit;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ConnectionLimit;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class FullServer
extends AbstractServer {
    private static final String KEY_STORE = "jrt:/jrm.merged.module/certs/";
    private static final String KEY_STORE_PATH_DEFAULT = "jrt:/jrm.merged.module/certs/localhost.pfx";
    private static final String KEY_STORE_PW_PATH_DEFAULT = "jrt:/jrm.merged.module/certs/localhost.pw";
    private static final String BIND_DEFAULT = "0.0.0.0";
    private static final int HTTP_PORT_DEFAULT = 8080;
    private static final int HTTPS_PORT_DEFAULT = 8443;
    private static final int PROTOCOLS_DEFAULT = 255;
    private static final int CONNLIMIT_DEFAULT = 50;
    private static final int RATELIMIT_DEFAULT = 5;
    private static final int MAXTHREADS_DEFAULT = 200;
    private static final int MINTHREADS_DEFAULT = 12;
    private static final int SESSIONTIMEOUT_DEFAULT = 300;
    private static Resource keyStorePath;
    private static String keyStorePWPath;
    private static int protocols;
    private static int httpPort;
    private static int httpsPort;
    private static String bind;
    private static int connLimit;
    private static int rateLimit;
    private static int maxThreads;
    private static int minThreads;
    private static int sessionTimeOut;
    private static final DefaultEnvironmentProperties env;

    private static void initFromEnv(Args jArgs) {
        Optional.ofNullable(env.getProperty("jrm.server.clientpath", jArgs.clientPath)).ifPresent(v -> {
            jArgs.clientPath = v;
        });
        Optional.ofNullable(env.getProperty("jrm.server.workpath", jArgs.workPath)).ifPresent(v -> {
            jArgs.workPath = v;
        });
        Optional.ofNullable(env.getProperty("jrm.server.debug", Boolean.valueOf(jArgs.debug))).ifPresent(v -> {
            jArgs.debug = v;
        });
        Optional.ofNullable(env.getProperty("jrm.server.cert", jArgs.cert)).ifPresent(v -> {
            jArgs.cert = v;
        });
        Optional.ofNullable(env.getProperty("jrm.server.https", Integer.valueOf(jArgs.httpsPort))).ifPresent(v -> {
            jArgs.httpsPort = v;
        });
        Optional.ofNullable(env.getProperty("jrm.server.http", Integer.valueOf(jArgs.httpPort))).ifPresent(v -> {
            jArgs.httpPort = v;
        });
        Optional.ofNullable(env.getProperty("jrm.server.bind", jArgs.bind)).ifPresent(v -> {
            jArgs.bind = v;
        });
        Optional.ofNullable(env.getProperty("jrm.server.connlimit", Integer.valueOf(jArgs.connlimit))).ifPresent(v -> {
            jArgs.connlimit = v;
        });
        Optional.ofNullable(env.getProperty("jrm.server.ratelimit", Integer.valueOf(jArgs.ratelimit))).ifPresent(v -> {
            jArgs.ratelimit = v;
        });
        Optional.ofNullable(env.getProperty("jrm.server.minthreads", Integer.valueOf(jArgs.minThreads))).ifPresent(v -> {
            jArgs.minThreads = v;
        });
        Optional.ofNullable(env.getProperty("jrm.server.maxthreads", Integer.valueOf(jArgs.maxThreads))).ifPresent(v -> {
            jArgs.maxThreads = v;
        });
        Optional.ofNullable(env.getProperty("jrm.server.sessiontimeout", Integer.valueOf(jArgs.sessionTimeOut))).ifPresent(v -> {
            jArgs.sessionTimeOut = v;
        });
    }

    public static void parseArgs(String ... args) throws IOException, URISyntaxException {
        Args jArgs = new Args();
        JCommander cmd = JCommander.newBuilder().addObject((Object)jArgs).build();
        try {
            FullServer.initFromEnv(jArgs);
            cmd.parse(args);
            debug = jArgs.debug;
            clientPath = jArgs.clientPath;
            bind = jArgs.bind;
            httpPort = jArgs.httpPort;
            httpsPort = jArgs.httpsPort;
            keyStorePath = Optional.ofNullable(FullServer.getCertsPath(jArgs.cert)).filter(p -> p.exists()).orElse(FullServer.getCertsPath(null));
            keyStorePWPath = Files.exists(FullServer.getPath(String.valueOf(keyStorePath) + ".pw"), new LinkOption[0]) ? String.valueOf(keyStorePath) + ".pw" : (keyStorePath != null && keyStorePath.getPath() != null && KEY_STORE_PATH_DEFAULT.equals(keyStorePath.getPath().toString()) && Files.exists(FullServer.getPath(KEY_STORE_PW_PATH_DEFAULT), new LinkOption[0]) ? KEY_STORE_PW_PATH_DEFAULT : null);
            Optional.ofNullable(jArgs.workPath).map(s -> s.replace("%HOMEPATH%", System.getProperty("user.home"))).ifPresent(s -> System.setProperty("jrommanager.dir", s));
            protocols = 255;
            connLimit = jArgs.connlimit;
            rateLimit = jArgs.ratelimit;
            minThreads = jArgs.minThreads;
            maxThreads = jArgs.maxThreads;
            sessionTimeOut = jArgs.sessionTimeOut;
            Locale.setDefault(Locale.US);
            System.setProperty("file.encoding", "UTF-8");
            Log.init((String)(FullServer.getLogPath() + "/Server.%g.log"), (boolean)false, (int)0x100000, (int)5);
        }
        catch (ParameterException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            e.printStackTrace();
            cmd.usage();
            System.exit(1);
        }
    }

    private static ServerConnector httpsConnector(Server jettyserver) throws IOException {
        SslContextFactory.Server sslContextFactory = FullServer.sslContext();
        SSLReload.getInstance((SslContextFactory)sslContextFactory).start();
        HttpConfiguration httpsConfig = FullServer.httpsConfig();
        SslConnectionFactory ssl = new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString());
        ServerConnector httpsConnector = new ServerConnector(jettyserver, new ConnectionFactory[]{ssl, new HttpConnectionFactory(httpsConfig)});
        httpsConnector.setPort(httpsPort);
        httpsConnector.setHost(bind);
        httpsConnector.setName("HTTPS");
        return httpsConnector;
    }

    private static ServerConnector http2Connector(Server jettyserver) throws IOException {
        SslContextFactory.Server sslContextFactory = FullServer.sslContext();
        SSLReload.getInstance((SslContextFactory)sslContextFactory).start();
        HttpConfiguration httpsConfig = FullServer.httpsConfig();
        HTTP2ServerConnectionFactory h2 = new HTTP2ServerConnectionFactory(httpsConfig);
        Security.insertProviderAt((Provider)new OpenSSLProvider(), 1);
        ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
        alpn.setDefaultProtocol(HttpVersion.HTTP_1_1.asString());
        SslConnectionFactory ssl = new SslConnectionFactory(sslContextFactory, alpn.getProtocol());
        ServerConnector http2Connector = new ServerConnector(jettyserver, new ConnectionFactory[]{ssl, alpn, h2, new HttpConnectionFactory(httpsConfig)});
        http2Connector.setPort(httpsPort);
        http2Connector.setHost(bind);
        http2Connector.setName("HTTP2");
        return http2Connector;
    }

    private static HttpConfiguration httpsConfig() {
        HttpConfiguration httpsConfig = new HttpConfiguration();
        httpsConfig.setSecureScheme("https");
        httpsConfig.setSecurePort(httpsPort);
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        return httpsConfig;
    }

    private static SslContextFactory.Server sslContext() throws IOException {
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStoreType("PKCS12");
        sslContextFactory.setKeyStorePath(keyStorePath.getURI().toString());
        sslContextFactory.setCipherComparator(HTTP2Cipher.COMPARATOR);
        sslContextFactory.setUseCipherSuitesOrder(true);
        String keyStorePassword = keyStorePWPath != null && Files.exists(FullServer.getPath(keyStorePWPath), new LinkOption[0]) ? URIUtils.readString((String)keyStorePWPath).trim() : "";
        sslContextFactory.setKeyStorePassword(keyStorePassword);
        sslContextFactory.setKeyManagerPassword(keyStorePassword);
        return sslContextFactory;
    }

    private static ServerConnector httpConnector(Server jettyserver, HttpConfiguration config) {
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(config);
        ServerConnector httpConnector = new ServerConnector(jettyserver, new ConnectionFactory[]{httpConnectionFactory});
        httpConnector.setPort(httpPort);
        httpConnector.setHost(bind);
        httpConnector.setName("HTTP");
        return httpConnector;
    }

    private static void setSecurity(ServletContextHandler context) throws IOException, SQLException {
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        security.setAuthenticator((Authenticator)new BasicAuthenticator());
        security.setLoginService((LoginService)new Login());
        ServletConstraint constraint = new ServletConstraint();
        constraint.setName("auth");
        constraint.setAuthenticate(true);
        constraint.setRoles(new String[]{"admin", "user"});
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(constraint);
        constraintMapping.setPathSpec("/*");
        security.setConstraintMappings(Collections.singletonList(constraintMapping));
        context.setSecurityHandler((SecurityHandler)security);
    }

    public static void main(String[] args) {
        try {
            FullServer.parseArgs(args);
            FullServer.initialize();
            FullServer.waitStop();
        }
        catch (InterruptedException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            System.exit(1);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    public static void initialize() throws Exception {
        if (jettyserver == null) {
            jettyserver = new Server((ThreadPool)new QueuedThreadPool(maxThreads > 0 ? maxThreads : connLimit * 4, minThreads > 0 ? minThreads : connLimit / 4));
            ServletContextHandler context = new ServletContextHandler(1);
            ResourceFactory resourceFactory = ResourceFactory.of((Container)context);
            context.setBaseResource(FullServer.getClientPath(resourceFactory, clientPath));
            context.setContextPath("/");
            context.addServlet(new ServletHolder("datasources", FullDataSourceServlet.class), "/datasources/*");
            context.addServlet(new ServletHolder("images", ImageServlet.class), "/images/*");
            context.addServlet(new ServletHolder("session", SessionServlet.class), "/session");
            context.addServlet(new ServletHolder("actions", ActionServlet.class), "/actions/*");
            context.addServlet(new ServletHolder("upload", UploadServlet.class), "/upload/*");
            context.addServlet(new ServletHolder("download", DownloadServlet.class), "/download/*");
            context.addFilter(new FilterHolder((request, response, chain) -> {
                if (request instanceof HttpServletRequest) {
                    HttpServletRequest httprequest = (HttpServletRequest)request;
                    if (response instanceof HttpServletResponse) {
                        HttpServletResponse httpresponse = (HttpServletResponse)response;
                        if (httprequest.getRequestURI().endsWith(".nocache.js")) {
                            httpresponse.setHeader("cache-control", "no-store");
                        } else if (!httprequest.getRequestURI().endsWith(".cache.js")) {
                            httpresponse.setHeader("cache-control", "public, max-age=0, must-revalidate");
                        }
                    }
                }
                chain.doFilter(request, response);
            }), "*.js", EnumSet.of(DispatcherType.REQUEST));
            context.addServlet(FullServer.holderStatic(), "/");
            FullServer.setSecurity(context);
            context.getSessionHandler().setMaxInactiveInterval(sessionTimeOut);
            context.getSessionHandler().addEventListener((EventListener)((Object)new SessionListener(true)));
            GzipHandler gh = FullServer.gzipHandler();
            gh.setHandler((Supplier)context);
            jettyserver.setHandler((Handler)gh);
            jettyserver.setStopAtShutdown(true);
            HttpConfiguration config = new HttpConfiguration();
            config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            config.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
            if ((protocols & 1) == 1) {
                jettyserver.addConnector((Connector)FullServer.httpConnector(jettyserver, config));
            }
            if ((protocols & 2) == 2 && keyStorePath.exists()) {
                if ((protocols & 4) == 4) {
                    jettyserver.addConnector((Connector)FullServer.http2Connector(jettyserver));
                } else {
                    jettyserver.addConnector((Connector)FullServer.httpsConnector(jettyserver));
                }
            }
            jettyserver.addBean((Object)new ConnectionLimit(connLimit, jettyserver));
            jettyserver.addBean((Object)new AcceptRateLimit(rateLimit > 0 ? rateLimit : connLimit / 10, 1L, TimeUnit.SECONDS, jettyserver));
            jettyserver.start();
            Log.config((Object)"Start server");
            for (Connector connector : jettyserver.getConnectors()) {
                Log.config((Object)(((ServerConnector)connector).getName() + " with port on " + ((ServerConnector)connector).getPort() + " binded to " + ((ServerConnector)connector).getHost()));
            }
            Log.config((Object)("clientPath: " + clientPath));
            Log.config((Object)("workPath: " + String.valueOf(FullServer.getWorkPath())));
        } else {
            Log.err((Object)"Already initialized");
        }
    }

    public void init(DaemonContext context) throws Exception {
        FullServer.parseArgs(context.getArguments());
        FullServer.initialize();
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public void destroy() {
        try {
            FullServer.terminate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void windowsService(String[] args) throws Exception {
        Log.info(() -> "WINDOW SERVICE " + Stream.of(args).collect(Collectors.joining(" ")));
        String cmd = "start";
        if (args.length > 0) {
            cmd = args[0];
        }
        try {
            FullServer.parseArgs(Arrays.copyOfRange(args, 1, args.length));
            if ("start".equals(cmd)) {
                FullServer.windowsStart();
            } else {
                FullServer.windowsStop();
            }
        }
        catch (Exception e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void windowsStart() throws Exception {
        Log.info((Object)"WIN START");
        FullServer.initialize();
        while (FullServer.isStopped()) {
            Class<Server> clazz = Server.class;
            // MONITORENTER : org.eclipse.jetty.server.Server.class
            Server.class.wait(60000L);
            // MONITOREXIT : clazz
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void windowsStop() throws Exception {
        Log.info((Object)"WIN STOP");
        FullServer.terminate();
        Class<Server> clazz = Server.class;
        synchronized (Server.class) {
            Server.class.notifyAll();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        connLimit = 50;
        rateLimit = 5;
        maxThreads = 200;
        minThreads = 12;
        sessionTimeOut = 300;
        env = DefaultEnvironmentProperties.getInstance(FullServer.class);
    }

    @Parameters(separators=" =")
    private static class Args {
        @Parameter(names={"-c", "--client", "--clientPath"}, arity=1, description="Client path")
        private String clientPath = null;
        @Parameter(names={"-w", "--work", "--workpath"}, arity=1, description="Working path")
        private String workPath = null;
        @Parameter(names={"-d", "--debug"}, description="Activate debug mode")
        private boolean debug = false;
        @Parameter(names={"-C", "--cert"}, arity=1, description="cert file, default is jrt:/jrm.merged.module/certs/localhost.pfx")
        private String cert = "jrt:/jrm.merged.module/certs/localhost.pfx";
        @Parameter(names={"-s", "--https"}, arity=1, description="https port, default is 8443")
        private int httpsPort = 8443;
        @Parameter(names={"-p", "--http"}, arity=1, description="http port, default is 8080")
        private int httpPort = 8080;
        @Parameter(names={"-b", "--bind"}, arity=1, description="bind to address or host, default is 0.0.0.0")
        private String bind = "0.0.0.0";
        @Parameter(names={"--conn-limit"}, arity=1, description="max simultaneous connection, default is 50")
        private int connlimit = 50;
        @Parameter(names={"--rate-limit"}, arity=1, description="max connection rate per second, default is 5")
        private int ratelimit = 5;
        @Parameter(names={"--max-threads"}, arity=1, description="max server threads, default is 200")
        private int maxThreads = 200;
        @Parameter(names={"--min-threads"}, arity=1, description="min server threads, default is 12")
        private int minThreads = 12;
        @Parameter(names={"--session-timeout"}, arity=1, description="session timeout, default is 300")
        private int sessionTimeOut = 12;

        private Args() {
        }
    }
}

