/*
 * Decompiled with CFR 0.152.
 */
package jrm.fullserver.security;

import de.mkammerer.argon2.Argon2;
import de.mkammerer.argon2.Argon2Factory;
import java.sql.SQLException;
import jrm.fullserver.db.SQL;
import jrm.fullserver.security.UserCredential;
import jrm.misc.Log;
import lombok.Generated;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.eclipse.jetty.util.security.Credential;
import org.mindrot.jbcrypt.BCrypt;

public class CryptCredential
extends Credential {
    private String username;
    private transient SQL sql;
    private transient UserCredential user;

    public CryptCredential(String username, SQL sql) {
        this.username = username;
        this.sql = sql;
    }

    public boolean check(Object credentials) {
        try {
            this.user = (UserCredential)this.sql.queryHandler("SELECT * FROM USERS WHERE LOGIN=?", new BeanHandler(UserCredential.class), new Object[]{this.username});
            if (null != this.user) {
                return CryptCredential.check(credentials.toString(), this.user.getPassword());
            }
        }
        catch (SQLException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static boolean check(String credentials, String password) {
        Argon2 argon2;
        return password.startsWith("$argon2") ? (argon2 = password.startsWith("$argon2id$") ? Argon2Factory.create((Argon2Factory.Argon2Types)Argon2Factory.Argon2Types.ARGON2id) : (password.startsWith("$argon2i$") ? Argon2Factory.create((Argon2Factory.Argon2Types)Argon2Factory.Argon2Types.ARGON2i) : (password.startsWith("$argon2d$") ? Argon2Factory.create((Argon2Factory.Argon2Types)Argon2Factory.Argon2Types.ARGON2d) : Argon2Factory.create()))).verify(password, credentials.toCharArray()) : BCrypt.checkpw((String)credentials, (String)password);
    }

    public static String hash(String password) {
        if (password.startsWith("$2a$") || password.startsWith("$argon2")) {
            return password;
        }
        try {
            password = Argon2Factory.create((Argon2Factory.Argon2Types)Argon2Factory.Argon2Types.ARGON2id).hash(40, 65536, 4, password.toCharArray());
        }
        catch (Exception e) {
            password = BCrypt.hashpw((String)password, (String)BCrypt.gensalt());
        }
        return password;
    }

    @Generated
    public UserCredential getUser() {
        return this.user;
    }
}

