/*
 * Decompiled with CFR 0.152.
 */
package jrm.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Scanner;
import jrm.fullserver.FullServer;
import jrm.misc.Log;
import jrm.server.shared.WebSession;
import org.apache.commons.daemon.Daemon;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.jetty.ee9.servlet.DefaultServlet;
import org.eclipse.jetty.ee9.servlet.ServletHolder;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;

public abstract class AbstractServer
implements Daemon {
    private static final String CACHE_CONTROL = "cacheControl";
    private static final String PRECOMPRESSED = "precompressed";
    private static final String ACCEPT_RANGES = "acceptRanges";
    private static final String DIR_ALLOWED = "dirAllowed";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    protected static String clientPath;
    protected static Server jettyserver;
    protected static boolean debug;

    protected AbstractServer() {
    }

    protected static ServletHolder holderStatic() {
        ServletHolder holderStatic = new ServletHolder("static", DefaultServlet.class);
        holderStatic.setInitParameter(DIR_ALLOWED, FALSE);
        holderStatic.setInitParameter(ACCEPT_RANGES, TRUE);
        holderStatic.setInitParameter(PRECOMPRESSED, TRUE);
        return holderStatic;
    }

    protected static ServletHolder holderStaticJS() {
        ServletHolder holderStaticJS = new ServletHolder("static_js", DefaultServlet.class);
        holderStaticJS.setInitParameter(DIR_ALLOWED, FALSE);
        holderStaticJS.setInitParameter(ACCEPT_RANGES, TRUE);
        holderStaticJS.setInitParameter(PRECOMPRESSED, TRUE);
        holderStaticJS.setInitParameter(CACHE_CONTROL, "public, max-age=0, must-revalidate");
        return holderStaticJS;
    }

    protected static ServletHolder holderStaticCache() {
        ServletHolder holderStaticCache = new ServletHolder("static_cache", DefaultServlet.class);
        holderStaticCache.setInitParameter(DIR_ALLOWED, FALSE);
        holderStaticCache.setInitParameter(ACCEPT_RANGES, TRUE);
        holderStaticCache.setInitParameter(PRECOMPRESSED, TRUE);
        return holderStaticCache;
    }

    protected static ServletHolder holderStaticNoCache() {
        ServletHolder holderStaticNoCache = new ServletHolder("static_nocache", DefaultServlet.class);
        holderStaticNoCache.setInitParameter(DIR_ALLOWED, FALSE);
        holderStaticNoCache.setInitParameter(ACCEPT_RANGES, TRUE);
        holderStaticNoCache.setInitParameter(PRECOMPRESSED, FALSE);
        holderStaticNoCache.setInitParameter(CACHE_CONTROL, "no-store");
        return holderStaticNoCache;
    }

    protected static GzipHandler gzipHandler() {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setIncludedMethods(new String[]{"POST", "GET"});
        gzipHandler.setIncludedMimeTypes(new String[]{"text/html", "text/plain", "text/xml", "text/css", "application/javascript", "text/javascript", "application/json"});
        gzipHandler.setInflateBufferSize(2048);
        gzipHandler.setMinGzipSize(2048);
        return gzipHandler;
    }

    protected static Path getWorkPath() {
        String base = System.getProperty("jrommanager.dir");
        if (base == null) {
            base = System.getProperty("user.dir");
        }
        return Paths.get(base, new String[0]);
    }

    protected static String getLogPath() throws IOException {
        Path path = AbstractServer.getWorkPath().resolve("logs");
        Files.createDirectories(path, new FileAttribute[0]);
        return path.toString();
    }

    protected static void waitStop() throws InterruptedException, JettyException {
        block11: {
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    if (AbstractServer.isStarted()) {
                        try {
                            AbstractServer.terminate();
                            Log.info((Object)"Server stopped.");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }));
                if (debug || SystemUtils.IS_OS_WINDOWS) {
                    try (Scanner sc = new Scanner(System.in);){
                        System.out.println("Enter 'stop' to halt: ");
                        while (!sc.nextLine().equalsIgnoreCase("stop")) {
                            Thread.sleep(1000L);
                        }
                        System.exit(0);
                        break block11;
                    }
                }
                if (AbstractServer.isStarted()) {
                    jettyserver.join();
                }
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JettyException(e.getMessage(), e);
            }
        }
    }

    public static synchronized void terminate() throws Exception {
        WebSession.closeAll();
        if (jettyserver != null) {
            if (jettyserver.isStarted()) {
                jettyserver.stop();
            }
            jettyserver = null;
        }
    }

    public static final synchronized boolean isStarted() {
        return jettyserver != null && jettyserver.isStarted();
    }

    public static final synchronized boolean isStopped() {
        return jettyserver == null;
    }

    protected static Resource getClientPath(ResourceFactory resourceFactory, String path) throws IOException, URISyntaxException {
        Resource resource;
        if (path != null) {
            resource = resourceFactory.newResource(path);
            if (Resources.exists((Resource)resource)) {
                return resource;
            }
            resource = resourceFactory.newClassLoaderResource(path, true);
            if (Resources.exists((Resource)resource)) {
                return resource;
            }
        }
        if (Resources.exists((Resource)(resource = resourceFactory.newResource("jrt:/jrm.merged.module/webclient/")))) {
            return resource;
        }
        URL url = FullServer.class.getResource("/webclient/");
        if (url != null && Resources.exists((Resource)(resource = resourceFactory.newResource(URIUtil.correctURI((URI)url.toURI()))))) {
            return resource;
        }
        throw new FileNotFoundException("Unable to find webclient path");
    }

    protected static Resource getCertsPath(String path) throws URISyntaxException, IOException {
        Resource resource;
        ResourceFactory resourceFactory = ResourceFactory.root();
        if (path != null) {
            resource = resourceFactory.newResource(path);
            if (Resources.exists((Resource)resource)) {
                return resource;
            }
            resource = resourceFactory.newClassLoaderResource(path, true);
            if (Resources.exists((Resource)resource)) {
                return resource;
            }
        }
        if (Resources.exists((Resource)(resource = resourceFactory.newResource("jrt:/jrm.merged.module/certs/localhost.pfx")))) {
            return resource;
        }
        URL url = FullServer.class.getResource("/certs/localhost.pfx");
        if (url != null && Resources.exists((Resource)(resource = resourceFactory.newResource(URIUtil.correctURI((URI)url.toURI()))))) {
            return resource;
        }
        throw new FileNotFoundException("Unable to find webclient path");
    }

    protected static Path getPath(String path) {
        try {
            return path.startsWith("jrt:") || path.startsWith("file:") || path.startsWith("jar:") ? Path.of(URI.create(path)) : Paths.get(path, new String[0]);
        }
        catch (FileSystemNotFoundException e) {
            URI uri = URI.create(path);
            try {
                FileSystems.newFileSystem(uri, Collections.emptyMap());
                return Path.of(uri);
            }
            catch (IOException e1) {
                return null;
            }
        }
    }

    static {
        jettyserver = null;
    }

    protected static class JettyException
    extends Exception {
        public JettyException() {
        }

        public JettyException(String message) {
            super(message);
        }

        public JettyException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

