/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.handlers;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import jrm.locale.Messages;
import jrm.server.shared.WebSession;

public abstract class AbstractSessionServlet
extends HttpServlet {
    protected void fillAndSendJSO(HttpServletRequest req, HttpServletResponse resp, JsonObject jso) throws IOException {
        WebSession ws = (WebSession)req.getSession().getAttribute("session");
        String sessionid = req.getSession().getId();
        jso.add("session", sessionid);
        JsonObject msgs = new JsonObject();
        List<Locale.LanguageRange> lr = Locale.LanguageRange.parse(req.getHeader("accept-language"));
        ws.setMsgs(Messages.loadBundle((Locale)(!lr.isEmpty() ? Locale.lookup(lr, Arrays.asList(Locale.getAvailableLocales())) : Locale.getDefault())));
        ResourceBundle rb = ws.getMsgs();
        rb.keySet().forEach(k -> {
            if (k != null && !k.isEmpty()) {
                msgs.add(k, rb.getString((String)k));
            }
        });
        jso.add("msgs", (JsonValue)msgs);
        jso.add("settings", (JsonValue)ws.getUser().getSettings().asJSO());
        String jsonStr = jso.toString();
        resp.setStatus(200);
        resp.setContentType("text/json");
        resp.setContentLength(jsonStr.getBytes("UTF-8").length);
        resp.getWriter().write(jsonStr);
        resp.getWriter().flush();
    }
}

