/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.actions;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jrm.aui.basic.AbstractSrcDstResult;
import jrm.aui.basic.ResultColUpdater;
import jrm.aui.basic.SDRList;
import jrm.aui.basic.SrcDstResult;
import jrm.aui.progress.ProgressHandler;
import jrm.batch.DirUpdater;
import jrm.misc.BreakException;
import jrm.misc.EnumWithDefault;
import jrm.misc.Log;
import jrm.misc.ProfileSettings;
import jrm.misc.SettingsEnum;
import jrm.security.PathAbstractor;
import jrm.security.Session;
import jrm.server.shared.WebSession;
import jrm.server.shared.Worker;
import jrm.server.shared.actions.ActionsMgr;
import jrm.server.shared.actions.GlobalActions;
import jrm.server.shared.actions.ProgressActions;
import org.apache.commons.lang3.StringUtils;

public class Dat2DirActions {
    private static final String PARAMS = "params";
    private final ActionsMgr ws;
    private final Gson gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).create();

    public Dat2DirActions(ActionsMgr ws) {
        this.ws = ws;
    }

    public void start(JsonObject jso) {
        this.ws.getSession().setWorker(new Worker(() -> {
            final WebSession session = this.ws.getSession();
            boolean dryrun = (Boolean)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dat2dir_dry_run, Boolean.class);
            session.getWorker().progress = new ProgressActions(this.ws);
            try {
                String[] srcdirs = StringUtils.split((String)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dat2dir_srcdirs), (char)'|');
                if (srcdirs.length > 0) {
                    final SDRList sdrl = SrcDstResult.fromJSON((String)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dat2dir_sdr));
                    if (sdrl.stream().filter(sdr -> !session.getUser().getSettings().getProfileSettingsFile(PathAbstractor.getAbsolutePath((Session)session, (String)sdr.getSrc()).toFile()).exists()).count() > 0L) {
                        new GlobalActions(this.ws).warn(this.ws.getSession().getMsgs().getString("MainFrame.AllDatsPresetsAssigned"));
                    } else {
                        new DirUpdater((Session)session, (List)sdrl, (ProgressHandler)session.getWorker().progress, Stream.of(srcdirs).map(s -> PathAbstractor.getAbsolutePath((Session)session, (String)s).toFile()).collect(Collectors.toList()), new ResultColUpdater(){

                            public void updateResult(int row, String result) {
                                ((SrcDstResult)sdrl.get(row)).setResult(result);
                                session.getUser().getSettings().setProperty((Enum)SettingsEnum.dat2dir_sdr, AbstractSrcDstResult.toJSON((List)sdrl));
                                session.getUser().getSettings().saveSettings();
                                Dat2DirActions.this.updateResult(row, result);
                            }

                            public void clearResults() {
                                sdrl.forEach(sdr -> sdr.setResult(""));
                                session.getUser().getSettings().setProperty((Enum)SettingsEnum.dat2dir_sdr, AbstractSrcDstResult.toJSON((List)sdrl));
                                session.getUser().getSettings().saveSettings();
                                Dat2DirActions.this.clearResults();
                            }
                        }, dryrun);
                    }
                } else {
                    new GlobalActions(this.ws).warn(this.ws.getSession().getMsgs().getString("MainFrame.AtLeastOneSrcDir"));
                }
            }
            catch (BreakException breakException) {
            }
            finally {
                this.end();
                session.setCurrProfile(null);
                session.setCurrScan(null);
                session.getWorker().progress.close();
                session.getWorker().progress = null;
                session.setLastAction(new Date());
            }
        })).start();
    }

    public void settings(JsonObject jso) {
        JsonArray srcs = jso.get(PARAMS).asObject().get("srcs").asArray();
        if (srcs != null && srcs.size() > 0) {
            String src = srcs.get(0).asString();
            try {
                WebSession session = this.ws.getSession();
                ProfileSettings settings = this.ws.getSession().getUser().getSettings().loadProfileSettings(PathAbstractor.getAbsolutePath((Session)session, (String)src).toFile(), null);
                if (this.ws.isOpen()) {
                    JsonObject msg = new JsonObject();
                    msg.add("cmd", "Dat2Dir.showSettings");
                    JsonObject params = new JsonObject();
                    params.add("settings", (JsonValue)settings.asJSO());
                    params.add("srcs", (JsonValue)srcs);
                    msg.add(PARAMS, (JsonValue)params);
                    this.ws.send(msg.toString());
                }
            }
            catch (IOException e) {
                Log.err((String)e.getMessage(), (Throwable)e);
            }
        }
    }

    void updateResult(int row, String result) {
        try {
            if (this.ws.isOpen()) {
                this.ws.send(this.gson.toJson((Object)new ActionsMgr.UpdateResult("Dat2Dir.updateResult", new ActionsMgr.UpdateResult.Params(row, result))));
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    void clearResults() {
        try {
            if (this.ws.isOpen()) {
                this.ws.send(this.gson.toJson((Object)new ActionsMgr.SingleCmd("Dat2Dir.clearResults")));
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    void end() {
        try {
            if (this.ws.isOpen()) {
                this.ws.send(this.gson.toJson((Object)new ActionsMgr.SingleCmd("Dat2Dir.end")));
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }
}

