/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.actions;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import jrm.misc.Log;
import jrm.server.shared.actions.ActionsMgr;

public class GlobalActions {
    private static final String PARAMS = "params";
    private static final String FF_MI_B = "%.2f MiB";
    private final ActionsMgr ws;

    public GlobalActions(ActionsMgr ws) {
        this.ws = ws;
    }

    public void setProperty(JsonObject jso) {
        JsonObject pjso = jso.get(PARAMS).asObject();
        for (JsonObject.Member m : pjso) {
            JsonValue value = m.getValue();
            if (value.isBoolean()) {
                this.ws.getSession().getUser().getSettings().setProperty(m.getName(), value.asBoolean());
                continue;
            }
            if (value.isString()) {
                this.ws.getSession().getUser().getSettings().setProperty(m.getName(), value.asString());
                continue;
            }
            this.ws.getSession().getUser().getSettings().setProperty(m.getName(), value.toString());
        }
        try {
            if (this.ws.isOpen()) {
                this.ws.getSession().getUser().getSettings().saveSettings();
                JsonObject rjso = new JsonObject();
                rjso.add("cmd", "Global.updateProperty");
                rjso.add(PARAMS, (JsonValue)pjso);
                this.ws.send(rjso.toString());
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    public void setMemory(JsonObject jso) {
        try {
            if (this.ws.isOpen()) {
                Runtime rt = Runtime.getRuntime();
                String msg = String.format(this.ws.getSession().getMsgs().getString("MainFrame.MemoryUsage"), String.format(FF_MI_B, (double)rt.totalMemory() / 1048576.0), String.format(FF_MI_B, (double)(rt.totalMemory() - rt.freeMemory()) / 1048576.0), String.format(FF_MI_B, (double)rt.freeMemory() / 1048576.0), String.format(FF_MI_B, (double)rt.maxMemory() / 1048576.0));
                JsonObject rjso = new JsonObject();
                rjso.add("cmd", "Global.setMemory");
                JsonObject params = new JsonObject();
                params.add("msg", msg);
                rjso.add(PARAMS, (JsonValue)params);
                this.ws.send(rjso.toString());
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    public void gc(JsonObject jso) {
        System.gc();
        this.setMemory(jso);
    }

    public void warn(String msg) {
        try {
            if (this.ws.isOpen()) {
                JsonObject rjso = new JsonObject();
                rjso.add("cmd", "Global.warn");
                JsonObject params = new JsonObject();
                params.add("msg", msg);
                rjso.add(PARAMS, (JsonValue)params);
                this.ws.send(rjso.toString());
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }
}

