/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.actions;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import jrm.misc.Log;
import jrm.profile.report.FilterOptions;
import jrm.profile.report.Report;
import jrm.server.shared.actions.ActionsMgr;

public class ReportActions {
    private final ActionsMgr ws;

    public ReportActions(ActionsMgr ws) {
        this.ws = ws;
    }

    public void setFilter(JsonObject jso, boolean lite) {
        JsonObject pjso = jso.get("params").asObject();
        Report report = lite ? this.ws.getSession().getTmpReport() : this.ws.getSession().getReport();
        Object options = ((EnumSet)report.getHandler().getFilterOptions()).clone();
        for (JsonObject.Member m : pjso) {
            try {
                FilterOptions option = FilterOptions.valueOf((String)m.getName());
                JsonValue value = m.getValue();
                if (value.asBoolean()) {
                    options.add(option);
                    continue;
                }
                options.remove(option);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        report.getHandler().filter(options.toArray(new FilterOptions[0]));
        try {
            if (this.ws.isOpen()) {
                JsonObject params = new JsonObject();
                EnumSet.allOf(FilterOptions.class).forEach(arg_0 -> ReportActions.lambda$setFilter$0(params, (Set)options, arg_0));
                this.ws.send(Json.object().add("cmd", lite ? "ReportLite.applyFilters" : "Report.applyFilters").add("params", (JsonValue)params).toString());
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    private static /* synthetic */ void lambda$setFilter$0(JsonObject params, Set options, FilterOptions f) {
        params.add(f.toString(), options.contains(f));
    }
}

