/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.datasources;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import jrm.misc.EnumWithDefault;
import jrm.misc.SettingsEnum;
import jrm.server.shared.datasources.XMLRequest;
import jrm.server.shared.datasources.XMLResponse;
import jrm.xml.SimpleAttribute;
import org.apache.commons.lang3.StringUtils;

public class BatchDat2DirSrcXMLResponse
extends XMLResponse {
    private static final String RECORD = "record";
    private static final String STATUS = "status";
    private static final String RESPONSE = "response";

    public BatchDat2DirSrcXMLResponse(XMLRequest request) throws IOException, XMLStreamException {
        super(request);
    }

    @Override
    protected void fetch(XMLRequest.Operation operation) throws XMLStreamException {
        String[] srcdirs = this.getSrcDirs();
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        this.fetchArray(operation, srcdirs.length, (i, count) -> this.writeRecord(srcdirs[i]));
        this.writer.writeEndElement();
    }

    private String[] getSrcDirs() {
        return StringUtils.split((String)this.request.getSession().getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dat2dir_srcdirs), (char)'|');
    }

    @Override
    protected void add(XMLRequest.Operation operation) throws XMLStreamException {
        if (operation.hasData("name")) {
            List<String> lsrcdirs = Stream.of(this.getSrcDirs()).collect(Collectors.toList());
            List<String> names = operation.getDatas("name").stream().filter(n -> !lsrcdirs.contains(n)).toList();
            if (!names.isEmpty()) {
                lsrcdirs.addAll(names);
                this.save(lsrcdirs);
                this.writeResponse(operation, names);
            } else {
                this.failure("Entry already exists");
            }
        } else {
            this.failure("name is missing in request");
        }
    }

    private void writeResponse(XMLRequest.Operation operation, List<String> names) throws XMLStreamException {
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        this.fetchList(operation, names, (name, idx) -> this.writeRecord((String)name));
        this.writer.writeEndElement();
    }

    private void save(List<String> lsrcdirs) {
        this.request.getSession().getUser().getSettings().setProperty((Enum)SettingsEnum.dat2dir_srcdirs, lsrcdirs.stream().collect(Collectors.joining("|")));
        this.request.getSession().getUser().getSettings().saveSettings();
    }

    private void writeRecord(String name) throws XMLStreamException {
        this.writer.writeElement(RECORD, new SimpleAttribute[]{new SimpleAttribute("name", (Object)name)});
    }

    @Override
    protected void remove(XMLRequest.Operation operation) throws XMLStreamException {
        if (operation.hasData("name")) {
            List<String> lsrcdirs = Stream.of(this.getSrcDirs()).collect(Collectors.toList());
            List<String> names = operation.getDatas("name").stream().filter(lsrcdirs::contains).toList();
            if (!names.isEmpty()) {
                lsrcdirs.removeAll(names);
                this.save(lsrcdirs);
                this.writeResponse(operation, names);
            } else {
                this.failure("Entry does not exist");
            }
        } else {
            this.failure("name is missing in request");
        }
    }
}

