/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.datasources;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jrm.misc.Log;
import jrm.misc.Tree;
import jrm.profile.manager.Dir;
import jrm.profile.manager.DirTree;
import jrm.server.shared.datasources.XMLRequest;
import jrm.server.shared.datasources.XMLResponse;
import jrm.xml.SimpleAttribute;
import org.apache.commons.io.FileUtils;

public class ProfilesTreeXMLResponse
extends XMLResponse {
    private static final String STATUS = "status";
    private static final String RESPONSE = "response";
    private static final String PARENT_ID = "ParentID";
    private static final String IS_FOLDER = "isFolder";
    private static final String TITLE = "title";
    private static final String RECORD = "record";

    public ProfilesTreeXMLResponse(XMLRequest request) throws IOException, XMLStreamException {
        super(request);
    }

    private int countNode(Tree.Node<Dir> node) {
        int count = 0;
        for (Tree.Node child : node) {
            if (child.getChildCount() > 0) {
                count += this.countNode((Tree.Node<Dir>)child);
                continue;
            }
            ++count;
        }
        return count;
    }

    private void outputNode(XMLStreamWriter writer, Tree.Node<Dir> node, String parentID, AtomicInteger id) throws XMLStreamException {
        String strID = id.toString();
        if (id.get() > 0) {
            this.request.getSession().putProfileList(id.get(), ((Dir)node.getData()).getFile().toPath());
            writer.writeStartElement(RECORD);
            writer.writeAttribute("ID", id.toString());
            writer.writeAttribute("Path", this.pathAbstractor.getRelativePath(((Dir)node.getData()).getFile().toPath()).toString());
            writer.writeAttribute(TITLE, ((Dir)node.getData()).getFile().getName());
            writer.writeAttribute(IS_FOLDER, "true");
            if (parentID != null) {
                writer.writeAttribute(PARENT_ID, parentID);
            }
            writer.writeEndElement();
        } else {
            this.request.getSession().newProfileList();
        }
        id.incrementAndGet();
        for (Tree.Node child : node) {
            this.outputNode(writer, (Tree.Node<Dir>)child, strID, id);
        }
    }

    @Override
    protected void fetch(XMLRequest.Operation operation) throws XMLStreamException, IOException {
        Path rootpath = this.request.getSession().getUser().getSettings().getWorkPath().resolve("xmlfiles").toAbsolutePath().normalize();
        Files.createDirectories(rootpath, new FileAttribute[0]);
        DirTree root = new DirTree(rootpath.toFile());
        int nodecount = this.countNode((Tree.Node<Dir>)root.getRoot());
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        this.writer.writeElement("startRow", (CharSequence)"0", new SimpleAttribute[0]);
        this.writer.writeElement("endRow", (CharSequence)Integer.toString(nodecount - 1), new SimpleAttribute[0]);
        this.writer.writeElement("totalRows", (CharSequence)Integer.toString(nodecount), new SimpleAttribute[0]);
        this.writer.writeStartElement("data");
        this.outputNode((XMLStreamWriter)this.writer, (Tree.Node<Dir>)root.getRoot(), null, new AtomicInteger());
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    @Override
    protected void add(XMLRequest.Operation operation) throws XMLStreamException, IOException {
        int key = this.request.getSession().getLastProfileListKey() + 1;
        String basepath = operation.getData("Path");
        if (basepath == null || basepath.isEmpty()) {
            basepath = this.request.getSession().getUser().getSettings().getWorkPath().resolve("xmlfiles").toAbsolutePath().normalize().toString();
        }
        Path path = Files.createDirectory(Paths.get(basepath, operation.getData(TITLE)), new FileAttribute[0]);
        this.request.getSession().putProfileList(key, path);
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        this.writer.writeStartElement("data");
        this.writer.writeStartElement(RECORD);
        this.writer.writeAttribute("ID", Integer.toString(key));
        this.writer.writeAttribute("Path", this.pathAbstractor.getRelativePath(path).toString());
        this.writer.writeAttribute(TITLE, operation.getData(TITLE));
        this.writer.writeAttribute(IS_FOLDER, "true");
        this.writer.writeAttribute(PARENT_ID, operation.getData(PARENT_ID));
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    @Override
    protected void update(XMLRequest.Operation operation) throws XMLStreamException, IOException {
        Integer id = Integer.valueOf(operation.getData("ID"));
        Path path = this.request.getSession().getProfileList(id);
        Log.debug((Object)path);
        String title = operation.getData(TITLE);
        path = Files.move(path, path.getParent().resolve(title), new CopyOption[0]);
        this.request.getSession().putProfileList(id, path);
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        this.writer.writeStartElement("data");
        this.writer.writeStartElement(RECORD);
        this.writer.writeAttribute("ID", id.toString());
        this.writer.writeAttribute("Path", this.pathAbstractor.getRelativePath(path).toString());
        this.writer.writeAttribute(TITLE, title);
        this.writer.writeAttribute(IS_FOLDER, "true");
        this.writer.writeAttribute(PARENT_ID, operation.getOldValues().get(PARENT_ID));
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    @Override
    protected void remove(XMLRequest.Operation operation) throws XMLStreamException, IOException {
        Integer id = Integer.valueOf(operation.getData("ID"));
        Path path = this.request.getSession().getProfileList(id);
        FileUtils.deleteDirectory((File)path.toFile());
        this.request.getSession().removeProfileList(id);
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        this.writer.writeStartElement("data");
        this.writer.writeStartElement(RECORD);
        this.writer.writeAttribute("ID", id.toString());
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }
}

