/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.datasources;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLStreamException;
import jrm.misc.Log;
import jrm.server.shared.datasources.XMLRequest;
import jrm.server.shared.datasources.XMLResponse;
import jrm.xml.SimpleAttribute;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class RemoteFileChooserXMLResponse
extends XMLResponse {
    private static final String PARENT = "parent";
    private static final String PATHS = "paths";
    private static final String REL_PATH = "RelPath";
    private static final String INITIAL_PATH = "initialPath";
    private static final String IS_DIR = "isDir";
    private static final String MODIFIED = "Modified";
    private static final String RECORD = "record";
    private static final String STATUS = "status";
    private static final String RESPONSE = "response";
    private static final String CONTEXT = "context";
    Path root;
    Options options = null;

    public RemoteFileChooserXMLResponse(XMLRequest request) throws IOException, XMLStreamException {
        super(request);
    }

    @Override
    protected void fetch(XMLRequest.Operation operation) throws XMLStreamException, IOException {
        if (operation.hasData(CONTEXT)) {
            this.options = new Options(operation.getData(CONTEXT));
        }
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        this.writer.writeElement("startRow", (CharSequence)"0", new SimpleAttribute[0]);
        Path parent = this.writeParent(this.getParent(operation));
        PathMatcher matcher = this.options.pathmatcher != null ? parent.getFileSystem().getPathMatcher(this.options.pathmatcher) : null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(parent, entry -> {
            if (this.options.isDir) {
                return Files.isDirectory(entry, LinkOption.NOFOLLOW_LINKS);
            }
            if (matcher != null && Files.isRegularFile(entry, new LinkOption[0])) {
                return matcher.matches(entry.getFileName());
            }
            return true;
        });){
            long cnt = 0L;
            this.writer.writeStartElement("data");
            if (!parent.equals(this.root) && parent.getParent() != null) {
                this.writer.writeStartElement(RECORD);
                this.writer.write("Name", (Object)"..");
                this.writer.write("Path", (Object)this.pathAbstractor.getRelativePath(parent).getParent());
                this.writer.write("Size", (Object)-1);
                this.writer.write(MODIFIED, (Object)Files.getLastModifiedTime(parent.getParent(), new LinkOption[0]));
                this.writer.write(IS_DIR, (Object)true);
                this.writer.writeEndElement();
                ++cnt;
            }
            Optional initialPath = operation.hasData(INITIAL_PATH) ? CaseInsensitiveFileFinder.findFileIgnoreCase(this.pathAbstractor.getAbsolutePath(operation.getData(INITIAL_PATH))) : Optional.empty();
            for (Path entry2 : stream) {
                BasicFileAttributeView view = Files.getFileAttributeView(entry2, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
                BasicFileAttributes attr = view.readAttributes();
                this.writer.writeStartElement(RECORD);
                this.writer.write("Name", (Object)entry2.getFileName());
                this.writer.write("Path", (Object)this.pathAbstractor.getRelativePath(entry2));
                this.writer.write(REL_PATH, (Object)this.pathAbstractor.getRelativePath(entry2));
                this.writer.write("Size", (Object)(!attr.isRegularFile() ? -1L : attr.size()));
                this.writer.write(MODIFIED, (Object)attr.lastModifiedTime());
                this.writer.write(IS_DIR, (Object)attr.isDirectory());
                if (initialPath.isPresent() && entry2.equals(initialPath.get())) {
                    this.writer.write("isSelected", (Object)true);
                }
                this.writer.writeEndElement();
                ++cnt;
            }
            this.writer.writeEndElement();
            this.writer.writeElement("endRow", (CharSequence)Long.toString(cnt - 1L), new SimpleAttribute[0]);
            this.writer.writeElement("totalRows", (CharSequence)Long.toString(cnt), new SimpleAttribute[0]);
        }
        this.writer.writeEndElement();
    }

    @Override
    protected void add(XMLRequest.Operation operation) throws XMLStreamException {
        if (operation.hasData(CONTEXT)) {
            this.options = new Options(operation.getData(CONTEXT));
        }
        Path parent = this.getParent(operation);
        String name = operation.getData("Name");
        Path entry = parent.resolve(name);
        if (name != null && Files.isDirectory(parent, new LinkOption[0]) && !Files.exists(entry, new LinkOption[0])) {
            try {
                Files.createDirectory(entry, new FileAttribute[0]);
                this.writeResponseSingle(parent, entry);
            }
            catch (Exception ex) {
                this.failure(ex.getMessage());
            }
        } else {
            this.failure("Can't create " + name);
        }
    }

    protected void writeResponseSingle(Path parent, Path entry) throws XMLStreamException, IOException {
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        this.writeParent(parent);
        this.writer.writeStartElement("data");
        this.writer.writeStartElement(RECORD);
        this.writer.writeAttribute("Name", entry.getFileName().toString());
        this.writer.writeAttribute("Path", this.pathAbstractor.getRelativePath(entry).toString());
        this.writer.writeAttribute(REL_PATH, this.pathAbstractor.getRelativePath(entry).toString());
        this.writer.writeAttribute("Size", "-1");
        this.writer.writeAttribute(MODIFIED, Files.getLastModifiedTime(entry, new LinkOption[0]).toString());
        this.writer.writeAttribute(IS_DIR, Boolean.TRUE.toString());
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    @Override
    protected void update(XMLRequest.Operation operation) throws XMLStreamException {
        if (operation.hasData(CONTEXT)) {
            this.options = new Options(operation.getData(CONTEXT));
        }
        Path parent = this.getParent(operation);
        String name = operation.getData("Name");
        String oldname = operation.oldValues.get("Name");
        Path entry = parent.resolve(name);
        Path oldentry = parent.resolve(oldname);
        if (name != null && oldname != null && Files.isDirectory(parent, new LinkOption[0]) && Files.exists(oldentry, new LinkOption[0]) && !Files.exists(entry, new LinkOption[0])) {
            try {
                Files.move(oldentry, entry, new CopyOption[0]);
                this.writeResponseSingle(parent, entry);
            }
            catch (Exception ex) {
                this.failure(ex.getMessage());
            }
        } else {
            this.failure("Can't update " + oldname + " to " + name);
        }
    }

    @Override
    protected void remove(XMLRequest.Operation operation) throws XMLStreamException {
        if (operation.hasData(CONTEXT)) {
            this.options = new Options(operation.getData(CONTEXT));
        }
        Path parent = this.getParent(operation);
        String name = operation.getData("Name");
        Path entry = parent.resolve(name);
        if (name != null && Files.exists(entry, new LinkOption[0])) {
            try {
                try (Stream<Path> stream = Files.walk(entry, new FileVisitOption[0]);){
                    stream.map(Path::toFile).sorted(Comparator.reverseOrder()).forEach(File::delete);
                }
                this.writer.writeStartElement(RESPONSE);
                this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
                this.writeParent(parent);
                this.writer.writeStartElement("data");
                this.writer.writeStartElement(RECORD);
                this.writer.writeAttribute("Name", entry.getFileName().toString());
                this.writer.writeEndElement();
                this.writer.writeEndElement();
                this.writer.writeEndElement();
            }
            catch (Exception ex) {
                this.failure(ex.getMessage());
            }
        } else {
            this.failure("Can't remove " + name);
        }
    }

    @Override
    protected void custom(XMLRequest.Operation operation) throws XMLStreamException, IOException {
        if (operation.getOperationId().toString().equals("expand")) {
            this.customExpand(operation);
        } else if (operation.operationId.toString().equals("extract_subfolder")) {
            if (operation.hasData("Path")) {
                Path zipfile = this.pathAbstractor.getAbsolutePath(operation.getData("Path"));
                Path dest = zipfile.getParent().resolve(StringUtils.substring((String)zipfile.getFileName().toString(), (int)0, (int)-4));
                this.unzip(zipfile, dest);
                this.success();
            } else {
                this.failure("path missing");
            }
        } else if (operation.operationId.toString().equals("extract_here")) {
            if (operation.hasData("Path")) {
                Path zipfile = this.pathAbstractor.getAbsolutePath(operation.getData("Path"));
                Path dest = zipfile.getParent();
                this.unzip(zipfile, dest);
                this.success();
            } else {
                this.failure("path missing");
            }
        } else {
            super.custom(operation);
        }
    }

    private void customExpand(XMLRequest.Operation operation) throws XMLStreamException, SecurityException, IOException {
        if (operation.hasData(PATHS)) {
            Path dir = this.request.getSession().getUser().getSettings().getWorkPath();
            if (operation.hasData(PARENT)) {
                dir = new File(operation.getData(PARENT)).toPath();
            }
            this.writer.writeStartElement(RESPONSE);
            this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
            this.writer.writeElement(PARENT, (CharSequence)dir.toString(), new SimpleAttribute[0]);
            this.writer.writeStartElement("data");
            AtomicInteger cnt = new AtomicInteger();
            if ("addArc".equals(operation.getData(CONTEXT))) {
                this.customExpandAddArc(operation, cnt);
            } else {
                for (String path : operation.getDatas(PATHS)) {
                    Path entry = Paths.get(path, new String[0]);
                    this.writer.writeEmptyElement(RECORD);
                    this.writer.writeAttribute("Name", entry.getFileName().toString());
                    this.writer.writeAttribute("Path", this.pathAbstractor.getRelativePath(entry).toString());
                    cnt.incrementAndGet();
                }
            }
            this.writer.writeEndElement();
            this.writer.writeElement("endRow", (CharSequence)Long.toString((long)cnt.get() - 1L), new SimpleAttribute[0]);
            this.writer.writeElement("totalRows", (CharSequence)Long.toString(cnt.get()), new SimpleAttribute[0]);
            this.writer.writeEndElement();
        } else {
            this.failure("paths missing");
        }
    }

    private void customExpandAddArc(XMLRequest.Operation operation, final AtomicInteger cnt) throws SecurityException, IOException {
        for (String path : operation.getDatas(PATHS)) {
            Path entry = this.pathAbstractor.getAbsolutePath(path);
            Files.walkFileTree(entry, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                String[] exts = new String[]{"zip", "7z", "rar", "arj", "tar", "lzh", "lha", "tgz", "tbz", "tbz2", "rpm", "iso", "deb", "cab"};

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (FilenameUtils.isExtension((String)file.getFileName().toString(), (String[])this.exts)) {
                        try {
                            RemoteFileChooserXMLResponse.this.writer.writeEmptyElement(RemoteFileChooserXMLResponse.RECORD);
                            RemoteFileChooserXMLResponse.this.writer.writeAttribute("Name", file.getFileName().toString());
                            RemoteFileChooserXMLResponse.this.writer.writeAttribute("Path", RemoteFileChooserXMLResponse.this.pathAbstractor.getRelativePath(file).toString());
                            cnt.incrementAndGet();
                        }
                        catch (XMLStreamException xMLStreamException) {
                            // empty catch block
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private String getRootName() {
        return this.pathAbstractor.getRelativePath(this.root).toString();
    }

    private Path getParent(XMLRequest.Operation operation) {
        Path parent;
        this.root = parent = this.request.getSession().getUser().getSettings().getWorkPath();
        if (operation.hasData("root")) {
            this.root = parent = this.pathAbstractor.getAbsolutePath(operation.getData("root"));
        }
        if (operation.hasData(PARENT)) {
            parent = this.pathAbstractor.getAbsolutePath(operation.getData(PARENT));
        } else if (operation.hasData(INITIAL_PATH) && !Files.isDirectory(parent = this.pathAbstractor.getAbsolutePath(operation.getData(INITIAL_PATH)), new LinkOption[0])) {
            parent = parent.getParent();
        }
        return parent;
    }

    private Path writeParent(Path parent) throws XMLStreamException {
        this.writer.writeElement(PARENT, (CharSequence)this.pathAbstractor.getRelativePath(parent).toString(), new SimpleAttribute[0]);
        this.writer.writeElement("relparent", (CharSequence)this.pathAbstractor.getRelativePath(parent).toString(), new SimpleAttribute[0]);
        this.writer.writeElement("root", (CharSequence)this.pathAbstractor.getRelativePath(this.root).toString(), new SimpleAttribute[0]);
        this.writer.writeElement("parentRelative", (CharSequence)Paths.get(this.getRootName(), new String[0]).resolve(this.root.relativize(parent)).toString(), new SimpleAttribute[0]);
        return parent;
    }

    private void unzip(Path zipfile, Path outputPath) {
        try (ZipFile zf = new ZipFile(zipfile.toFile());){
            Enumeration<? extends ZipEntry> zipEntries = zf.entries();
            new EnumerationToIterator<ZipEntry>(zipEntries).forEachRemaining(entry -> {
                try {
                    if (entry.isDirectory()) {
                        Path dirToCreate = outputPath.resolve(entry.getName());
                        if (!Files.exists(dirToCreate, new LinkOption[0])) {
                            Files.createDirectories(dirToCreate, new FileAttribute[0]);
                        }
                    } else {
                        Path fileToCreate = outputPath.resolve(entry.getName());
                        if (!Files.exists(fileToCreate.getParent(), new LinkOption[0])) {
                            Files.createDirectories(fileToCreate.getParent(), new FileAttribute[0]);
                        }
                        Files.copy(zf.getInputStream((ZipEntry)entry), fileToCreate, new CopyOption[0]);
                    }
                }
                catch (IOException ei) {
                    Log.err((String)ei.getMessage(), (Throwable)ei);
                }
            });
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    static class Options {
        final boolean isDir;
        final String pathmatcher;

        public Options(String context) {
            switch (context) {
                case "tfRomsDest": 
                case "tfDisksDest": 
                case "tfSWDest": 
                case "tfSWDisksDest": 
                case "tfSamplesDest": 
                case "tfBackupDest": 
                case "listSrcDir": 
                case "addDatSrc": 
                case "updDat": 
                case "updTrnt": 
                case "tfSrcDir": {
                    this.isDir = true;
                    this.pathmatcher = null;
                    break;
                }
                case "addTrnt": {
                    this.pathmatcher = "glob:*.torrent";
                    this.isDir = false;
                    break;
                }
                case "importDat": 
                case "addDat": 
                case "tfDstDat": {
                    this.pathmatcher = "glob:*.{xml,dat}";
                    this.isDir = false;
                    break;
                }
                case "addArc": {
                    this.pathmatcher = "glob:*.{zip,7z,rar,arj,tar,lzh,lha,tgz,tbz,tbz2,rpm,iso,deb,cab}";
                    this.isDir = false;
                    break;
                }
                case "importSettings": 
                case "exportSettings": {
                    this.pathmatcher = "glob:*.properties";
                    this.isDir = false;
                    break;
                }
                default: {
                    this.pathmatcher = null;
                    this.isDir = false;
                }
            }
        }
    }

    public static class CaseInsensitiveFileFinder {
        private CaseInsensitiveFileFinder() {
            throw new IllegalStateException("Utility class");
        }

        private static Path findDir(Path dir) throws IOException {
            try (Stream<Path> stream = Files.list(dir.getParent());){
                Path path = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().equalsIgnoreCase(dir.getFileName().toString())).findFirst().orElse(null);
                return path;
            }
        }

        private static Path findLast(Path path) throws IOException {
            if (Files.exists(path, new LinkOption[0])) {
                return path;
            }
            try (Stream<Path> stream = Files.list(path.getParent());){
                Path path2 = stream.filter(p -> p.getFileName().toString().equalsIgnoreCase(path.getFileName().toString())).findFirst().orElse(null);
                return path2;
            }
        }

        public static Optional<Path> findFileIgnoreCase(Path parent, String fileName) {
            Path testpath = null;
            try {
                if (!Files.exists(parent, new LinkOption[0])) {
                    testpath = parent.getRoot();
                    for (int i = 0; i < parent.getNameCount() && null != (testpath = CaseInsensitiveFileFinder.findDir(testpath.resolve(parent.getName(i)))); ++i) {
                    }
                } else {
                    testpath = parent;
                }
                if (testpath != null) {
                    testpath = CaseInsensitiveFileFinder.findLast(testpath.resolve(fileName));
                }
            }
            catch (IOException e) {
                Log.err((String)e.getMessage(), (Throwable)e);
            }
            return Optional.ofNullable(testpath);
        }

        public static Optional<Path> findFileIgnoreCase(Path path) {
            return CaseInsensitiveFileFinder.findFileIgnoreCase(path.getParent(), path.getFileName().toString());
        }

        public static Optional<File> findFileIgnoreCase(String file) {
            Path path = Paths.get(file, new String[0]);
            return CaseInsensitiveFileFinder.findFileIgnoreCase(path.getParent(), path.getFileName().toString()).map(Path::toFile);
        }

        public static Optional<File> findFileIgnoreCase(String parentDir, String fileName) {
            return CaseInsensitiveFileFinder.findFileIgnoreCase(Paths.get(parentDir, new String[0]), fileName).map(Path::toFile);
        }
    }

    private static class EnumerationToIterator<T>
    implements Iterator<T> {
        Enumeration<T> enumeration;

        public EnumerationToIterator(Enumeration<T> enmueration) {
            this.enumeration = enmueration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public T next() {
            if (!this.enumeration.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this.enumeration.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

