/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.datasources;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jrm.misc.ExceptionUtils;
import jrm.misc.Log;
import jrm.server.shared.TempFileInputStream;
import jrm.server.shared.WebSession;
import lombok.Generated;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLRequest {
    Operation operation = null;
    Transaction transaction = null;
    WebSession session;

    public XMLRequest(WebSession session, InputStream in, long len) throws IOException {
        this.session = session;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            SAXParser parser = factory.newSAXParser();
            parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            try (InputStream tfis = TempFileInputStream.newInstance(in, len);){
                parser.parse(tfis, (DefaultHandler)new XMLRequestHandler());
            }
        }
        catch (ParserConfigurationException | SAXException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public Operation getOperation() {
        return this.operation;
    }

    @Generated
    public WebSession getSession() {
        return this.session;
    }

    public static class Operation {
        StringBuilder operationType = new StringBuilder();
        StringBuilder operationId = new StringBuilder();
        int startRow = 0;
        int endRow = Integer.MAX_VALUE;
        List<Sorter> sort = new ArrayList<Sorter>();
        private Map<String, List<String>> data = new HashMap<String, List<String>>();
        Map<String, String> oldValues = new HashMap<String, String>();

        public boolean hasData(String key) {
            return this.data.containsKey(key);
        }

        public String getData(String key) {
            List<String> value;
            if (this.data.containsKey(key) && !(value = this.data.get(key)).isEmpty()) {
                return value.get(0);
            }
            return null;
        }

        boolean addData(String key, String value) {
            return this.data.computeIfAbsent(key, v -> new ArrayList()).add(value);
        }

        public List<String> getDatas(String key) {
            return this.data.get(key);
        }

        public List<Sorter> getSort() {
            return this.sort;
        }

        public StringBuilder getOperationId() {
            return this.operationId;
        }

        public StringBuilder getOperationType() {
            return this.operationType;
        }

        public int getStartRow() {
            return this.startRow;
        }

        public int getEndRow() {
            return this.endRow;
        }

        public Map<String, String> getOldValues() {
            return this.oldValues;
        }

        public static class Sorter {
            String name;
            boolean desc = false;

            public Sorter(String value) {
                if (value.length() > 0 && value.charAt(0) == '-') {
                    this.desc = true;
                    this.name = value.substring(1);
                } else {
                    this.name = value;
                }
            }

            public String getName() {
                return this.name;
            }

            public boolean isDesc() {
                return this.desc;
            }
        }
    }

    public class Transaction {
        List<Operation> operations = new ArrayList<Operation>();

        public Transaction(XMLRequest this$0) {
        }

        public List<Operation> getOperations() {
            return this.operations;
        }
    }

    private final class XMLRequestHandler
    extends DefaultHandler {
        boolean isRequest = false;
        boolean inOperationType = false;
        boolean inOperationId = false;
        boolean inStartRow = false;
        boolean inEndRow = false;
        boolean inSortBy = false;
        boolean inData = false;
        boolean inOldValues = false;
        StringBuilder datavalue = new StringBuilder();
        Operation currentRequest;

        private XMLRequestHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("request")) {
                this.currentRequest = new Operation();
                if (XMLRequest.this.getTransaction() != null) {
                    XMLRequest.this.getTransaction().getOperations().add(this.currentRequest);
                } else {
                    XMLRequest.this.operation = this.currentRequest;
                }
                this.isRequest = true;
            } else if (qName.equals("transaction")) {
                XMLRequest.this.transaction = new Transaction(XMLRequest.this);
            } else if (this.isRequest) {
                switch (qName) {
                    case "operationType": {
                        this.inOperationType = true;
                        break;
                    }
                    case "operationId": {
                        this.inOperationId = true;
                        break;
                    }
                    case "startRow": {
                        this.inStartRow = true;
                        this.datavalue.setLength(0);
                        break;
                    }
                    case "endRow": {
                        this.inEndRow = true;
                        this.datavalue.setLength(0);
                        break;
                    }
                    case "sortBy": {
                        this.inSortBy = true;
                        this.datavalue.setLength(0);
                        break;
                    }
                    case "data": {
                        this.inData = true;
                        break;
                    }
                    case "oldValues": {
                        this.inOldValues = true;
                        break;
                    }
                    default: {
                        if (!this.inData && !this.inOldValues) break;
                        this.datavalue.setLength(0);
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            switch (qName) {
                case "operationType": {
                    this.inOperationType = false;
                    break;
                }
                case "operationId": {
                    this.inOperationId = false;
                    break;
                }
                case "startRow": {
                    this.inStartRow = false;
                    ExceptionUtils.unthrow(start -> {
                        this.currentRequest.startRow = start;
                    }, Integer::parseInt, (Object)this.datavalue.toString());
                    this.datavalue.setLength(0);
                    break;
                }
                case "endRow": {
                    this.inEndRow = false;
                    ExceptionUtils.unthrow(end -> {
                        this.currentRequest.endRow = end;
                    }, Integer::parseInt, (Object)this.datavalue.toString());
                    this.datavalue.setLength(0);
                    break;
                }
                case "sortBy": {
                    this.inSortBy = false;
                    this.currentRequest.getSort().add(new Operation.Sorter(this.datavalue.toString()));
                    this.datavalue.setLength(0);
                    break;
                }
                case "data": {
                    this.inData = false;
                    break;
                }
                case "oldValues": {
                    this.inOldValues = false;
                    break;
                }
                default: {
                    if (this.inData) {
                        this.currentRequest.addData(qName, this.datavalue.toString());
                        this.datavalue.setLength(0);
                        break;
                    }
                    if (!this.inOldValues) break;
                    this.currentRequest.getOldValues().put(qName, this.datavalue.toString());
                    this.datavalue.setLength(0);
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inOperationType) {
                this.currentRequest.getOperationType().append(ch, start, length);
            } else if (this.inOperationId) {
                this.currentRequest.getOperationId().append(ch, start, length);
            } else if (this.inStartRow || this.inEndRow) {
                this.datavalue.append(ch, start, length);
            } else if (this.inSortBy) {
                this.datavalue.append(ch, start, length);
            } else if (this.inData) {
                this.datavalue.append(ch, start, length);
            } else if (this.inOldValues) {
                this.datavalue.append(ch, start, length);
            }
        }
    }
}

