/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.datasources;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import jrm.misc.IOUtils;
import jrm.misc.Log;
import jrm.security.PathAbstractor;
import jrm.security.Session;
import jrm.server.shared.TempFileInputStream;
import jrm.server.shared.datasources.XMLRequest;
import jrm.xml.EnhancedXMLStreamWriter;
import jrm.xml.SimpleAttribute;
import org.apache.commons.lang3.Range;

public abstract class XMLResponse
implements Closeable {
    private static final String TOTAL_ROWS = "totalRows";
    private static final String END_ROW = "endRow";
    private static final String START_ROW = "startRow";
    private static final String STATUS = "status";
    private static final String RESPONSE = "response";
    protected XMLRequest request;
    private final Path tmpfile;
    private final OutputStream out;
    protected final EnhancedXMLStreamWriter writer;
    protected PathAbstractor pathAbstractor;

    protected XMLResponse(XMLRequest request) throws IOException, XMLStreamException {
        this.request = request;
        this.pathAbstractor = new PathAbstractor((Session)request.getSession());
        this.tmpfile = IOUtils.createTempFile((String)"JRM", null);
        this.out = new BufferedOutputStream(Files.newOutputStream(this.tmpfile, new OpenOption[0]));
        this.writer = new EnhancedXMLStreamWriter(XMLOutputFactory.newFactory().createXMLStreamWriter(this.out));
        this.writer.writeStartDocument("utf-8", "1.0");
    }

    private void processOperation(XMLRequest.Operation operation) throws XMLStreamException, IOException {
        switch (operation.getOperationType().toString()) {
            case "fetch": {
                this.fetch(operation);
                break;
            }
            case "add": {
                this.add(operation);
                break;
            }
            case "update": {
                this.update(operation);
                break;
            }
            case "remove": {
                this.remove(operation);
                break;
            }
            case "custom": {
                this.custom(operation);
                break;
            }
            default: {
                this.failure(String.valueOf(operation.getOperationType()) + " not implemented");
            }
        }
    }

    public TempFileInputStream processRequest() throws XMLStreamException, IOException {
        if (this.request.getTransaction() != null) {
            this.writer.writeStartElement("responses");
            for (XMLRequest.Operation operation : this.request.getTransaction().getOperations()) {
                this.processOperation(operation);
            }
            this.writer.writeEndElement();
        } else {
            this.processOperation(this.request.getOperation());
        }
        this.writer.flush();
        this.out.flush();
        return new TempFileInputStream(this.tmpfile.toFile());
    }

    protected void fetch(XMLRequest.Operation operation) throws XMLStreamException, IOException {
        this.failure("fetch operation not implemented");
    }

    protected void add(XMLRequest.Operation operation) throws XMLStreamException, IOException {
        this.failure("add operation not implemented");
    }

    protected void update(XMLRequest.Operation operation) throws XMLStreamException, IOException {
        this.failure("update operation not implemented");
    }

    protected void remove(XMLRequest.Operation operation) throws XMLStreamException, IOException {
        this.failure("delete operation not implemented");
    }

    protected void custom(XMLRequest.Operation operation) throws XMLStreamException, IOException {
        this.failure("custom operation not implemented");
    }

    @Override
    public void close() throws IOException {
        try {
            this.writer.writeEndDocument();
            this.writer.close();
        }
        catch (XMLStreamException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
        finally {
            this.out.close();
        }
    }

    protected void error(int status) throws XMLStreamException {
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)Integer.toString(status), new SimpleAttribute[0]);
        this.writer.writeEndElement();
    }

    protected void error(int status, String data) throws XMLStreamException {
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)Integer.toString(status), new SimpleAttribute[0]);
        this.writer.writeElement("data", (CharSequence)data, new SimpleAttribute[0]);
        this.writer.writeEndElement();
    }

    protected void error(int status, Map<String, List<String>> data) throws XMLStreamException {
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)Integer.toString(status), new SimpleAttribute[0]);
        if (data != null) {
            this.writer.writeStartElement("errors");
            for (Map.Entry<String, List<String>> entry : data.entrySet()) {
                this.writer.writeStartElement(entry.getKey());
                for (String msg : entry.getValue()) {
                    this.writer.writeElement("errorMessage", (CharSequence)msg, new SimpleAttribute[0]);
                }
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
    }

    protected void noError() throws XMLStreamException {
        this.error(0);
    }

    protected void success() throws XMLStreamException {
        this.error(0);
    }

    protected void otherError(String msg) throws XMLStreamException {
        this.error(-1, msg);
    }

    protected void failure(String msg) throws XMLStreamException {
        this.error(-1, msg);
    }

    protected void failure() throws XMLStreamException {
        this.error(-1);
    }

    protected void loginIncorrect() throws XMLStreamException {
        this.error(-5);
    }

    protected void loginRequired() throws XMLStreamException {
        this.error(-7);
    }

    protected void fetchArray(XMLRequest.Operation operation, int count, FetchArrayCallback cb) throws XMLStreamException {
        int start = Math.min(count - 1, operation.getStartRow());
        int end = Math.min(count - 1, operation.getEndRow());
        this.writer.writeElement(START_ROW, (CharSequence)Integer.toString(start), new SimpleAttribute[0]);
        this.writer.writeElement(END_ROW, (CharSequence)Integer.toString(end), new SimpleAttribute[0]);
        this.writer.writeElement(TOTAL_ROWS, (CharSequence)Integer.toString(count), new SimpleAttribute[0]);
        this.writer.writeStartElement("data");
        if (count > 0) {
            for (int i = start; i <= end; ++i) {
                cb.apply(i, count);
            }
        }
        this.writer.writeEndElement();
    }

    protected <T> void fetchList(XMLRequest.Operation operation, List<T> list, FetchListCallback<T> cb) throws XMLStreamException {
        int count = list.size();
        int start = Math.min(count - 1, operation.getStartRow());
        int end = Math.min(count - 1, operation.getEndRow());
        this.writer.writeElement(START_ROW, (CharSequence)Integer.toString(start), new SimpleAttribute[0]);
        this.writer.writeElement(END_ROW, (CharSequence)Integer.toString(end), new SimpleAttribute[0]);
        this.writer.writeElement(TOTAL_ROWS, (CharSequence)Integer.toString(count), new SimpleAttribute[0]);
        this.writer.writeStartElement("data");
        if (count > 0) {
            for (int idx = start; idx <= end; ++idx) {
                cb.apply(list.get(idx), idx);
            }
        }
        this.writer.writeEndElement();
    }

    protected <T> void fetchStream(XMLRequest.Operation operation, Stream<T> stream, FetchStreamCallback<T> cb) throws XMLStreamException {
        int start = operation.getStartRow();
        int end = operation.getEndRow();
        Range range = Range.of((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end));
        int[] count = new int[]{0};
        this.writer.writeStartElement("data");
        stream.filter(o -> {
            count[0] = count[0] + 1;
            return range.contains((Object)count[0]);
        }).forEachOrdered(cb::apply);
        this.writer.writeEndElement();
        this.writer.writeElement(START_ROW, (CharSequence)Integer.toString(Math.min(count[0] - 1, start)), new SimpleAttribute[0]);
        this.writer.writeElement(END_ROW, (CharSequence)Integer.toString(Math.min(count[0] - 1, end)), new SimpleAttribute[0]);
        this.writer.writeElement(TOTAL_ROWS, (CharSequence)Integer.toString(count[0]), new SimpleAttribute[0]);
    }

    @FunctionalInterface
    protected static interface FetchArrayCallback {
        public void apply(int var1, int var2) throws XMLStreamException;
    }

    @FunctionalInterface
    protected static interface FetchListCallback<T> {
        public void apply(T var1, int var2) throws XMLStreamException;
    }

    @FunctionalInterface
    protected static interface FetchStreamCallback<T> {
        public void apply(T var1);
    }
}

