/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.handlers;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import jrm.misc.Log;
import jrm.server.shared.TempFileInputStream;
import jrm.server.shared.WebSession;
import jrm.server.shared.datasources.AnywareListListXMLResponse;
import jrm.server.shared.datasources.AnywareListXMLResponse;
import jrm.server.shared.datasources.AnywareXMLResponse;
import jrm.server.shared.datasources.BatchCompressorFRXMLResponse;
import jrm.server.shared.datasources.BatchDat2DirResultXMLResponse;
import jrm.server.shared.datasources.BatchDat2DirSDRXMLResponse;
import jrm.server.shared.datasources.BatchDat2DirSrcXMLResponse;
import jrm.server.shared.datasources.BatchTrntChkReportTreeXMLResponse;
import jrm.server.shared.datasources.BatchTrntChkSDRXMLResponse;
import jrm.server.shared.datasources.CatVerXMLResponse;
import jrm.server.shared.datasources.NPlayersXMLResponse;
import jrm.server.shared.datasources.ProfilesListXMLResponse;
import jrm.server.shared.datasources.ProfilesTreeXMLResponse;
import jrm.server.shared.datasources.RemoteFileChooserXMLResponse;
import jrm.server.shared.datasources.RemoteRootChooserXMLResponse;
import jrm.server.shared.datasources.ReportTreeXMLResponse;
import jrm.server.shared.datasources.XMLRequest;
import jrm.server.shared.datasources.XMLResponse;
import org.apache.commons.io.IOUtils;

public class DataSourceServlet
extends HttpServlet {
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            if (req.getContentLengthLong() < 0L) {
                resp.setStatus(411);
            } else if (req.getContentLength() < 0) {
                resp.setStatus(413);
            } else if (req.getContentLength() > 0 && req.getContentType().equalsIgnoreCase("text/xml")) {
                TempFileInputStream response = this.processResponse((WebSession)req.getSession().getAttribute("session"), req, resp);
                if (response != null) {
                    resp.setContentType("text/xml");
                    resp.setStatus(200);
                    resp.setContentLengthLong(response.getLength());
                    IOUtils.copy((InputStream)response, (OutputStream)resp.getOutputStream());
                } else if (resp.getStatus() == 200) {
                    resp.setStatus(204);
                }
            }
        }
        catch (IOException e) {
            resp.setStatus(500);
        }
        catch (Exception e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            resp.setStatus(500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TempFileInputStream processResponse(WebSession sess, HttpServletRequest req, HttpServletResponse resp) throws IOException, XMLStreamException {
        int bodylen = req.getContentLength();
        try (XMLResponse response = null;
             BufferedInputStream in = new BufferedInputStream((InputStream)req.getInputStream());){
            switch (req.getRequestURI()) {
                case "/datasources/profilesTree": {
                    response = new ProfilesTreeXMLResponse(new XMLRequest(sess, in, bodylen));
                    break;
                }
                case "/datasources/profilesList": {
                    response = new ProfilesListXMLResponse(new XMLRequest(sess, in, bodylen));
                    break;
                }
                case "/datasources/remoteFileChooser": {
                    response = new RemoteFileChooserXMLResponse(new XMLRequest(sess, in, bodylen));
                    break;
                }
                case "/datasources/remoteRootChooser": {
                    response = new RemoteRootChooserXMLResponse(new XMLRequest(sess, in, bodylen));
                    break;
                }
                case "/datasources/CatVer": {
                    response = new CatVerXMLResponse(new XMLRequest(sess, in, bodylen));
                    break;
                }
                case "/datasources/NPlayers": {
                    response = new NPlayersXMLResponse(new XMLRequest(sess, in, bodylen));
                    break;
                }
                case "/datasources/AnywareListList": {
                    response = new AnywareListListXMLResponse(new XMLRequest(sess, in, bodylen));
                    break;
                }
                case "/datasources/AnywareList": {
                    response = new AnywareListXMLResponse(new XMLRequest(sess, in, bodylen));
                    break;
                }
                case "/datasources/Anyware": {
                    response = new AnywareXMLResponse(new XMLRequest(sess, in, bodylen));
                    break;
                }
                case "/datasources/Report": {
                    response = new ReportTreeXMLResponse(new XMLRequest(sess, in, bodylen));
                    break;
                }
                case "/datasources/BatchDat2DirSrc": {
                    response = new BatchDat2DirSrcXMLResponse(new XMLRequest(sess, in, bodylen));
                    break;
                }
                case "/datasources/BatchDat2DirSDR": {
                    response = new BatchDat2DirSDRXMLResponse(new XMLRequest(sess, in, bodylen));
                    break;
                }
                case "/datasources/BatchDat2DirResult": {
                    response = new BatchDat2DirResultXMLResponse(new XMLRequest(sess, in, bodylen));
                    break;
                }
                case "/datasources/BatchTrntChkSDR": {
                    response = new BatchTrntChkSDRXMLResponse(new XMLRequest(sess, in, bodylen));
                    break;
                }
                case "/datasources/BatchTrntChkReportTree": {
                    response = new BatchTrntChkReportTreeXMLResponse(new XMLRequest(sess, in, bodylen));
                    break;
                }
                case "/datasources/BatchCompressorFR": {
                    response = new BatchCompressorFRXMLResponse(new XMLRequest(sess, in, bodylen));
                    break;
                }
            }
            if (response != null) {
                Object object = response.processRequest();
                return object;
            }
            resp.setStatus(501);
        }
        return null;
    }
}

