/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.handlers;

import com.google.gson.Gson;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import jrm.misc.Log;
import jrm.security.PathAbstractor;
import jrm.security.Session;
import jrm.server.shared.WebSession;
import org.apache.commons.io.IOUtils;

public class UploadServlet
extends HttpServlet {
    private static final String UTF_8 = "UTF-8";

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        if ("/upload/".equals(req.getRequestURI())) {
            try {
                WebSession ws = (WebSession)req.getSession().getAttribute("session");
                PathAbstractor pathAbstractor = new PathAbstractor((Session)ws);
                Result result = new Result();
                String init = req.getParameter("init");
                if (init != null && init.equals("1")) {
                    this.checkRequest(req, pathAbstractor, result);
                } else {
                    result.status = 10;
                    result.extstatus = "init error";
                }
                resp.setContentType("text/json");
                resp.setStatus(200);
                resp.getWriter().write(new Gson().toJson((Object)result));
            }
            catch (IOException e) {
                this.internalError(resp, e);
            }
        } else {
            this.superPost(req, resp);
        }
    }

    private void superPost(HttpServletRequest req, HttpServletResponse resp) {
        try {
            super.doPost(req, resp);
        }
        catch (ServletException | IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    private void internalError(HttpServletResponse resp, IOException e) {
        try {
            resp.sendError(500, e.getMessage());
        }
        catch (IOException e1) {
            Log.err((String)e1.getMessage(), (Throwable)e1);
        }
    }

    private void checkRequest(HttpServletRequest req, PathAbstractor pathAbstractor, Result result) {
        try {
            result.status = 0;
            result.extstatus = "continue...";
            String filename = URLDecoder.decode(req.getHeader("x-file-name"), UTF_8);
            String fileparent = URLDecoder.decode(req.getHeader("x-file-parent"), UTF_8);
            if (pathAbstractor.isWriteable(fileparent)) {
                long filesize = this.getXFileSize(req);
                Path dest = pathAbstractor.getAbsolutePath(fileparent);
                if (!Files.exists(dest, new LinkOption[0]) || !Files.isDirectory(dest, new LinkOption[0])) {
                    result.status = 6;
                    result.extstatus = "Error: destination " + String.valueOf(dest) + " must be an existing directory";
                } else {
                    FileStore fs = Files.getFileStore(dest);
                    long free = fs.getUsableSpace();
                    if (free < filesize) {
                        result.status = 7;
                        result.extstatus = "Error: not enough free space, need " + filesize + " but only " + free + " is available";
                    } else {
                        Path filepath = dest.resolve(filename);
                        Files.getLastModifiedTime(filepath, new LinkOption[0]);
                    }
                }
            } else {
                result.status = 11;
                result.extstatus = "Is read only";
            }
        }
        catch (NoSuchFileException filename) {
        }
        catch (InvalidPathException e) {
            result.status = 8;
            result.extstatus = e.getMessage();
        }
        catch (IOException e) {
            result.status = 9;
            result.extstatus = e.getMessage();
        }
    }

    private long getXFileSize(HttpServletRequest req) {
        try {
            return Long.parseLong(req.getHeader("x-file-size"));
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) {
        if ("/upload/".equals(req.getRequestURI())) {
            try {
                WebSession ws = (WebSession)req.getSession().getAttribute("session");
                PathAbstractor pathAbstractor = new PathAbstractor((Session)ws);
                Result result = new Result();
                String filename = URLDecoder.decode(req.getHeader("x-file-name"), UTF_8);
                String fileparent = URLDecoder.decode(req.getHeader("x-file-parent"), UTF_8);
                if (pathAbstractor.isWriteable(fileparent)) {
                    Path dest = pathAbstractor.getAbsolutePath(fileparent);
                    Path filepath = dest.resolve(filename);
                    Files.createDirectories(filepath.getParent(), new FileAttribute[0]);
                    this.doUpload(req, result, filename, filepath);
                    if (result.status != 3) {
                        Log.debug(() -> result.status + " : " + result.extstatus);
                        Files.delete(filepath);
                    }
                } else {
                    result.status = 11;
                    result.extstatus = "Is read only";
                }
                resp.getWriter().write(new Gson().toJson((Object)result));
            }
            catch (IOException e) {
                this.internalError(resp, e);
            }
        } else {
            this.superPost(req, resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpload(HttpServletRequest req, Result result, String filename, Path filepath) {
        long filesize = this.getXFileSize(req);
        long size = 0L;
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(filepath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE));){
            size = IOUtils.copy((InputStream)req.getInputStream(), (OutputStream)out);
            result.status = 3;
            result.extstatus = filename + " done";
        }
        catch (IOException e) {
            result.status = 20;
            result.extstatus = filename + " : " + e.getMessage();
        }
        finally {
            if (filesize >= 0L && size != filesize) {
                result.status = 21;
                result.extstatus = "Error: " + filename + " size should be " + filesize + " bytes long but got " + size + " bytes";
            }
        }
    }

    static class Result {
        int status = -1;
        String extstatus = "";

        Result() {
        }
    }
}

