/*
 * Decompiled with CFR 0.152.
 */
package jrm;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.StandardOpenOption;
import java.util.logging.Level;
import jrm.aui.status.Html4Renderer;
import jrm.aui.status.StatusRenderer;
import jrm.aui.status.StatusRendererFactory;
import jrm.misc.EnumWithDefault;
import jrm.misc.Log;
import jrm.misc.SettingsEnum;
import jrm.security.Session;
import jrm.security.Sessions;
import jrm.ui.MainFrame;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;

public final class JRomManager {
    private static MainFrame mainFrame;

    public static void main(String[] args) {
        System.setProperty("file.encoding", "UTF-8");
        Sessions.setSingleMode((boolean)true);
        StatusRendererFactory.Factory.setInstance((StatusRenderer)new Html4Renderer());
        Args jArgs = new Args();
        JCommander cmd = JCommander.newBuilder().addObject((Object)jArgs).build();
        try {
            cmd.parse(args);
        }
        catch (ParameterException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            cmd.usage();
            System.exit(1);
        }
        Session session = Sessions.getSession((boolean)jArgs.multiuser, (boolean)jArgs.noupdate);
        Log.init((String)(session.getUser().getSettings().getLogPath() + "/JRM.%g.log"), (boolean)jArgs.debug, (int)0x100000, (int)5);
        if (!jArgs.debug) {
            Log.setLevel((Level)Level.parse(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.debug_level)));
        }
        if (JRomManager.lockInstance(session, FilenameUtils.removeExtension((String)JRomManager.class.getSimpleName()) + ".lock")) {
            mainFrame = new MainFrame(session);
            mainFrame.setVisible(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean lockInstance(Session session, String lockFile) {
        try (FileChannel fc = FileChannel.open(session.getUser().getSettings().getWorkPath().resolve(lockFile), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DELETE_ON_CLOSE);){
            FileLock fl = fc.tryLock();
            if (fl == null) return false;
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    fl.release();
                }
                catch (Exception e) {
                    Log.err((String)("Unable to remove lock file: " + lockFile), (Throwable)e);
                }
            }));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Log.err((String)("Unable to create and/or lock file: " + lockFile), (Throwable)e);
        }
        return false;
    }

    @Generated
    public static MainFrame getMainFrame() {
        return mainFrame;
    }

    @Parameters(separators=" =")
    private static class Args {
        @Parameter(names={"-m", "--multiuser"}, description="Multi-user mode")
        private boolean multiuser = false;
        @Parameter(names={"-n", "--noupdate"}, description="Don't search for update")
        private boolean noupdate = false;
        @Parameter(names={"-d", "--debug"}, description="Activate debug mode")
        private boolean debug = false;

        private Args() {
        }
    }
}

