/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import jrm.aui.progress.ProgressHandler;
import jrm.locale.Messages;
import jrm.misc.EnumWithDefault;
import jrm.misc.SettingsEnum;
import jrm.profile.manager.Export;
import jrm.profile.scan.Dir2Dat;
import jrm.profile.scan.DirScan;
import jrm.security.Session;
import jrm.ui.MainFrame;
import jrm.ui.basic.JFileDropMode;
import jrm.ui.basic.JFileDropTextField;
import jrm.ui.basic.JRMFileChooser;
import jrm.ui.basic.JTextFieldHintUI;
import jrm.ui.progress.SwingWorkerProgress;

public class Dir2DatPanel
extends JPanel {
    private static final String MAIN_FRAME_CHOOSE_DAT_DST = "MainFrame.ChooseDatDst";
    private static final String MAIN_FRAME_CHOOSE_DAT_SRC = "MainFrame.ChooseDatSrc";
    private JFileDropTextField tfDir2DatSrc;
    private JFileDropTextField tfDir2DatDst;
    private final ButtonGroup btngrpDir2DatFormat = new ButtonGroup();
    private JTextField tfDir2DatName;
    private JTextField tfDir2DatDescription;
    private JTextField tfDir2DatVersion;
    private JTextField tfDir2DatAuthor;
    private JTextField tfDir2DatComment;
    private JTextField tfDir2DatCategory;
    private JTextField tfDir2DatDate;
    private JTextField tfDir2DatEMail;
    private JTextField tfDir2DatHomepage;
    private JTextField tfDir2DatURL;

    public Dir2DatPanel(Session session) {
        GridBagLayout gblDir2DatTab = new GridBagLayout();
        gblDir2DatTab.columnWidths = new int[]{0, 0, 0};
        gblDir2DatTab.rowHeights = new int[]{0, 0, 0};
        gblDir2DatTab.columnWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        gblDir2DatTab.rowWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gblDir2DatTab);
        JPanel panelDir2DatOptions = new JPanel();
        panelDir2DatOptions.setBorder(new TitledBorder(null, Messages.getString((String)"MainFrame.Options"), 4, 2, null, null));
        GridBagConstraints gbcPanelDir2DatOptions = new GridBagConstraints();
        gbcPanelDir2DatOptions.insets = new Insets(0, 5, 5, 5);
        gbcPanelDir2DatOptions.fill = 1;
        gbcPanelDir2DatOptions.gridx = 0;
        gbcPanelDir2DatOptions.gridy = 0;
        this.add((Component)panelDir2DatOptions, gbcPanelDir2DatOptions);
        GridBagLayout gblPanelDir2DatOptions = new GridBagLayout();
        gblPanelDir2DatOptions.columnWidths = new int[]{0, 0, 0, 0};
        gblPanelDir2DatOptions.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        gblPanelDir2DatOptions.columnWeights = new double[]{1.0, 0.0, 1.0, Double.MIN_VALUE};
        gblPanelDir2DatOptions.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        panelDir2DatOptions.setLayout(gblPanelDir2DatOptions);
        JCheckBox cbDir2DatScanSubfolders = new JCheckBox(Messages.getString((String)"MainFrame.chckbxScanSubfolders.text"));
        cbDir2DatScanSubfolders.setSelected((Boolean)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_scan_subfolders, Boolean.class));
        cbDir2DatScanSubfolders.addItemListener(e -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_scan_subfolders, e.getStateChange() == 1));
        GridBagConstraints gbcCBDir2DatScanSubfolders = new GridBagConstraints();
        gbcCBDir2DatScanSubfolders.anchor = 17;
        gbcCBDir2DatScanSubfolders.insets = new Insets(0, 0, 5, 5);
        gbcCBDir2DatScanSubfolders.gridx = 1;
        gbcCBDir2DatScanSubfolders.gridy = 1;
        panelDir2DatOptions.add((Component)cbDir2DatScanSubfolders, gbcCBDir2DatScanSubfolders);
        JCheckBox cbDir2DatDeepScan = new JCheckBox(Messages.getString((String)"MainFrame.chckbxDeepScanFor.text"));
        cbDir2DatDeepScan.setSelected((Boolean)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_deep_scan, Boolean.class));
        cbDir2DatDeepScan.addItemListener(e -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_deep_scan, e.getStateChange() == 1));
        GridBagConstraints gbcCBDir2DatDeepScan = new GridBagConstraints();
        gbcCBDir2DatDeepScan.anchor = 17;
        gbcCBDir2DatDeepScan.insets = new Insets(0, 0, 5, 5);
        gbcCBDir2DatDeepScan.gridx = 1;
        gbcCBDir2DatDeepScan.gridy = 2;
        panelDir2DatOptions.add((Component)cbDir2DatDeepScan, gbcCBDir2DatDeepScan);
        JCheckBox cbDir2DatAddMd5 = new JCheckBox(Messages.getString((String)"MainFrame.chckbxAddMd.text"));
        cbDir2DatAddMd5.setSelected((Boolean)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_add_md5, Boolean.class));
        cbDir2DatAddMd5.addItemListener(e -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_add_md5, e.getStateChange() == 1));
        GridBagConstraints gbcCBDir2DatAddMd5 = new GridBagConstraints();
        gbcCBDir2DatAddMd5.anchor = 17;
        gbcCBDir2DatAddMd5.insets = new Insets(0, 0, 5, 5);
        gbcCBDir2DatAddMd5.gridx = 1;
        gbcCBDir2DatAddMd5.gridy = 3;
        panelDir2DatOptions.add((Component)cbDir2DatAddMd5, gbcCBDir2DatAddMd5);
        JCheckBox cbDir2DatAddSha1 = new JCheckBox(Messages.getString((String)"MainFrame.chckbxAddShamd.text"));
        cbDir2DatAddSha1.setSelected((Boolean)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_add_sha1, Boolean.class));
        cbDir2DatAddSha1.addItemListener(e -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_add_sha1, e.getStateChange() == 1));
        GridBagConstraints gbcCBDir2DatAddSha1 = new GridBagConstraints();
        gbcCBDir2DatAddSha1.anchor = 17;
        gbcCBDir2DatAddSha1.insets = new Insets(0, 0, 5, 5);
        gbcCBDir2DatAddSha1.gridx = 1;
        gbcCBDir2DatAddSha1.gridy = 4;
        panelDir2DatOptions.add((Component)cbDir2DatAddSha1, gbcCBDir2DatAddSha1);
        JCheckBox cbDir2DatJunkSubfolders = new JCheckBox(Messages.getString((String)"MainFrame.chckbxJunkSubfolders.text"));
        cbDir2DatJunkSubfolders.setSelected((Boolean)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_junk_folders, Boolean.class));
        cbDir2DatJunkSubfolders.addItemListener(e -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_junk_folders, e.getStateChange() == 1));
        GridBagConstraints gbcCBDir2DatJunkSubfolders = new GridBagConstraints();
        gbcCBDir2DatJunkSubfolders.anchor = 17;
        gbcCBDir2DatJunkSubfolders.insets = new Insets(0, 0, 5, 5);
        gbcCBDir2DatJunkSubfolders.gridx = 1;
        gbcCBDir2DatJunkSubfolders.gridy = 5;
        panelDir2DatOptions.add((Component)cbDir2DatJunkSubfolders, gbcCBDir2DatJunkSubfolders);
        JCheckBox cbDir2DatDoNotScan = new JCheckBox(Messages.getString((String)"MainFrame.chckbxDoNotScan.text"));
        cbDir2DatDoNotScan.setSelected((Boolean)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_do_not_scan_archives, Boolean.class));
        cbDir2DatDoNotScan.addItemListener(e -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_do_not_scan_archives, e.getStateChange() == 1));
        GridBagConstraints gbcCBDir2DatDoNotScan = new GridBagConstraints();
        gbcCBDir2DatDoNotScan.anchor = 17;
        gbcCBDir2DatDoNotScan.insets = new Insets(0, 0, 5, 5);
        gbcCBDir2DatDoNotScan.gridx = 1;
        gbcCBDir2DatDoNotScan.gridy = 6;
        panelDir2DatOptions.add((Component)cbDir2DatDoNotScan, gbcCBDir2DatDoNotScan);
        JCheckBox cbDir2DatMatchCurrentProfile = new JCheckBox(Messages.getString((String)"MainFrame.chckbxMatchCurrentProfile.text"));
        cbDir2DatMatchCurrentProfile.setSelected((Boolean)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_match_profile, Boolean.class));
        cbDir2DatMatchCurrentProfile.addItemListener(e -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_match_profile, e.getStateChange() == 1));
        GridBagConstraints gbcCBDir2DatMatchCurrentProfile = new GridBagConstraints();
        gbcCBDir2DatMatchCurrentProfile.anchor = 17;
        gbcCBDir2DatMatchCurrentProfile.insets = new Insets(0, 0, 5, 5);
        gbcCBDir2DatMatchCurrentProfile.gridx = 1;
        gbcCBDir2DatMatchCurrentProfile.gridy = 7;
        panelDir2DatOptions.add((Component)cbDir2DatMatchCurrentProfile, gbcCBDir2DatMatchCurrentProfile);
        JCheckBox cbDir2DatIncludeEmptyDirs = new JCheckBox(Messages.getString((String)"MainFrame.chckbxIncludeEmptyDirs.text"));
        cbDir2DatIncludeEmptyDirs.setSelected((Boolean)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_include_empty_dirs, Boolean.class));
        cbDir2DatIncludeEmptyDirs.addItemListener(e -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_include_empty_dirs, e.getStateChange() == 1));
        GridBagConstraints gbcCBDir2DatIncludeEmptyDirs = new GridBagConstraints();
        gbcCBDir2DatIncludeEmptyDirs.anchor = 17;
        gbcCBDir2DatIncludeEmptyDirs.insets = new Insets(0, 0, 5, 5);
        gbcCBDir2DatIncludeEmptyDirs.gridx = 1;
        gbcCBDir2DatIncludeEmptyDirs.gridy = 8;
        panelDir2DatOptions.add((Component)cbDir2DatIncludeEmptyDirs, gbcCBDir2DatIncludeEmptyDirs);
        JPanel panelDir2DatHeaders = new JPanel();
        panelDir2DatHeaders.setBorder(new TitledBorder(null, Messages.getString((String)"MainFrame.Headers"), 4, 2, null, null));
        GridBagConstraints gbcPanelDir2DatHeaders = new GridBagConstraints();
        gbcPanelDir2DatHeaders.insets = new Insets(0, 0, 5, 5);
        gbcPanelDir2DatHeaders.fill = 1;
        gbcPanelDir2DatHeaders.gridx = 1;
        gbcPanelDir2DatHeaders.gridy = 0;
        this.add((Component)panelDir2DatHeaders, gbcPanelDir2DatHeaders);
        GridBagLayout gblPanelDir2DatHeaders = new GridBagLayout();
        gblPanelDir2DatHeaders.columnWidths = new int[]{0, 0, 0};
        gblPanelDir2DatHeaders.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        gblPanelDir2DatHeaders.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gblPanelDir2DatHeaders.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        panelDir2DatHeaders.setLayout(gblPanelDir2DatHeaders);
        JLabel lblDir2DatName = new JLabel(Messages.getString((String)"MainFrame.lblName.text"));
        GridBagConstraints gbcLblDir2DatName = new GridBagConstraints();
        gbcLblDir2DatName.anchor = 13;
        gbcLblDir2DatName.insets = new Insets(0, 0, 5, 5);
        gbcLblDir2DatName.gridx = 0;
        gbcLblDir2DatName.gridy = 1;
        panelDir2DatHeaders.add((Component)lblDir2DatName, gbcLblDir2DatName);
        this.tfDir2DatName = new JTextField();
        this.tfDir2DatName.setText("");
        GridBagConstraints gbcTFDir2DatName = new GridBagConstraints();
        gbcTFDir2DatName.insets = new Insets(0, 0, 5, 0);
        gbcTFDir2DatName.fill = 2;
        gbcTFDir2DatName.gridx = 1;
        gbcTFDir2DatName.gridy = 1;
        panelDir2DatHeaders.add((Component)this.tfDir2DatName, gbcTFDir2DatName);
        this.tfDir2DatName.setColumns(20);
        JLabel lblDir2DatDescription = new JLabel(Messages.getString((String)"MainFrame.lblDescription.text"));
        GridBagConstraints gbcLblDir2DatDescription = new GridBagConstraints();
        gbcLblDir2DatDescription.anchor = 13;
        gbcLblDir2DatDescription.insets = new Insets(0, 0, 5, 5);
        gbcLblDir2DatDescription.gridx = 0;
        gbcLblDir2DatDescription.gridy = 2;
        panelDir2DatHeaders.add((Component)lblDir2DatDescription, gbcLblDir2DatDescription);
        this.tfDir2DatDescription = new JTextField();
        this.tfDir2DatDescription.setText("");
        this.tfDir2DatDescription.setColumns(20);
        GridBagConstraints gbcTFDir2DatDescription = new GridBagConstraints();
        gbcTFDir2DatDescription.insets = new Insets(0, 0, 5, 0);
        gbcTFDir2DatDescription.fill = 2;
        gbcTFDir2DatDescription.gridx = 1;
        gbcTFDir2DatDescription.gridy = 2;
        panelDir2DatHeaders.add((Component)this.tfDir2DatDescription, gbcTFDir2DatDescription);
        JLabel lblDir2DatVersion = new JLabel(Messages.getString((String)"MainFrame.lblVersion.text"));
        GridBagConstraints gbcLblDir2DatVersion = new GridBagConstraints();
        gbcLblDir2DatVersion.anchor = 13;
        gbcLblDir2DatVersion.insets = new Insets(0, 0, 5, 5);
        gbcLblDir2DatVersion.gridx = 0;
        gbcLblDir2DatVersion.gridy = 3;
        panelDir2DatHeaders.add((Component)lblDir2DatVersion, gbcLblDir2DatVersion);
        this.tfDir2DatVersion = new JTextField();
        this.tfDir2DatVersion.setText("");
        this.tfDir2DatVersion.setColumns(20);
        GridBagConstraints gbcTFDir2DatVersion = new GridBagConstraints();
        gbcTFDir2DatVersion.insets = new Insets(0, 0, 5, 0);
        gbcTFDir2DatVersion.fill = 2;
        gbcTFDir2DatVersion.gridx = 1;
        gbcTFDir2DatVersion.gridy = 3;
        panelDir2DatHeaders.add((Component)this.tfDir2DatVersion, gbcTFDir2DatVersion);
        JLabel lblDir2DatAuthor = new JLabel(Messages.getString((String)"MainFrame.lblAuthor.text"));
        GridBagConstraints gbcLblDir2DatAuthor = new GridBagConstraints();
        gbcLblDir2DatAuthor.anchor = 13;
        gbcLblDir2DatAuthor.insets = new Insets(0, 0, 5, 5);
        gbcLblDir2DatAuthor.gridx = 0;
        gbcLblDir2DatAuthor.gridy = 4;
        panelDir2DatHeaders.add((Component)lblDir2DatAuthor, gbcLblDir2DatAuthor);
        this.tfDir2DatAuthor = new JTextField();
        this.tfDir2DatAuthor.setText("");
        this.tfDir2DatAuthor.setColumns(20);
        GridBagConstraints gbcTFDir2DatAuthor = new GridBagConstraints();
        gbcTFDir2DatAuthor.insets = new Insets(0, 0, 5, 0);
        gbcTFDir2DatAuthor.fill = 2;
        gbcTFDir2DatAuthor.gridx = 1;
        gbcTFDir2DatAuthor.gridy = 4;
        panelDir2DatHeaders.add((Component)this.tfDir2DatAuthor, gbcTFDir2DatAuthor);
        JLabel lblDir2DatComment = new JLabel(Messages.getString((String)"MainFrame.lblComment.text"));
        GridBagConstraints gbcLblDir2DatComment = new GridBagConstraints();
        gbcLblDir2DatComment.insets = new Insets(0, 0, 5, 5);
        gbcLblDir2DatComment.anchor = 13;
        gbcLblDir2DatComment.gridx = 0;
        gbcLblDir2DatComment.gridy = 5;
        panelDir2DatHeaders.add((Component)lblDir2DatComment, gbcLblDir2DatComment);
        this.tfDir2DatComment = new JTextField();
        this.tfDir2DatComment.setText("");
        this.tfDir2DatComment.setColumns(20);
        GridBagConstraints gbcTFDir2DatComment = new GridBagConstraints();
        gbcTFDir2DatComment.insets = new Insets(0, 0, 5, 0);
        gbcTFDir2DatComment.fill = 2;
        gbcTFDir2DatComment.gridx = 1;
        gbcTFDir2DatComment.gridy = 5;
        panelDir2DatHeaders.add((Component)this.tfDir2DatComment, gbcTFDir2DatComment);
        JLabel lblDir2DatCategory = new JLabel(Messages.getString((String)"MainFrame.lblCategory.text"));
        GridBagConstraints gbcLblDir2DatCategory = new GridBagConstraints();
        gbcLblDir2DatCategory.anchor = 13;
        gbcLblDir2DatCategory.insets = new Insets(0, 0, 5, 5);
        gbcLblDir2DatCategory.gridx = 0;
        gbcLblDir2DatCategory.gridy = 6;
        panelDir2DatHeaders.add((Component)lblDir2DatCategory, gbcLblDir2DatCategory);
        this.tfDir2DatCategory = new JTextField();
        this.tfDir2DatCategory.setText("");
        this.tfDir2DatCategory.setColumns(20);
        GridBagConstraints gbcTFDir2DatCategory = new GridBagConstraints();
        gbcTFDir2DatCategory.insets = new Insets(0, 0, 5, 0);
        gbcTFDir2DatCategory.fill = 2;
        gbcTFDir2DatCategory.gridx = 1;
        gbcTFDir2DatCategory.gridy = 6;
        panelDir2DatHeaders.add((Component)this.tfDir2DatCategory, gbcTFDir2DatCategory);
        JLabel lblDir2DatDate = new JLabel(Messages.getString((String)"MainFrame.lblDate.text"));
        GridBagConstraints gbcLblDir2DatDate = new GridBagConstraints();
        gbcLblDir2DatDate.anchor = 13;
        gbcLblDir2DatDate.insets = new Insets(0, 0, 5, 5);
        gbcLblDir2DatDate.gridx = 0;
        gbcLblDir2DatDate.gridy = 7;
        panelDir2DatHeaders.add((Component)lblDir2DatDate, gbcLblDir2DatDate);
        this.tfDir2DatDate = new JTextField();
        this.tfDir2DatDate.setText("");
        this.tfDir2DatDate.setColumns(20);
        GridBagConstraints gbcTFDir2DatDate = new GridBagConstraints();
        gbcTFDir2DatDate.insets = new Insets(0, 0, 5, 0);
        gbcTFDir2DatDate.fill = 2;
        gbcTFDir2DatDate.gridx = 1;
        gbcTFDir2DatDate.gridy = 7;
        panelDir2DatHeaders.add((Component)this.tfDir2DatDate, gbcTFDir2DatDate);
        JLabel lblDir2DatEmail = new JLabel(Messages.getString((String)"MainFrame.lblEmail.text"));
        GridBagConstraints gbcLblDir2DatEmail = new GridBagConstraints();
        gbcLblDir2DatEmail.anchor = 13;
        gbcLblDir2DatEmail.insets = new Insets(0, 0, 5, 5);
        gbcLblDir2DatEmail.gridx = 0;
        gbcLblDir2DatEmail.gridy = 8;
        panelDir2DatHeaders.add((Component)lblDir2DatEmail, gbcLblDir2DatEmail);
        this.tfDir2DatEMail = new JTextField();
        this.tfDir2DatEMail.setText("");
        this.tfDir2DatEMail.setColumns(20);
        GridBagConstraints gbcTFDir2DatEMail = new GridBagConstraints();
        gbcTFDir2DatEMail.insets = new Insets(0, 0, 5, 0);
        gbcTFDir2DatEMail.fill = 2;
        gbcTFDir2DatEMail.gridx = 1;
        gbcTFDir2DatEMail.gridy = 8;
        panelDir2DatHeaders.add((Component)this.tfDir2DatEMail, gbcTFDir2DatEMail);
        JLabel lblDir2DatHomepage = new JLabel(Messages.getString((String)"MainFrame.lblHomepage.text"));
        GridBagConstraints gbcLblDir2DatHomepage = new GridBagConstraints();
        gbcLblDir2DatHomepage.anchor = 13;
        gbcLblDir2DatHomepage.insets = new Insets(0, 0, 5, 5);
        gbcLblDir2DatHomepage.gridx = 0;
        gbcLblDir2DatHomepage.gridy = 9;
        panelDir2DatHeaders.add((Component)lblDir2DatHomepage, gbcLblDir2DatHomepage);
        this.tfDir2DatHomepage = new JTextField();
        this.tfDir2DatHomepage.setText("");
        this.tfDir2DatHomepage.setColumns(20);
        GridBagConstraints gbcTFDir2DatHomepage = new GridBagConstraints();
        gbcTFDir2DatHomepage.insets = new Insets(0, 0, 5, 0);
        gbcTFDir2DatHomepage.fill = 2;
        gbcTFDir2DatHomepage.gridx = 1;
        gbcTFDir2DatHomepage.gridy = 9;
        panelDir2DatHeaders.add((Component)this.tfDir2DatHomepage, gbcTFDir2DatHomepage);
        JLabel lblDir2DatUrl = new JLabel(Messages.getString((String)"MainFrame.lblUrl.text"));
        GridBagConstraints gbcLblDir2DatUrl = new GridBagConstraints();
        gbcLblDir2DatUrl.insets = new Insets(0, 0, 5, 5);
        gbcLblDir2DatUrl.anchor = 13;
        gbcLblDir2DatUrl.gridx = 0;
        gbcLblDir2DatUrl.gridy = 10;
        panelDir2DatHeaders.add((Component)lblDir2DatUrl, gbcLblDir2DatUrl);
        this.tfDir2DatURL = new JTextField();
        this.tfDir2DatURL.setText("");
        this.tfDir2DatURL.setColumns(20);
        GridBagConstraints gbcTFDir2DatURL = new GridBagConstraints();
        gbcTFDir2DatURL.insets = new Insets(0, 0, 5, 0);
        gbcTFDir2DatURL.fill = 2;
        gbcTFDir2DatURL.gridx = 1;
        gbcTFDir2DatURL.gridy = 10;
        panelDir2DatHeaders.add((Component)this.tfDir2DatURL, gbcTFDir2DatURL);
        JPanel panelDir2DatIO = new JPanel();
        panelDir2DatIO.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), Messages.getString((String)"MainFrame.IO"), 4, 2, null, new Color(0, 0, 0)));
        GridBagConstraints gbcPanelDir2DatIO = new GridBagConstraints();
        gbcPanelDir2DatIO.insets = new Insets(0, 5, 5, 5);
        gbcPanelDir2DatIO.gridwidth = 2;
        gbcPanelDir2DatIO.fill = 1;
        gbcPanelDir2DatIO.gridx = 0;
        gbcPanelDir2DatIO.gridy = 1;
        this.add((Component)panelDir2DatIO, gbcPanelDir2DatIO);
        GridBagLayout gblPanelDir2DatIO = new GridBagLayout();
        gblPanelDir2DatIO.columnWidths = new int[]{0, 0, 0, 0, 0, 0, 0};
        gblPanelDir2DatIO.rowHeights = new int[]{0, 0, 0, 0};
        gblPanelDir2DatIO.columnWeights = new double[]{0.0, 1.0, 1.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        gblPanelDir2DatIO.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelDir2DatIO.setLayout(gblPanelDir2DatIO);
        JLabel lblDir2DatSrc = new JLabel(Messages.getString((String)"MainFrame.lblSrcDir_1.text"));
        GridBagConstraints gbcLblDir2DatSrc = new GridBagConstraints();
        gbcLblDir2DatSrc.fill = 2;
        gbcLblDir2DatSrc.insets = new Insets(0, 5, 5, 5);
        gbcLblDir2DatSrc.gridx = 0;
        gbcLblDir2DatSrc.gridy = 0;
        panelDir2DatIO.add((Component)lblDir2DatSrc, gbcLblDir2DatSrc);
        this.tfDir2DatSrc = new JFileDropTextField(txt -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_src_dir, txt));
        this.tfDir2DatSrc.setText(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_src_dir));
        this.tfDir2DatSrc.setMode(JFileDropMode.DIRECTORY);
        this.tfDir2DatSrc.setUI(new JTextFieldHintUI(Messages.getString((String)"MainFrame.DropDirHint"), Color.gray));
        this.tfDir2DatSrc.setColumns(10);
        GridBagConstraints gbcTFDir2DatSrc = new GridBagConstraints();
        gbcTFDir2DatSrc.gridwidth = 3;
        gbcTFDir2DatSrc.insets = new Insets(0, 0, 5, 0);
        gbcTFDir2DatSrc.fill = 1;
        gbcTFDir2DatSrc.gridx = 1;
        gbcTFDir2DatSrc.gridy = 0;
        panelDir2DatIO.add((Component)this.tfDir2DatSrc, gbcTFDir2DatSrc);
        JButton btnDir2DatSrc = new JButton("");
        btnDir2DatSrc.setIcon(MainFrame.getIcon("/jrm/resicons/icons/disk.png"));
        btnDir2DatSrc.addActionListener(e -> {
            File workdir = session.getUser().getSettings().getWorkPath().toFile();
            new JRMFileChooser<Void>(0, 1, new File(session.getUser().getSettings().getProperty(MAIN_FRAME_CHOOSE_DAT_SRC, workdir.getAbsolutePath())), new File(this.tfDir2DatSrc.getText()), null, Messages.getString((String)MAIN_FRAME_CHOOSE_DAT_SRC), false).show(SwingUtilities.getWindowAncestor(this), chooser -> {
                session.getUser().getSettings().setProperty(MAIN_FRAME_CHOOSE_DAT_SRC, chooser.getCurrentDirectory().getAbsolutePath());
                this.tfDir2DatSrc.setText(chooser.getSelectedFile().getAbsolutePath());
                session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_src_dir, this.tfDir2DatSrc.getText());
                return null;
            });
        });
        GridBagConstraints gbcBtnDir2DatSrc = new GridBagConstraints();
        gbcBtnDir2DatSrc.insets = new Insets(0, 0, 5, 5);
        gbcBtnDir2DatSrc.gridx = 4;
        gbcBtnDir2DatSrc.gridy = 0;
        panelDir2DatIO.add((Component)btnDir2DatSrc, gbcBtnDir2DatSrc);
        JButton btnDir2DatGenerate = new JButton(Messages.getString((String)"MainFrame.btnGenerate.text"));
        btnDir2DatGenerate.addActionListener(e -> this.dir2dat(session));
        GridBagConstraints gbcBtnDir2DatGenerate = new GridBagConstraints();
        gbcBtnDir2DatGenerate.fill = 1;
        gbcBtnDir2DatGenerate.gridheight = 3;
        gbcBtnDir2DatGenerate.gridx = 5;
        gbcBtnDir2DatGenerate.gridy = 0;
        panelDir2DatIO.add((Component)btnDir2DatGenerate, gbcBtnDir2DatGenerate);
        JLabel lblDir2DatDst = new JLabel(Messages.getString((String)"MainFrame.lblDstDat.text"));
        GridBagConstraints gbcLblDir2DatDst = new GridBagConstraints();
        gbcLblDir2DatDst.fill = 2;
        gbcLblDir2DatDst.insets = new Insets(0, 5, 5, 5);
        gbcLblDir2DatDst.gridx = 0;
        gbcLblDir2DatDst.gridy = 1;
        panelDir2DatIO.add((Component)lblDir2DatDst, gbcLblDir2DatDst);
        this.tfDir2DatDst = new JFileDropTextField(txt -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_dst_file, txt));
        this.tfDir2DatDst.setText(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_dst_file));
        this.tfDir2DatDst.setMode(JFileDropMode.FILE);
        this.tfDir2DatDst.setUI(new JTextFieldHintUI(Messages.getString((String)"MainFrame.DropFileHint"), Color.gray));
        this.tfDir2DatDst.setColumns(10);
        GridBagConstraints gbcTFDir2DatDst = new GridBagConstraints();
        gbcTFDir2DatDst.gridwidth = 3;
        gbcTFDir2DatDst.insets = new Insets(0, 0, 5, 0);
        gbcTFDir2DatDst.fill = 1;
        gbcTFDir2DatDst.gridx = 1;
        gbcTFDir2DatDst.gridy = 1;
        panelDir2DatIO.add((Component)this.tfDir2DatDst, gbcTFDir2DatDst);
        JButton btnDir2DatDst = new JButton("");
        btnDir2DatDst.setIcon(MainFrame.getIcon("/jrm/resicons/icons/disk.png"));
        btnDir2DatDst.addActionListener(e -> {
            File workdir = session.getUser().getSettings().getWorkPath().toFile();
            new JRMFileChooser<Void>(1, 0, new File(session.getUser().getSettings().getProperty(MAIN_FRAME_CHOOSE_DAT_DST, workdir.getAbsolutePath())), new File(this.tfDir2DatDst.getText()), null, Messages.getString((String)MAIN_FRAME_CHOOSE_DAT_DST), false).show(SwingUtilities.getWindowAncestor(this), chooser -> {
                session.getUser().getSettings().setProperty(MAIN_FRAME_CHOOSE_DAT_DST, chooser.getCurrentDirectory().getAbsolutePath());
                this.tfDir2DatDst.setText(chooser.getSelectedFile().getAbsolutePath());
                session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_dst_file, this.tfDir2DatDst.getText());
                return null;
            });
        });
        GridBagConstraints gbcBtnDir2DatDst = new GridBagConstraints();
        gbcBtnDir2DatDst.insets = new Insets(0, 0, 5, 5);
        gbcBtnDir2DatDst.gridx = 4;
        gbcBtnDir2DatDst.gridy = 1;
        panelDir2DatIO.add((Component)btnDir2DatDst, gbcBtnDir2DatDst);
        JLabel lblDir2DatFormat = new JLabel(Messages.getString((String)"MainFrame.lblFormat.text"));
        lblDir2DatFormat.setHorizontalAlignment(11);
        GridBagConstraints gbcLblDir2DatFormat = new GridBagConstraints();
        gbcLblDir2DatFormat.fill = 2;
        gbcLblDir2DatFormat.insets = new Insets(0, 0, 0, 5);
        gbcLblDir2DatFormat.gridx = 0;
        gbcLblDir2DatFormat.gridy = 2;
        panelDir2DatIO.add((Component)lblDir2DatFormat, gbcLblDir2DatFormat);
        JRadioButton rdbtnDir2DatMame = new JRadioButton(Messages.getString((String)"MainFrame.rdbtnMame.text"));
        rdbtnDir2DatMame.setSelected(Export.ExportType.valueOf((String)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_format)) == Export.ExportType.MAME);
        rdbtnDir2DatMame.addActionListener(e -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_format, Export.ExportType.MAME.toString()));
        this.btngrpDir2DatFormat.add(rdbtnDir2DatMame);
        GridBagConstraints gbcRdBtnDir2DatMame = new GridBagConstraints();
        gbcRdBtnDir2DatMame.insets = new Insets(0, 0, 0, 5);
        gbcRdBtnDir2DatMame.gridx = 1;
        gbcRdBtnDir2DatMame.gridy = 2;
        panelDir2DatIO.add((Component)rdbtnDir2DatMame, gbcRdBtnDir2DatMame);
        JRadioButton rdbtnDir2DatLogiqxDat = new JRadioButton(Messages.getString((String)"MainFrame.rdbtnLogiqxDat.text"));
        rdbtnDir2DatLogiqxDat.setSelected(Export.ExportType.valueOf((String)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_format)) == Export.ExportType.DATAFILE);
        rdbtnDir2DatLogiqxDat.addActionListener(e -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_format, Export.ExportType.DATAFILE.toString()));
        this.btngrpDir2DatFormat.add(rdbtnDir2DatLogiqxDat);
        GridBagConstraints gbcRdBtnDir2DatLogiqxDat = new GridBagConstraints();
        gbcRdBtnDir2DatLogiqxDat.insets = new Insets(0, 0, 0, 5);
        gbcRdBtnDir2DatLogiqxDat.gridx = 2;
        gbcRdBtnDir2DatLogiqxDat.gridy = 2;
        panelDir2DatIO.add((Component)rdbtnDir2DatLogiqxDat, gbcRdBtnDir2DatLogiqxDat);
        JRadioButton rdbtnDir2DatSwList = new JRadioButton(Messages.getString((String)"MainFrame.rdbtnSwList.text"));
        rdbtnDir2DatSwList.setSelected(Export.ExportType.valueOf((String)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_format)) == Export.ExportType.SOFTWARELIST);
        rdbtnDir2DatSwList.addActionListener(e -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_format, Export.ExportType.SOFTWARELIST.toString()));
        this.btngrpDir2DatFormat.add(rdbtnDir2DatSwList);
        GridBagConstraints gbcRdBtnDir2DatSwList = new GridBagConstraints();
        gbcRdBtnDir2DatSwList.gridwidth = 2;
        gbcRdBtnDir2DatSwList.insets = new Insets(0, 0, 0, 5);
        gbcRdBtnDir2DatSwList.gridx = 3;
        gbcRdBtnDir2DatSwList.gridy = 2;
        panelDir2DatIO.add((Component)rdbtnDir2DatSwList, gbcRdBtnDir2DatSwList);
    }

    private void dir2dat(final Session session) {
        new SwingWorkerProgress<Void, Void>(SwingUtilities.getWindowAncestor(this)){

            @Override
            protected Void doInBackground() throws Exception {
                File dstdat;
                File srcdir;
                String src = Dir2DatPanel.this.tfDir2DatSrc.getText();
                String dst = Dir2DatPanel.this.tfDir2DatDst.getText();
                if (src != null && src.length() > 0 && dst != null && dst.length() > 0 && (srcdir = new File(src)).isDirectory() && (dstdat = new File(dst)).getParentFile().isDirectory() && (dstdat.exists() || dstdat.createNewFile())) {
                    EnumSet<DirScan.Options> options = Dir2DatPanel.this.initOptions(session);
                    Export.ExportType type = Export.ExportType.valueOf((String)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_format));
                    HashMap<String, String> headers = Dir2DatPanel.this.initHeaders();
                    new Dir2Dat(session, srcdir, dstdat, (ProgressHandler)this, options, type, headers);
                }
                return null;
            }

            @Override
            protected void done() {
                this.close();
            }
        }.execute();
    }

    private EnumSet<DirScan.Options> initOptions(Session session) {
        EnumSet<DirScan.Options> options = EnumSet.of(DirScan.Options.USE_PARALLELISM, DirScan.Options.MD5_DISKS, DirScan.Options.SHA1_DISKS);
        if (Boolean.TRUE.equals(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_scan_subfolders, Boolean.class))) {
            options.add(DirScan.Options.RECURSE);
        }
        if (Boolean.FALSE.equals(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_deep_scan, Boolean.class))) {
            options.add(DirScan.Options.IS_DEST);
        }
        if (Boolean.TRUE.equals(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_add_md5, Boolean.class))) {
            options.add(DirScan.Options.NEED_MD5);
        }
        if (Boolean.TRUE.equals(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_add_sha1, Boolean.class))) {
            options.add(DirScan.Options.NEED_SHA1);
        }
        if (Boolean.TRUE.equals(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_junk_folders, Boolean.class))) {
            options.add(DirScan.Options.JUNK_SUBFOLDERS);
        }
        if (Boolean.TRUE.equals(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_do_not_scan_archives, Boolean.class))) {
            options.add(DirScan.Options.ARCHIVES_AND_CHD_AS_ROMS);
        }
        if (Boolean.TRUE.equals(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_match_profile, Boolean.class))) {
            options.add(DirScan.Options.MATCH_PROFILE);
        }
        if (Boolean.TRUE.equals(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_include_empty_dirs, Boolean.class))) {
            options.add(DirScan.Options.EMPTY_DIRS);
        }
        return options;
    }

    private HashMap<String, String> initHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("name", this.tfDir2DatName.getText());
        headers.put("description", this.tfDir2DatDescription.getText());
        headers.put("version", this.tfDir2DatVersion.getText());
        headers.put("author", this.tfDir2DatAuthor.getText());
        headers.put("comment", this.tfDir2DatComment.getText());
        headers.put("category", this.tfDir2DatCategory.getText());
        headers.put("date", this.tfDir2DatDate.getText());
        headers.put("email", this.tfDir2DatEMail.getText());
        headers.put("homepage", this.tfDir2DatHomepage.getText());
        headers.put("url", this.tfDir2DatURL.getText());
        return headers;
    }
}

