/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui;

import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import jrm.locale.Messages;
import jrm.misc.Log;
import jrm.security.Session;
import jrm.ui.Dir2DatPanel;
import jrm.ui.ProfilePanel;
import jrm.ui.ScannerPanel;
import jrm.ui.SettingsPanel;
import jrm.ui.basic.Popup;
import jrm.ui.batch.BatchPanel;
import jrm.ui.profile.ProfileViewer;
import jrm.ui.profile.report.ReportFrame;
import lombok.Generated;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.SerializationUtils;

public class MainFrame
extends JFrame
implements Popup {
    private static ProfileViewer profileViewer = null;
    private static ReportFrame reportFrame = null;
    private JTabbedPane mainPane;
    private ProfilePanel profilesPanel;
    private transient Session session;
    private static HashMap<String, ImageIcon> iconsCache = new HashMap();
    private static Optional<Module> iconsModule = ModuleLayer.boot().findModule("res.icons");

    public MainFrame(final Session session) {
        this.session = session;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                session.getUser().getSettings().setProperty("MainFrame.Bounds", Hex.encodeHexString((byte[])SerializationUtils.serialize((Serializable)MainFrame.this.getBounds())));
            }
        });
        try {
            UIManager.setLookAndFeel(session.getUser().getSettings().getProperty("LookAndFeel", UIManager.getSystemLookAndFeelClassName()));
            File workdir = session.getUser().getSettings().getWorkPath().toFile();
            File xmldir = new File(workdir, "xmlfiles");
            xmldir.mkdir();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e, "Exception", 0);
            Log.err((String)e.getMessage(), (Throwable)e);
        }
        this.build();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (session.getCurrProfile() != null) {
                session.getCurrProfile().saveSettings();
            }
            session.getUser().getSettings().saveSettings();
        }));
    }

    private String getVersion() {
        Object version = "";
        Package pkg = this.getClass().getPackage();
        if (pkg.getSpecificationVersion() != null) {
            version = (String)version + pkg.getSpecificationVersion();
            if (pkg.getImplementationVersion() != null) {
                version = (String)version + "." + pkg.getImplementationVersion();
            }
        }
        return version;
    }

    private void build() {
        this.setIconImage(MainFrame.getIcon("/jrm/resicons/rom.png").getImage());
        this.setTitle(Messages.getString((String)"MainFrame.Title") + " " + this.getVersion());
        this.setBounds(50, 50, 1007, 601);
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.mainPane = new JTabbedPane(1);
        this.getContentPane().add(this.mainPane);
        MainFrame.setReportFrame(new ReportFrame(this.session, this));
        this.buildProfileTab();
        this.buildScannerTab();
        this.buildDir2DatTab();
        this.buildBatchToolsTab();
        this.buildSettingsTab();
        this.pack();
        try {
            this.setBounds((Rectangle)SerializationUtils.deserialize((byte[])Hex.decodeHex((String)this.session.getUser().getSettings().getProperty("MainFrame.Bounds", Hex.encodeHexString((byte[])SerializationUtils.serialize((Serializable)new Rectangle(50, 50, 720, 300)))))));
        }
        catch (DecoderException e1) {
            Log.err((String)e1.getMessage(), (Throwable)e1);
        }
    }

    private void buildProfileTab() {
        this.profilesPanel = new ProfilePanel(this.session);
        this.mainPane.addTab(Messages.getString((String)"MainFrame.Profiles"), MainFrame.getIcon("/jrm/resicons/icons/script.png"), this.profilesPanel, null);
    }

    private void buildScannerTab() {
        ScannerPanel scannerPanel = new ScannerPanel(this.session);
        this.profilesPanel.setProfileLoader(scannerPanel);
        scannerPanel.setMainPane(this.mainPane);
        this.mainPane.addTab(Messages.getString((String)"MainFrame.Scanner"), MainFrame.getIcon("/jrm/resicons/icons/drive_magnify.png"), scannerPanel, null);
        this.mainPane.setEnabledAt(1, false);
    }

    private void buildDir2DatTab() {
        Dir2DatPanel dir2datPanel = new Dir2DatPanel(this.session);
        this.mainPane.addTab(Messages.getString((String)"MainFrame.Dir2Dat"), MainFrame.getIcon("/jrm/resicons/icons/drive_go.png"), dir2datPanel, null);
    }

    private void buildBatchToolsTab() {
        BatchPanel batchToolsPanel = new BatchPanel(this.session);
        this.mainPane.addTab(Messages.getString((String)"MainFrame.BatchTools"), MainFrame.getIcon("/jrm/resicons/icons/application_osx_terminal.png"), batchToolsPanel, null);
    }

    private void buildSettingsTab() {
        SettingsPanel settingsPanel = new SettingsPanel(this.session);
        this.mainPane.addTab(Messages.getString((String)"MainFrame.Settings"), MainFrame.getIcon("/jrm/resicons/icons/cog.png"), settingsPanel, null);
    }

    public static ImageIcon getIcon(String res) {
        if (!iconsCache.containsKey(res)) {
            iconsModule.ifPresentOrElse(module -> {
                try (InputStream in = module.getResourceAsStream(res);){
                    iconsCache.put(res, in != null ? new ImageIcon(in.readAllBytes()) : new ImageIcon());
                }
                catch (Exception e) {
                    Log.err((String)e.getMessage(), (Throwable)e);
                    iconsCache.put(res, new ImageIcon());
                }
            }, () -> {
                try (InputStream in = MainFrame.class.getResourceAsStream(res);){
                    iconsCache.put(res, in != null ? new ImageIcon(in.readAllBytes()) : new ImageIcon());
                }
                catch (Exception e) {
                    Log.err((String)e.getMessage(), (Throwable)e);
                    iconsCache.put(res, new ImageIcon());
                }
            });
        }
        return iconsCache.get(res);
    }

    @Generated
    public static ProfileViewer getProfileViewer() {
        return profileViewer;
    }

    @Generated
    public static void setProfileViewer(ProfileViewer profileViewer) {
        MainFrame.profileViewer = profileViewer;
    }

    @Generated
    public static ReportFrame getReportFrame() {
        return reportFrame;
    }

    @Generated
    public static void setReportFrame(ReportFrame reportFrame) {
        MainFrame.reportFrame = reportFrame;
    }

    @Generated
    public JTabbedPane getMainPane() {
        return this.mainPane;
    }
}

