/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import jrm.aui.progress.ProgressHandler;
import jrm.locale.Messages;
import jrm.misc.Log;
import jrm.profile.manager.Dir;
import jrm.profile.manager.Import;
import jrm.profile.manager.ProfileNFO;
import jrm.profile.manager.ProfileNFOMame;
import jrm.security.Session;
import jrm.ui.MainFrame;
import jrm.ui.ProfileLoader;
import jrm.ui.basic.JRMFileChooser;
import jrm.ui.basic.Popup;
import jrm.ui.profile.manager.DirNode;
import jrm.ui.profile.manager.DirTreeCellEditor;
import jrm.ui.profile.manager.DirTreeCellRenderer;
import jrm.ui.profile.manager.DirTreeModel;
import jrm.ui.profile.manager.DirTreeSelectionListener;
import jrm.ui.profile.manager.FileTableCellRenderer;
import jrm.ui.profile.manager.FileTableModel;
import jrm.ui.progress.SwingWorkerProgress;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class ProfilePanel
extends JPanel {
    private static final String MAIN_FRAME_CHOOSE_EXE_OR_DAT_TO_IMPORT = "MainFrame.ChooseExeOrDatToImport";
    private static final String MAIN_FRAME_MNTM_UPDATE_FROM_MAME_TEXT = "MainFrame.mntmUpdateFromMame.text";
    private JMenuItem mntmCreateFolder;
    private JMenuItem mntmDeleteFolder;
    private JMenuItem mntmDeleteProfile;
    private JMenuItem mntmDropCache;
    private JMenuItem mntmRenameProfile;
    private JMenuItem mntmUpdateFromMame;
    private JTable profilesList;
    private JScrollPane scrollPaneTree;
    private JTree profilesTree;
    private transient ProfileLoader profileLoader;

    public ProfilePanel(final Session session) {
        GridBagLayout gblProfilesTab = new GridBagLayout();
        gblProfilesTab.columnWidths = new int[]{0, 0};
        gblProfilesTab.rowHeights = new int[]{0, 0, 0};
        gblProfilesTab.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gblProfilesTab.rowWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gblProfilesTab);
        JSplitPane profilesPanel = new JSplitPane();
        profilesPanel.setContinuousLayout(true);
        profilesPanel.setResizeWeight(0.2);
        profilesPanel.setOneTouchExpandable(true);
        GridBagConstraints gbcProfilesPanel = new GridBagConstraints();
        gbcProfilesPanel.insets = new Insets(0, 0, 5, 0);
        gbcProfilesPanel.fill = 1;
        gbcProfilesPanel.gridx = 0;
        gbcProfilesPanel.gridy = 0;
        this.add((Component)profilesPanel, gbcProfilesPanel);
        JScrollPane scrollPaneList = new JScrollPane();
        profilesPanel.setRightComponent(scrollPaneList);
        this.profilesList = new JTable();
        DefaultCellEditor editor = (DefaultCellEditor)this.profilesList.getDefaultEditor(Object.class);
        editor.setClickCountToStart(3);
        this.profilesList.setShowVerticalLines(false);
        this.profilesList.setShowHorizontalLines(false);
        this.profilesList.setShowGrid(false);
        this.profilesList.setSelectionMode(0);
        this.profilesList.setPreferredScrollableViewportSize(new Dimension(400, 300));
        this.profilesList.setFillsViewportHeight(true);
        scrollPaneList.setViewportView(this.profilesList);
        final FileTableModel filemodel = new FileTableModel();
        this.profilesList.setModel(filemodel);
        for (int i = 0; i < this.profilesList.getColumnCount(); ++i) {
            TableColumn column = this.profilesList.getColumnModel().getColumn(i);
            column.setCellRenderer(new FileTableCellRenderer());
            if (FileTableModel.getColumnsWidths()[i] >= 0) {
                column.setPreferredWidth(FileTableModel.getColumnsWidths()[i]);
                continue;
            }
            String format = "%0" + -FileTableModel.getColumnsWidths()[i] + "d";
            int width = this.profilesList.getFontMetrics(this.profilesList.getFont()).stringWidth(String.format(format, 0));
            column.setMinWidth(width);
            column.setMaxWidth(width);
        }
        this.profilesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ProfilePanel.this.loadProfile(session, filemodel);
                }
            }
        });
        this.scrollPaneTree = new JScrollPane();
        this.scrollPaneTree.setMinimumSize(new Dimension(80, 22));
        profilesPanel.setLeftComponent(this.scrollPaneTree);
        this.profilesTree = new JTree();
        this.scrollPaneTree.setViewportView(this.profilesTree);
        DirTreeModel profilesTreeModel = new DirTreeModel(new DirNode(session.getUser().getSettings().getWorkPath().resolve("xmlfiles").toAbsolutePath().normalize().toFile()));
        this.profilesTree.setModel(profilesTreeModel);
        this.profilesTree.setRootVisible(true);
        this.profilesTree.setShowsRootHandles(true);
        this.profilesTree.setEditable(true);
        DirTreeCellRenderer profilesTreeRenderer = new DirTreeCellRenderer();
        this.profilesTree.setCellRenderer(profilesTreeRenderer);
        this.profilesTree.setCellEditor(new DirTreeCellEditor(this.profilesTree, profilesTreeRenderer));
        this.profilesTree.getSelectionModel().setSelectionMode(1);
        this.profilesTree.addTreeSelectionListener(new DirTreeSelectionListener(session, this.profilesList));
        JPopupMenu popupMenuList = new JPopupMenu();
        popupMenuList.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                ProfilePanel.this.mntmDeleteProfile.setEnabled(ProfilePanel.this.profilesList.getSelectedRowCount() > 0);
                ProfilePanel.this.mntmRenameProfile.setEnabled(ProfilePanel.this.profilesList.getSelectedRowCount() > 0);
                ProfilePanel.this.mntmDropCache.setEnabled(ProfilePanel.this.profilesList.getSelectedRowCount() > 0);
                ProfilePanel.this.mntmUpdateFromMame.setEnabled(ProfilePanel.this.profilesList.getSelectedRowCount() > 0 && EnumSet.of(ProfileNFOMame.MameStatus.NEEDUPDATE, ProfileNFOMame.MameStatus.NOTFOUND).contains(filemodel.getNfoAt(ProfilePanel.this.profilesList.getSelectedRow()).getMame().getStatus()));
                if (ProfilePanel.this.profilesList.getSelectedRowCount() > 0) {
                    ProfilePanel.this.mntmUpdateFromMame.setText(Messages.getString((String)ProfilePanel.MAIN_FRAME_MNTM_UPDATE_FROM_MAME_TEXT) + " (" + filemodel.getNfoAt(ProfilePanel.this.profilesList.getSelectedRow()).getMame().getStatus().getMsg() + ")");
                } else {
                    ProfilePanel.this.mntmUpdateFromMame.setText(Messages.getString((String)ProfilePanel.MAIN_FRAME_MNTM_UPDATE_FROM_MAME_TEXT));
                }
            }
        });
        Popup.addPopup(this.profilesList, popupMenuList);
        this.mntmDeleteProfile = new JMenuItem(Messages.getString((String)"MainFrame.mntmDeleteProfile.text"));
        this.mntmDeleteProfile.addActionListener(e -> this.deleteProfile(session, filemodel));
        this.mntmDeleteProfile.setIcon(MainFrame.getIcon("/jrm/resicons/icons/script_delete.png"));
        popupMenuList.add(this.mntmDeleteProfile);
        this.mntmRenameProfile = new JMenuItem(Messages.getString((String)"MainFrame.mntmRenameProfile.text"));
        this.mntmRenameProfile.addActionListener(e -> this.renameProfile());
        this.mntmRenameProfile.setIcon(MainFrame.getIcon("/jrm/resicons/icons/script_edit.png"));
        popupMenuList.add(this.mntmRenameProfile);
        this.mntmDropCache = new JMenuItem(Messages.getString((String)"MainFrame.mntmDropCache.text"));
        this.mntmDropCache.addActionListener(e -> this.dropCache(filemodel));
        this.mntmDropCache.setIcon(MainFrame.getIcon("/jrm/resicons/icons/bin.png"));
        popupMenuList.add(this.mntmDropCache);
        JSeparator separator = new JSeparator();
        popupMenuList.add(separator);
        this.mntmUpdateFromMame = new JMenuItem(Messages.getString((String)MAIN_FRAME_MNTM_UPDATE_FROM_MAME_TEXT));
        this.mntmUpdateFromMame.addActionListener(e -> this.updateFromMame(session, filemodel));
        popupMenuList.add(this.mntmUpdateFromMame);
        this.profilesTree.setSelectionRow(0);
        JPopupMenu popupMenuTree = new JPopupMenu();
        popupMenuTree.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                ProfilePanel.this.mntmCreateFolder.setEnabled(ProfilePanel.this.profilesTree.getSelectionCount() > 0);
                ProfilePanel.this.mntmDeleteFolder.setEnabled(ProfilePanel.this.profilesTree.getSelectionCount() > 0 && !((DirNode)ProfilePanel.this.profilesTree.getLastSelectedPathComponent()).isRoot());
            }
        });
        Popup.addPopup(this.profilesTree, popupMenuTree);
        this.mntmCreateFolder = new JMenuItem(Messages.getString((String)"MainFrame.mntmCreateFolder.text"));
        this.mntmCreateFolder.addActionListener(e -> this.createFolder(profilesTreeModel));
        this.mntmCreateFolder.setIcon(MainFrame.getIcon("/jrm/resicons/icons/folder_add.png"));
        popupMenuTree.add(this.mntmCreateFolder);
        this.mntmDeleteFolder = new JMenuItem(Messages.getString((String)"MainFrame.mntmDeleteFolder.text"));
        this.mntmDeleteFolder.addActionListener(e -> this.deleteFolder(profilesTreeModel));
        this.mntmDeleteFolder.setIcon(MainFrame.getIcon("/jrm/resicons/icons/folder_delete.png"));
        popupMenuTree.add(this.mntmDeleteFolder);
        JPanel profilesBtnPanel = new JPanel();
        GridBagConstraints gbcProfilesBtnPanel = new GridBagConstraints();
        gbcProfilesBtnPanel.fill = 2;
        gbcProfilesBtnPanel.gridx = 0;
        gbcProfilesBtnPanel.gridy = 1;
        this.add((Component)profilesBtnPanel, gbcProfilesBtnPanel);
        JButton btnLoadProfile = new JButton(Messages.getString((String)"MainFrame.btnLoadProfile.text"));
        btnLoadProfile.setIcon(MainFrame.getIcon("/jrm/resicons/icons/add.png"));
        btnLoadProfile.setEnabled(false);
        btnLoadProfile.addActionListener(e -> this.loadProfile(session, (FileTableModel)this.profilesList.getModel()));
        profilesBtnPanel.add(btnLoadProfile);
        JButton btnImportDat = new JButton(Messages.getString((String)"MainFrame.btnImportDat.text"));
        btnImportDat.setIcon(MainFrame.getIcon("/jrm/resicons/icons/script_go.png"));
        btnImportDat.addActionListener(e -> this.importDat(session, false));
        profilesBtnPanel.add(btnImportDat);
        JButton btnImportSL = new JButton(Messages.getString((String)"MainFrame.btnImportSL.text"));
        btnImportSL.addActionListener(e -> this.importDat(session, true));
        btnImportSL.setIcon(MainFrame.getIcon("/jrm/resicons/icons/application_go.png"));
        profilesBtnPanel.add(btnImportSL);
        this.profilesList.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                btnLoadProfile.setEnabled(this.profilesList.getSelectedColumnCount() != 0);
            }
        });
    }

    private void deleteFolder(DirTreeModel profilesTreeModel) {
        DirNode selectedNode = (DirNode)this.profilesTree.getLastSelectedPathComponent();
        if (selectedNode != null) {
            DirNode parent = (DirNode)selectedNode.getParent();
            profilesTreeModel.removeNodeFromParent(selectedNode);
            TreePath path = new TreePath(parent.getPath());
            this.profilesTree.setSelectionPath(path);
        }
    }

    private void createFolder(DirTreeModel profilesTreeModel) {
        DirNode selectedNode = (DirNode)this.profilesTree.getLastSelectedPathComponent();
        if (selectedNode != null) {
            DirNode newnode = new DirNode(new Dir(new File(selectedNode.getDir().getFile(), Messages.getString((String)"MainFrame.NewFolder"))));
            selectedNode.add(newnode);
            profilesTreeModel.reload(selectedNode);
            TreePath path = new TreePath(newnode.getPath());
            this.profilesTree.setSelectionPath(path);
            this.profilesTree.startEditingAtPath(path);
        }
    }

    private void dropCache(FileTableModel filemodel) {
        int row = this.profilesList.getSelectedRow();
        if (row >= 0) {
            try {
                Files.deleteIfExists(Paths.get(filemodel.getFileAt(row).getAbsolutePath() + ".cache", new String[0]));
            }
            catch (IOException e1) {
                Log.err((String)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    private void renameProfile() {
        int row = this.profilesList.getSelectedRow();
        if (row >= 0) {
            this.profilesList.editCellAt(row, 0);
        }
    }

    private void deleteProfile(Session session, FileTableModel filemodel) {
        int row = this.profilesList.getSelectedRow();
        if (row >= 0) {
            ProfileNFO nfo = filemodel.getNfoAt(row);
            if ((session.getCurrProfile() == null || !session.getCurrProfile().getNfo().equals(nfo)) && nfo.delete()) {
                filemodel.populate(session);
            }
        }
    }

    private void updateFromMame(final Session session, FileTableModel filemodel) {
        int row = this.profilesList.getSelectedRow();
        if (row >= 0) {
            try {
                final ProfileNFO nfo = filemodel.getNfoAt(row);
                if (nfo.getMame().getStatus() == ProfileNFOMame.MameStatus.NEEDUPDATE || nfo.getMame().getStatus() == ProfileNFOMame.MameStatus.NOTFOUND && new JRMFileChooser<ProfileNFOMame.MameStatus>(0, 0, null, nfo.getMame().getFile(), null, Messages.getString((String)"MainFrame.ChooseMameNewLocation"), false).show(SwingUtilities.getWindowAncestor(this), chooser -> this.updateFromMameRelocate(nfo, chooser)) == ProfileNFOMame.MameStatus.NEEDUPDATE) {
                    new SwingWorkerProgress<Import, Void>(SwingUtilities.getWindowAncestor(this)){

                        @Override
                        protected Import doInBackground() throws Exception {
                            return new Import(session, nfo.getMame().getFile(), nfo.getMame().isSL(), (ProgressHandler)this);
                        }

                        @Override
                        protected void done() {
                            try {
                                ProfilePanel.this.updateFromMame(session, nfo, (Import)this.get());
                                this.close();
                            }
                            catch (InterruptedException e) {
                                Log.err((String)e.getMessage(), (Throwable)e);
                                Thread.currentThread().interrupt();
                            }
                            catch (IOException | ExecutionException e) {
                                Log.err((String)e.getMessage(), (Throwable)e);
                            }
                        }
                    }.execute();
                }
            }
            catch (Exception e1) {
                Log.err((String)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    private ProfileNFOMame.MameStatus updateFromMameRelocate(ProfileNFO nfo, JRMFileChooser<ProfileNFOMame.MameStatus> chooser) {
        if (chooser.getSelectedFile().exists()) {
            return nfo.getMame().relocate(chooser.getSelectedFile());
        }
        return ProfileNFOMame.MameStatus.NOTFOUND;
    }

    private void importDat(Session session, boolean sl) {
        List<FileFilter> filters = Arrays.asList(new ImportDatFileFilter(), new FileNameExtensionFilter(Messages.getString((String)"MainFrame.DatFile"), "dat", "xml"));
        new JRMFileChooser<Void>(0, 0, Optional.ofNullable(session.getUser().getSettings().getProperty(MAIN_FRAME_CHOOSE_EXE_OR_DAT_TO_IMPORT, (String)null)).map(File::new).orElse(null), null, filters, Messages.getString((String)MAIN_FRAME_CHOOSE_EXE_OR_DAT_TO_IMPORT), true).show(SwingUtilities.getWindowAncestor(this), chooser -> {
            this.importDat(session, sl, chooser);
            return null;
        });
    }

    private void importDat(final Session session, final boolean sl, final JRMFileChooser<Void> chooser) {
        new SwingWorkerProgress<Void, Import>(SwingUtilities.getWindowAncestor(this)){

            @Override
            protected Void doInBackground() throws Exception {
                this.canCancel(false);
                session.getUser().getSettings().setProperty(ProfilePanel.MAIN_FRAME_CHOOSE_EXE_OR_DAT_TO_IMPORT, chooser.getCurrentDirectory().getAbsolutePath());
                for (File selectedfile : chooser.getSelectedFiles()) {
                    this.setProgress(Messages.getString((String)"MainFrame.ImportingFromMame"), -1);
                    this.publish(new Import(session, selectedfile, sl, (ProgressHandler)this));
                }
                return null;
            }

            @Override
            protected void process(List<Import> imprts) {
                ProfilePanel.this.importDat(session, sl, imprts);
            }

            @Override
            protected void done() {
                this.close();
            }
        }.execute();
    }

    public ProfileLoader getProfileLoader() {
        return this.profileLoader;
    }

    public void setProfileLoader(ProfileLoader profileLoader) {
        this.profileLoader = profileLoader;
    }

    private void loadProfile(Session session, FileTableModel filemodel) {
        int row = this.profilesList.getSelectedRow();
        if (row >= 0) {
            this.getProfileLoader().loadProfile(session, filemodel.getNfoAt(row));
        }
    }

    private File autoRenameFile(File file) throws IllegalArgumentException {
        int i = 1;
        File testFile;
        while ((testFile = new File(file.getParentFile(), FilenameUtils.getBaseName((String)file.getName()) + "_" + i + "." + FilenameUtils.getExtension((String)file.getName()))).exists()) {
            ++i;
        }
        return testFile;
    }

    private int importDatExistsChoose(AtomicReference<File> file) throws HeadlessException, IllegalArgumentException {
        Object[] options;
        int mode = -1;
        if (file.get().exists() && (mode = JOptionPane.showOptionDialog(this, "File already exists, choose what to do", "File already exists", -1, 1, null, options = new String[]{"Overwrite", "Auto Rename", "File Chooser", "Cancel"}, options[0])) == 1) {
            file.set(this.autoRenameFile(file.get()));
        }
        return mode;
    }

    private Void importDat(Session session, boolean sl, Import imprt, File file) {
        try {
            DirTreeModel model;
            DirNode root;
            DirNode theNode;
            File parent = file.getParentFile();
            FileUtils.copyFile((File)imprt.getFile(), (File)file);
            if (imprt.isMame()) {
                ProfileNFO pnfo = ProfileNFO.load((Session)session, (File)file);
                pnfo.getMame().set(imprt.getOrgFile(), sl);
                if (imprt.getRomsFile() != null) {
                    FileUtils.copyFileToDirectory((File)imprt.getRomsFile(), (File)parent);
                    pnfo.getMame().setFileroms(new File(parent, imprt.getRomsFile().getName()));
                    if (imprt.getSlFile() != null) {
                        FileUtils.copyFileToDirectory((File)imprt.getSlFile(), (File)parent);
                        pnfo.getMame().setFilesl(new File(parent, imprt.getSlFile().getName()));
                    }
                }
                pnfo.save(session);
            }
            if ((theNode = (root = (DirNode)(model = (DirTreeModel)this.profilesTree.getModel()).getRoot()).find(parent)) != null) {
                theNode.reload();
                model.reload(theNode);
                theNode = root.find(parent);
                if (theNode != null) {
                    this.profilesTree.clearSelection();
                    this.profilesTree.setSelectionPath(new TreePath(model.getPathToRoot(theNode)));
                } else {
                    Log.err((Object)Messages.getString((String)"MainFrame.FinalNodeNotFound"));
                }
            } else {
                Log.err((Object)Messages.getString((String)"MainFrame.NodeNotFound"));
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private void updateFromMame(Session session, ProfileNFO nfo, Import imprt) throws IOException {
        nfo.getMame().delete();
        nfo.getMame().setFileroms(new File(nfo.getFile().getParentFile(), imprt.getRomsFile().getName()));
        Files.copy(imprt.getRomsFile().toPath(), nfo.getMame().getFileroms().toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        if (nfo.getMame().isSL()) {
            nfo.getMame().setFilesl(new File(nfo.getFile().getParentFile(), imprt.getSlFile().getName()));
            Files.copy(imprt.getSlFile().toPath(), nfo.getMame().getFilesl().toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        }
        nfo.getMame().setUpdated();
        nfo.getStats().reset();
        nfo.save(session);
    }

    private void importDat(Session session, boolean sl, List<Import> imprts) throws HeadlessException, IllegalArgumentException {
        for (Import imprt : imprts) {
            if (!imprt.isMame()) {
                File currDir = ((FileTableModel)this.profilesList.getModel()).getCurrDir().getFile();
                AtomicReference<File> fileRef = new AtomicReference<File>(new File(currDir, imprt.getFile().getName()));
                int mode = this.importDatExistsChoose(fileRef);
                if (mode == 3) continue;
                if (!fileRef.get().exists() || mode == 0) {
                    try {
                        FileUtils.copyFile((File)imprt.getFile(), (File)fileRef.get());
                        ((FileTableModel)this.profilesList.getModel()).populate(session);
                    }
                    catch (IOException e) {
                        Log.err((String)e.getMessage(), (Throwable)e);
                    }
                }
            }
            File workdir = session.getUser().getSettings().getWorkPath().toFile();
            File xmldir = new File(workdir, "xmlfiles");
            new JRMFileChooser(new JRMFileChooser.OneRootFileSystemView(xmldir)).setup(1, 0, null, new File(xmldir, imprt.getFile().getName()), Collections.singletonList(new FileNameExtensionFilter(Messages.getString((String)"MainFrame.DatFile"), "dat", "xml", "jrm")), Messages.getString((String)"MainFrame.ChooseFileName"), false).show(SwingUtilities.getWindowAncestor(this), chooser1 -> this.importDat(session, sl, imprt, chooser1.getSelectedFile()));
        }
    }

    private static final class ImportDatFileFilter
    extends FileFilter {
        private ImportDatFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || FilenameUtils.isExtension((String)f.getName(), (String)"exe") || f.canExecute();
        }

        @Override
        public String getDescription() {
            return Messages.getString((String)"MainFrame.MameExecutable");
        }
    }
}

