/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jrm.locale.Messages;
import jrm.misc.ProfileSettingsEnum;
import jrm.profile.filter.CatVer;
import jrm.profile.filter.NPlayer;
import jrm.security.Session;
import jrm.ui.MainFrame;
import jrm.ui.basic.JCheckBoxList;
import jrm.ui.basic.JCheckBoxTree;
import jrm.ui.basic.JFileDropMode;
import jrm.ui.basic.JFileDropTextField;
import jrm.ui.basic.JTextFieldHintUI;
import jrm.ui.basic.NGTreeNode;
import jrm.ui.basic.Popup;
import jrm.ui.profile.filter.CatVerModel;
import jrm.ui.profile.filter.CatVerNode;
import jrm.ui.profile.filter.NPlayersModel;

public class ScannerAdvFilterPanel
extends JPanel {
    private static final String MATURE = "* Mature *";
    private JCheckBoxList<NPlayer> listNPlayers;
    private JFileDropTextField tfCatVer;
    private JFileDropTextField tfNPlayers;
    private JCheckBoxTree treeCatVer;

    public ScannerAdvFilterPanel(Session session) {
        GridBagLayout gblScannerAdvFilters = new GridBagLayout();
        gblScannerAdvFilters.columnWidths = new int[]{0, 0, 0};
        gblScannerAdvFilters.rowHeights = new int[]{0, 0, 0};
        gblScannerAdvFilters.columnWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        gblScannerAdvFilters.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        this.setLayout(gblScannerAdvFilters);
        this.tfNPlayers = new JFileDropTextField(txt -> this.dropNPLayersIni(session, txt));
        this.tfNPlayers.setMode(JFileDropMode.FILE);
        this.tfNPlayers.setUI(new JTextFieldHintUI(Messages.getString((String)"MainFrame.DropNPlayersIniHere"), Color.gray));
        this.tfNPlayers.setEditable(false);
        GridBagConstraints gbcTFNPlayers = new GridBagConstraints();
        gbcTFNPlayers.insets = new Insets(0, 0, 5, 5);
        gbcTFNPlayers.fill = 2;
        gbcTFNPlayers.gridx = 0;
        gbcTFNPlayers.gridy = 0;
        this.add((Component)this.tfNPlayers, gbcTFNPlayers);
        this.tfCatVer = new JFileDropTextField(txt -> this.dropCatVerIni(session, txt));
        this.tfCatVer.setMode(JFileDropMode.FILE);
        this.tfCatVer.setUI(new JTextFieldHintUI(Messages.getString((String)"MainFrame.DropCatVerIniHere"), Color.gray));
        this.tfCatVer.setEditable(false);
        GridBagConstraints gbcTFCatVer = new GridBagConstraints();
        gbcTFCatVer.insets = new Insets(0, 0, 5, 0);
        gbcTFCatVer.fill = 2;
        gbcTFCatVer.gridx = 1;
        gbcTFCatVer.gridy = 0;
        this.add((Component)this.tfCatVer, gbcTFCatVer);
        JScrollPane scrollPaneNPlayers = new JScrollPane();
        scrollPaneNPlayers.setViewportBorder(new TitledBorder(null, Messages.getString((String)"MainFrame.NPlayers"), 4, 2, null, null));
        GridBagConstraints gbcScrollPaneNPlayers = new GridBagConstraints();
        gbcScrollPaneNPlayers.insets = new Insets(0, 0, 0, 5);
        gbcScrollPaneNPlayers.fill = 1;
        gbcScrollPaneNPlayers.gridx = 0;
        gbcScrollPaneNPlayers.gridy = 1;
        this.add((Component)scrollPaneNPlayers, gbcScrollPaneNPlayers);
        this.listNPlayers = new JCheckBoxList();
        this.listNPlayers.setCellRenderer(this.getNPlayersCellRenderer(session));
        this.listNPlayers.addListSelectionListener(e -> this.listNPLayersValueChanged(session, e));
        this.listNPlayers.setEnabled(false);
        scrollPaneNPlayers.setViewportView(this.listNPlayers);
        JPopupMenu popupMenuNPlay = new JPopupMenu();
        Popup.addPopup(this.listNPlayers, popupMenuNPlay);
        JMenuItem mntmSelectAllNPlay = new JMenuItem(Messages.getString((String)"MainFrame.SelectAll"));
        mntmSelectAllNPlay.addActionListener(e -> this.listNPlayers.selectAll());
        popupMenuNPlay.add(mntmSelectAllNPlay);
        JMenuItem mntmSelectNoneNPlay = new JMenuItem(Messages.getString((String)"MainFrame.SelectNone"));
        mntmSelectNoneNPlay.addActionListener(e -> this.listNPlayers.selectNone());
        popupMenuNPlay.add(mntmSelectNoneNPlay);
        JMenuItem mntmInvertSelectionNPlay = new JMenuItem(Messages.getString((String)"MainFrame.InvertSelection"));
        mntmInvertSelectionNPlay.addActionListener(e -> this.listNPlayers.selectInvert());
        popupMenuNPlay.add(mntmInvertSelectionNPlay);
        JSeparator separator1 = new JSeparator();
        popupMenuNPlay.add(separator1);
        JMenuItem mntmClearNPlayers = new JMenuItem(Messages.getString((String)"ScannerAdvFilterPanel.mntmClear_1.text"));
        mntmClearNPlayers.addActionListener(e -> this.listNPlayersClear(session));
        popupMenuNPlay.add(mntmClearNPlayers);
        JScrollPane scrollPaneCatVer = new JScrollPane();
        scrollPaneCatVer.setViewportBorder(new TitledBorder(null, Messages.getString((String)"MainFrame.Categories"), 4, 2, null, null));
        GridBagConstraints gbcScrollPaneCatVer = new GridBagConstraints();
        gbcScrollPaneCatVer.fill = 1;
        gbcScrollPaneCatVer.gridx = 1;
        gbcScrollPaneCatVer.gridy = 1;
        this.add((Component)scrollPaneCatVer, gbcScrollPaneCatVer);
        this.treeCatVer = new JCheckBoxTree(new CatVerModel());
        this.treeCatVer.addCheckChangeEventListener(event -> {
            session.getCurrProfile().saveSettings();
            if (MainFrame.getProfileViewer() != null) {
                MainFrame.getProfileViewer().reset(session.getCurrProfile());
            }
        });
        this.treeCatVer.setEnabled(false);
        scrollPaneCatVer.setViewportView(this.treeCatVer);
        JPopupMenu popupMenuCat = new JPopupMenu();
        popupMenuCat.addPopupMenuListener(new CatVerPopupMenuListener(this));
        Popup.addPopup(this.treeCatVer, popupMenuCat);
        JMenu mnSelectCat = new JMenu(Messages.getString((String)"MainFrame.Select"));
        popupMenuCat.add(mnSelectCat);
        JMenuItem mntmSelectAllCat = new JMenuItem(Messages.getString((String)"MainFrame.All"));
        mntmSelectAllCat.addActionListener(e -> this.treeCatVer.selectAll());
        mnSelectCat.add(mntmSelectAllCat);
        JMenuItem mntmSelectMatureCat = new JMenuItem(Messages.getString((String)"MainFrame.Mature"));
        mntmSelectMatureCat.addActionListener(e -> this.catVerMatureSelect(session));
        mnSelectCat.add(mntmSelectMatureCat);
        JMenu mnUnselectCat = new JMenu(Messages.getString((String)"MainFrame.Unselect"));
        popupMenuCat.add(mnUnselectCat);
        JMenuItem mntmUnselectAllCat = new JMenuItem(Messages.getString((String)"MainFrame.All"));
        mntmUnselectAllCat.addActionListener(e -> this.treeCatVer.selectNone());
        mnUnselectCat.add(mntmUnselectAllCat);
        JMenuItem mntmUnselectMatureCat = new JMenuItem(Messages.getString((String)"MainFrame.Mature"));
        mntmUnselectMatureCat.addActionListener(e -> this.catVerMatureUnselect(session));
        mnUnselectCat.add(mntmUnselectMatureCat);
        JSeparator separator = new JSeparator();
        popupMenuCat.add(separator);
        JMenuItem mntmClearCat = new JMenuItem(Messages.getString((String)"ScannerAdvFilterPanel.mntmClear.text"));
        mntmClearCat.addActionListener(e -> this.catVerClear(session));
        popupMenuCat.add(mntmClearCat);
    }

    private void catVerClear(Session session) {
        session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_catver_ini, null);
        session.getCurrProfile().setCatver(null);
        session.getCurrProfile().saveSettings();
        this.tfCatVer.setText(null);
        this.treeCatVer.setModel(new CatVerModel());
    }

    private void catVerMatureUnselect(Session session) {
        List<NGTreeNode> matureNodes = this.getMatures(session);
        this.treeCatVer.unselect(matureNodes.toArray(new NGTreeNode[0]));
    }

    protected List<NGTreeNode> getMatures(Session session) {
        ArrayList<NGTreeNode> matureNodes = new ArrayList<NGTreeNode>();
        for (CatVer.Category cat : session.getCurrProfile().getCatver()) {
            CatVerModel catvermodel = (CatVerModel)this.treeCatVer.getModel();
            CatVerNode.CategoryNode catnode = ((CatVerNode)catvermodel.getRoot()).getNode(cat);
            if (cat.name.endsWith(MATURE)) {
                matureNodes.add(catnode);
                continue;
            }
            for (CatVer.Category.SubCategory subcat : cat) {
                if (!subcat.name.endsWith(MATURE)) continue;
                matureNodes.add(catnode.getNode(subcat));
            }
        }
        return matureNodes;
    }

    private void catVerMatureSelect(Session session) {
        List<NGTreeNode> matureNodes = this.getMatures(session);
        this.treeCatVer.select(matureNodes.toArray(new NGTreeNode[0]));
    }

    private void listNPlayersClear(Session session) {
        session.getCurrProfile().saveSettings();
        session.getCurrProfile().setNplayers(null);
        session.getCurrProfile().saveSettings();
        this.tfNPlayers.setText(null);
        this.listNPlayers.setModel(new DefaultListModel());
    }

    private void listNPLayersValueChanged(Session session, ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && e.getFirstIndex() != -1) {
            for (int index = e.getFirstIndex(); index <= e.getLastIndex() && index < this.listNPlayers.getModel().getSize(); ++index) {
                ((NPlayer)this.listNPlayers.getModel().getElementAt(index)).setSelected(session.getCurrProfile(), this.listNPlayers.isSelectedIndex(index));
            }
            if (MainFrame.getProfileViewer() != null) {
                MainFrame.getProfileViewer().reset(session.getCurrProfile());
            }
        }
    }

    private JCheckBoxList.CellRenderer getNPlayersCellRenderer(final Session session) {
        JCheckBoxList<NPlayer> jCheckBoxList = this.listNPlayers;
        Objects.requireNonNull(jCheckBoxList);
        return new JCheckBoxList.CellRenderer(this, jCheckBoxList){

            @Override
            public Component getListCellRendererComponent(JList<? extends NPlayer> list, NPlayer value, int index, boolean isSelected, boolean cellHasFocus) {
                JCheckBox checkbox = (JCheckBox)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                checkbox.setSelected(value.isSelected(session.getCurrProfile()));
                return checkbox;
            }
        };
    }

    private void dropCatVerIni(Session session, String txt) {
        session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_catver_ini, txt);
        session.getCurrProfile().loadCatVer(null);
        session.getCurrProfile().saveSettings();
        this.treeCatVer.setModel(session.getCurrProfile().getCatver() != null ? new CatVerModel(new CatVerNode(session.getCurrProfile().getCatver())) : new CatVerModel());
    }

    private void dropNPLayersIni(Session session, String txt) {
        session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_nplayers_ini, txt);
        session.getCurrProfile().loadNPlayers(null);
        session.getCurrProfile().saveSettings();
        this.listNPlayers.setModel(new NPlayersModel(session.getCurrProfile().getNplayers()));
    }

    public void initProfileSettings(Session session) {
        this.tfNPlayers.setText(session.getCurrProfile().getNplayers() != null ? session.getCurrProfile().getNplayers().file.getAbsolutePath() : null);
        this.listNPlayers.setModel(new NPlayersModel(session.getCurrProfile().getNplayers()));
        this.tfCatVer.setText(session.getCurrProfile().getCatver() != null ? session.getCurrProfile().getCatver().file.getAbsolutePath() : null);
        this.treeCatVer.setModel(session.getCurrProfile().getCatver() != null ? new CatVerModel(new CatVerNode(session.getCurrProfile().getCatver())) : new CatVerModel());
    }

    private final class CatVerPopupMenuListener
    implements PopupMenuListener {
        private CatVerPopupMenuListener(ScannerAdvFilterPanel scannerAdvFilterPanel) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }
    }
}

