/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import jrm.locale.Messages;
import jrm.misc.ProfileSettingsEnum;
import jrm.profile.data.Driver;
import jrm.profile.data.Machine;
import jrm.profile.data.Software;
import jrm.profile.data.Source;
import jrm.profile.data.Systm;
import jrm.security.Session;
import jrm.ui.MainFrame;
import jrm.ui.basic.JCheckBoxList;
import jrm.ui.basic.Popup;
import jrm.ui.profile.data.YearsModel;

public class ScannerFiltersPanel
extends JSplitPane {
    private JComboBox<Driver.StatusType> cbbxDriverStatus;
    private JComboBox<Machine.CabinetType> cbbxFilterCabinetType;
    private JComboBox<Machine.DisplayOrientation> cbbxFilterDisplayOrientation;
    private JComboBox<Software.Supported> cbbxSWMinSupportedLvl;
    private JComboBox<String> cbbxYearMax;
    private JComboBox<String> cbbxYearMin;
    private JCheckBox chckbxIncludeClones;
    private JCheckBox chckbxIncludeDisks;
    private JCheckBox chckbxIncludeSamples;
    JCheckBoxList<Systm> checkBoxListSystems;
    JCheckBoxList<Source> checkBoxListSources;

    public ScannerFiltersPanel(Session session) {
        this.setResizeWeight(0.5);
        this.setOneTouchExpandable(true);
        this.setContinuousLayout(true);
        JSplitPane rightsplit = new JSplitPane();
        rightsplit.setOrientation(0);
        rightsplit.setResizeWeight(0.5);
        rightsplit.setOneTouchExpandable(true);
        rightsplit.setContinuousLayout(true);
        this.setRightComponent(rightsplit);
        JScrollPane systemsFilterScrollPane = new JScrollPane();
        rightsplit.setTopComponent(systemsFilterScrollPane);
        systemsFilterScrollPane.setViewportBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), Messages.getString((String)"MainFrame.systemsFilter.viewportBorderTitle"), 4, 2, null, new Color(0, 0, 0)));
        this.checkBoxListSystems = new JCheckBoxList();
        this.checkBoxListSystems.setCellRenderer(this.getCheckBoxListSystemsCellRenderer(session));
        this.checkBoxListSystems.addListSelectionListener(e -> this.checkBoxListSystemsValueChanged(session, e));
        systemsFilterScrollPane.setViewportView(this.checkBoxListSystems);
        this.buildSystemsMenu();
        JScrollPane sourcesFilterScrollPane = new JScrollPane();
        rightsplit.setBottomComponent(sourcesFilterScrollPane);
        sourcesFilterScrollPane.setViewportBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), Messages.getString((String)"MainFrame.sourcesFilter.viewportBorderTitle"), 4, 2, null, new Color(0, 0, 0)));
        this.checkBoxListSources = new JCheckBoxList();
        this.checkBoxListSources.setCellRenderer(this.getCheckBoxListSourcesCellRenderer(session));
        this.checkBoxListSources.addListSelectionListener(e -> this.checkBoxListSourcesValueChanged(session, e));
        sourcesFilterScrollPane.setViewportView(this.checkBoxListSources);
        this.buildSourcesMenu();
        JPanel panel = new JPanel();
        this.setLeftComponent(panel);
        GridBagLayout gblPanel = new GridBagLayout();
        gblPanel.columnWidths = new int[]{20, 100, 0, 100, 20, 0};
        gblPanel.rowHeights = new int[]{0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        gblPanel.columnWeights = new double[]{1.0, 1.0, 0.0, 1.0, 1.0, Double.MIN_VALUE};
        gblPanel.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        panel.setLayout(gblPanel);
        this.chckbxIncludeClones = new JCheckBox(Messages.getString((String)"MainFrame.chckbxIncludeClones.text"));
        GridBagConstraints gbcChckbxIncludeClones = new GridBagConstraints();
        gbcChckbxIncludeClones.gridwidth = 3;
        gbcChckbxIncludeClones.fill = 2;
        gbcChckbxIncludeClones.insets = new Insets(0, 0, 5, 5);
        gbcChckbxIncludeClones.anchor = 11;
        gbcChckbxIncludeClones.gridx = 1;
        gbcChckbxIncludeClones.gridy = 1;
        panel.add((Component)this.chckbxIncludeClones, gbcChckbxIncludeClones);
        this.chckbxIncludeDisks = new JCheckBox(Messages.getString((String)"MainFrame.chckbxIncludeDisks.text"));
        GridBagConstraints gbcChckbxIncludeDisks = new GridBagConstraints();
        gbcChckbxIncludeDisks.gridwidth = 3;
        gbcChckbxIncludeDisks.fill = 2;
        gbcChckbxIncludeDisks.insets = new Insets(0, 0, 5, 5);
        gbcChckbxIncludeDisks.gridx = 1;
        gbcChckbxIncludeDisks.gridy = 2;
        panel.add((Component)this.chckbxIncludeDisks, gbcChckbxIncludeDisks);
        this.chckbxIncludeSamples = new JCheckBox(Messages.getString((String)"MainFrame.chckbxIncludeSamples.text"));
        GridBagConstraints gbcChckbxIncludeSamples = new GridBagConstraints();
        gbcChckbxIncludeSamples.gridwidth = 3;
        gbcChckbxIncludeSamples.fill = 2;
        gbcChckbxIncludeSamples.insets = new Insets(0, 0, 5, 5);
        gbcChckbxIncludeSamples.gridx = 1;
        gbcChckbxIncludeSamples.gridy = 3;
        panel.add((Component)this.chckbxIncludeSamples, gbcChckbxIncludeSamples);
        this.chckbxIncludeSamples.setSelected(true);
        JLabel lblCabinetType = new JLabel(Messages.getString((String)"MainFrame.lblMachineType.text"));
        GridBagConstraints gbcLblCabinetType = new GridBagConstraints();
        gbcLblCabinetType.gridwidth = 2;
        gbcLblCabinetType.fill = 2;
        gbcLblCabinetType.insets = new Insets(0, 0, 5, 5);
        gbcLblCabinetType.gridx = 1;
        gbcLblCabinetType.gridy = 4;
        panel.add((Component)lblCabinetType, gbcLblCabinetType);
        lblCabinetType.setHorizontalAlignment(11);
        this.cbbxFilterCabinetType = new JComboBox();
        GridBagConstraints gbcCbbxFilterCabinetType = new GridBagConstraints();
        gbcCbbxFilterCabinetType.fill = 2;
        gbcCbbxFilterCabinetType.insets = new Insets(0, 0, 5, 5);
        gbcCbbxFilterCabinetType.gridx = 3;
        gbcCbbxFilterCabinetType.gridy = 4;
        panel.add(this.cbbxFilterCabinetType, gbcCbbxFilterCabinetType);
        this.cbbxFilterCabinetType.addItemListener(e -> this.cbbxFilterCabinetTypeValueChanged(session, e));
        this.cbbxFilterCabinetType.setModel(new DefaultComboBoxModel<Machine.CabinetType>(Machine.CabinetType.values()));
        JLabel lblDisplayOrientation = new JLabel(Messages.getString((String)"MainFrame.lblOrientation.text"));
        GridBagConstraints gbcLblDisplayOrientation = new GridBagConstraints();
        gbcLblDisplayOrientation.gridwidth = 2;
        gbcLblDisplayOrientation.fill = 2;
        gbcLblDisplayOrientation.insets = new Insets(0, 0, 5, 5);
        gbcLblDisplayOrientation.gridx = 1;
        gbcLblDisplayOrientation.gridy = 5;
        panel.add((Component)lblDisplayOrientation, gbcLblDisplayOrientation);
        lblDisplayOrientation.setHorizontalAlignment(11);
        this.cbbxFilterDisplayOrientation = new JComboBox();
        GridBagConstraints gbcCbbxFilterDisplayOrientation = new GridBagConstraints();
        gbcCbbxFilterDisplayOrientation.fill = 2;
        gbcCbbxFilterDisplayOrientation.insets = new Insets(0, 0, 5, 5);
        gbcCbbxFilterDisplayOrientation.gridx = 3;
        gbcCbbxFilterDisplayOrientation.gridy = 5;
        panel.add(this.cbbxFilterDisplayOrientation, gbcCbbxFilterDisplayOrientation);
        this.cbbxFilterDisplayOrientation.addItemListener(e -> this.cbbxFilterDisplayOrientationValueChanged(session, e));
        this.cbbxFilterDisplayOrientation.setModel(new DefaultComboBoxModel<Machine.DisplayOrientation>(Machine.DisplayOrientation.values()));
        JLabel lblDriverStatus = new JLabel(Messages.getString((String)"MainFrame.lblDriverStatus.text"));
        GridBagConstraints gbcLblDriverStatus = new GridBagConstraints();
        gbcLblDriverStatus.gridwidth = 2;
        gbcLblDriverStatus.fill = 2;
        gbcLblDriverStatus.insets = new Insets(0, 0, 5, 5);
        gbcLblDriverStatus.gridx = 1;
        gbcLblDriverStatus.gridy = 6;
        panel.add((Component)lblDriverStatus, gbcLblDriverStatus);
        lblDriverStatus.setHorizontalAlignment(11);
        this.cbbxDriverStatus = new JComboBox();
        GridBagConstraints gbcCbbxDriverStatus = new GridBagConstraints();
        gbcCbbxDriverStatus.fill = 2;
        gbcCbbxDriverStatus.insets = new Insets(0, 0, 5, 5);
        gbcCbbxDriverStatus.gridx = 3;
        gbcCbbxDriverStatus.gridy = 6;
        panel.add(this.cbbxDriverStatus, gbcCbbxDriverStatus);
        this.cbbxDriverStatus.setModel(new DefaultComboBoxModel<Driver.StatusType>(Driver.StatusType.values()));
        JLabel lblSwMinSupportedLvl = new JLabel(Messages.getString((String)"MainFrame.lblSwMinSupport.text"));
        GridBagConstraints gbcLblSwMinSupportedLvl = new GridBagConstraints();
        gbcLblSwMinSupportedLvl.gridwidth = 2;
        gbcLblSwMinSupportedLvl.fill = 2;
        gbcLblSwMinSupportedLvl.insets = new Insets(0, 0, 5, 5);
        gbcLblSwMinSupportedLvl.gridx = 1;
        gbcLblSwMinSupportedLvl.gridy = 7;
        panel.add((Component)lblSwMinSupportedLvl, gbcLblSwMinSupportedLvl);
        lblSwMinSupportedLvl.setHorizontalAlignment(11);
        this.cbbxSWMinSupportedLvl = new JComboBox();
        GridBagConstraints gbcCbbxSWMinSupportedLvl = new GridBagConstraints();
        gbcCbbxSWMinSupportedLvl.fill = 2;
        gbcCbbxSWMinSupportedLvl.insets = new Insets(0, 0, 5, 5);
        gbcCbbxSWMinSupportedLvl.gridx = 3;
        gbcCbbxSWMinSupportedLvl.gridy = 7;
        panel.add(this.cbbxSWMinSupportedLvl, gbcCbbxSWMinSupportedLvl);
        this.cbbxSWMinSupportedLvl.addItemListener(e -> this.cbbxSWMinSupportedLvlValueChanged(session, e));
        this.cbbxSWMinSupportedLvl.setModel(new DefaultComboBoxModel<Software.Supported>(Software.Supported.values()));
        this.cbbxSWMinSupportedLvl.setSelectedIndex(0);
        this.cbbxYearMin = new JComboBox();
        this.cbbxYearMin.addItemListener(e -> this.cbbxYearMinValueChanged(session, e));
        GridBagConstraints gbcCbbxYearMin = new GridBagConstraints();
        gbcCbbxYearMin.fill = 2;
        gbcCbbxYearMin.insets = new Insets(0, 0, 5, 5);
        gbcCbbxYearMin.gridx = 1;
        gbcCbbxYearMin.gridy = 8;
        panel.add(this.cbbxYearMin, gbcCbbxYearMin);
        JLabel lblYear = new JLabel(Messages.getString((String)"MainFrame.lblYear.text"));
        GridBagConstraints gbcLblYear = new GridBagConstraints();
        gbcLblYear.insets = new Insets(0, 0, 5, 5);
        gbcLblYear.gridx = 2;
        gbcLblYear.gridy = 8;
        panel.add((Component)lblYear, gbcLblYear);
        lblYear.setHorizontalAlignment(0);
        this.cbbxYearMax = new JComboBox();
        this.cbbxYearMax.addItemListener(e -> this.cbbxYearMaxValueChanged(session, e));
        GridBagConstraints gbcCbbxYearMax = new GridBagConstraints();
        gbcCbbxYearMax.fill = 2;
        gbcCbbxYearMax.insets = new Insets(0, 0, 5, 5);
        gbcCbbxYearMax.gridx = 3;
        gbcCbbxYearMax.gridy = 8;
        panel.add(this.cbbxYearMax, gbcCbbxYearMax);
        this.cbbxDriverStatus.addItemListener(e -> this.cbbxDriverStatusValueChanged(session, e));
        this.chckbxIncludeDisks.addItemListener(e -> this.chckbxIncludeDisksStateChanged(session, e));
        this.chckbxIncludeClones.addItemListener(e -> this.chckbxIncludeClonesStateChanged(session, e));
        this.chckbxIncludeSamples.addItemListener(e -> this.chckbxIncludeSamplesStateChanged(session, e));
    }

    private void buildSystemsMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        Popup.addPopup(this.checkBoxListSystems, popupMenu);
        JMenu mnSelect = new JMenu(Messages.getString((String)"MainFrame.mnSelect.text"));
        popupMenu.add(mnSelect);
        JMenuItem mntmSelectAll = new JMenuItem(Messages.getString((String)"MainFrame.mntmSelectAll.text"));
        mntmSelectAll.addActionListener(e -> this.checkBoxListSystems.selectAll());
        mnSelect.add(mntmSelectAll);
        JMenuItem mntmSelectAllBios = new JMenuItem(Messages.getString((String)"MainFrame.mntmAllBios.text"));
        mntmSelectAllBios.addActionListener(e -> this.checkBoxListSystems.select(sys -> sys.getType() == Systm.Type.BIOS, true));
        mnSelect.add(mntmSelectAllBios);
        JMenuItem mntmSelectAllSoftwares = new JMenuItem(Messages.getString((String)"MainFrame.mntmAllSoftwares.text"));
        mntmSelectAllSoftwares.addActionListener(e -> this.checkBoxListSystems.select(sys -> sys.getType() == Systm.Type.SOFTWARELIST, true));
        mnSelect.add(mntmSelectAllSoftwares);
        JMenu mnUnselect = new JMenu(Messages.getString((String)"MainFrame.mnUnselect.text"));
        popupMenu.add(mnUnselect);
        JMenuItem mntmUnselectAll = new JMenuItem(Messages.getString((String)"MainFrame.mntmSelectNone.text"));
        mntmUnselectAll.addActionListener(e -> this.checkBoxListSystems.selectNone());
        mnUnselect.add(mntmUnselectAll);
        JMenuItem mntmUnselectAllBios = new JMenuItem(Messages.getString((String)"MainFrame.mntmAllBios.text"));
        mntmUnselectAllBios.addActionListener(e -> this.checkBoxListSystems.select(sys -> sys.getType() == Systm.Type.BIOS, false));
        mnUnselect.add(mntmUnselectAllBios);
        JMenuItem mntmUnselectAllSoftwares = new JMenuItem(Messages.getString((String)"MainFrame.mntmAllSoftwares.text"));
        mntmUnselectAllSoftwares.addActionListener(e -> this.checkBoxListSystems.select(sys -> sys.getType() == Systm.Type.SOFTWARELIST, false));
        mnUnselect.add(mntmUnselectAllSoftwares);
        JMenuItem mntmInvertSelection = new JMenuItem(Messages.getString((String)"MainFrame.mntmInvertSelection.text"));
        mntmInvertSelection.addActionListener(e -> this.checkBoxListSystems.selectInvert());
        popupMenu.add(mntmInvertSelection);
    }

    private void buildSourcesMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        Popup.addPopup(this.checkBoxListSources, popupMenu);
        JMenuItem mntmSelectAll = new JMenuItem(Messages.getString((String)"MainFrame.mntmSelectAll.text"));
        mntmSelectAll.addActionListener(e -> this.checkBoxListSources.selectAll());
        popupMenu.add(mntmSelectAll);
        JMenuItem mntmUnselectAll = new JMenuItem(Messages.getString((String)"MainFrame.mntmSelectNone.text"));
        mntmUnselectAll.addActionListener(e -> this.checkBoxListSources.selectNone());
        popupMenu.add(mntmUnselectAll);
        JMenuItem mntmInvertSelection = new JMenuItem(Messages.getString((String)"MainFrame.mntmInvertSelection.text"));
        mntmInvertSelection.addActionListener(e -> this.checkBoxListSources.selectInvert());
        popupMenu.add(mntmInvertSelection);
    }

    private void chckbxIncludeSamplesStateChanged(Session session, ItemEvent e) {
        session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_InclSamples, e.getStateChange() == 1);
        if (MainFrame.getProfileViewer() != null) {
            MainFrame.getProfileViewer().reset(session.getCurrProfile());
        }
    }

    private void chckbxIncludeClonesStateChanged(Session session, ItemEvent e) {
        session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_InclClones, e.getStateChange() == 1);
        if (MainFrame.getProfileViewer() != null) {
            MainFrame.getProfileViewer().reset(session.getCurrProfile());
        }
    }

    private void chckbxIncludeDisksStateChanged(Session session, ItemEvent e) {
        session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_InclDisks, e.getStateChange() == 1);
        if (MainFrame.getProfileViewer() != null) {
            MainFrame.getProfileViewer().reset(session.getCurrProfile());
        }
    }

    private void cbbxDriverStatusValueChanged(Session session, ItemEvent e) {
        if (e.getStateChange() == 1) {
            session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_DriverStatus, e.getItem().toString());
            if (MainFrame.getProfileViewer() != null) {
                MainFrame.getProfileViewer().reset(session.getCurrProfile());
            }
        }
    }

    private void cbbxYearMaxValueChanged(Session session, ItemEvent e) {
        if (e.getStateChange() == 1) {
            session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_YearMax, e.getItem().toString());
            if (MainFrame.getProfileViewer() != null) {
                MainFrame.getProfileViewer().reset(session.getCurrProfile());
            }
        }
    }

    private void cbbxYearMinValueChanged(Session session, ItemEvent e) {
        if (e.getStateChange() == 1) {
            session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_YearMin, e.getItem().toString());
            if (MainFrame.getProfileViewer() != null) {
                MainFrame.getProfileViewer().reset(session.getCurrProfile());
            }
        }
    }

    private void cbbxSWMinSupportedLvlValueChanged(Session session, ItemEvent e) {
        if (e.getStateChange() == 1) {
            session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_MinSoftwareSupportedLevel, e.getItem().toString());
            if (MainFrame.getProfileViewer() != null) {
                MainFrame.getProfileViewer().reset(session.getCurrProfile());
            }
        }
    }

    private void cbbxFilterDisplayOrientationValueChanged(Session session, ItemEvent e) {
        if (e.getStateChange() == 1) {
            session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_DisplayOrientation, e.getItem().toString());
            if (MainFrame.getProfileViewer() != null) {
                MainFrame.getProfileViewer().reset(session.getCurrProfile());
            }
        }
    }

    private void cbbxFilterCabinetTypeValueChanged(Session session, ItemEvent e) {
        if (e.getStateChange() == 1) {
            session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_CabinetType, e.getItem().toString());
            if (MainFrame.getProfileViewer() != null) {
                MainFrame.getProfileViewer().reset(session.getCurrProfile());
            }
        }
    }

    private void checkBoxListSystemsValueChanged(Session session, ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && e.getFirstIndex() != -1) {
            for (int index = e.getFirstIndex(); index <= e.getLastIndex(); ++index) {
                ((Systm)this.checkBoxListSystems.getModel().getElementAt(index)).setSelected(session.getCurrProfile(), this.checkBoxListSystems.isSelectedIndex(index));
            }
            if (MainFrame.getProfileViewer() != null) {
                MainFrame.getProfileViewer().reset(session.getCurrProfile());
            }
        }
    }

    private void checkBoxListSourcesValueChanged(Session session, ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && e.getFirstIndex() != -1) {
            for (int index = e.getFirstIndex(); index <= e.getLastIndex(); ++index) {
                ((Source)this.checkBoxListSources.getModel().getElementAt(index)).setSelected(session.getCurrProfile(), this.checkBoxListSources.isSelectedIndex(index));
            }
            if (MainFrame.getProfileViewer() != null) {
                MainFrame.getProfileViewer().reset(session.getCurrProfile());
            }
        }
    }

    private JCheckBoxList.CellRenderer getCheckBoxListSystemsCellRenderer(final Session session) {
        JCheckBoxList<Systm> jCheckBoxList = this.checkBoxListSystems;
        Objects.requireNonNull(jCheckBoxList);
        return new JCheckBoxList.CellRenderer(this, jCheckBoxList){

            @Override
            public Component getListCellRendererComponent(JList<? extends Systm> list, Systm value, int index, boolean isSelected, boolean cellHasFocus) {
                JCheckBox checkbox = (JCheckBox)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                checkbox.setSelected(value.isSelected(session.getCurrProfile()));
                return checkbox;
            }
        };
    }

    private JCheckBoxList.CellRenderer getCheckBoxListSourcesCellRenderer(final Session session) {
        JCheckBoxList<Source> jCheckBoxList = this.checkBoxListSources;
        Objects.requireNonNull(jCheckBoxList);
        return new JCheckBoxList.CellRenderer(this, jCheckBoxList){

            @Override
            public Component getListCellRendererComponent(JList<? extends Source> list, Source value, int index, boolean isSelected, boolean cellHasFocus) {
                JCheckBox checkbox = (JCheckBox)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                checkbox.setSelected(value.isSelected(session.getCurrProfile()));
                return checkbox;
            }
        };
    }

    public void initProfileSettings(Session session) {
        this.chckbxIncludeClones.setSelected((Boolean)session.getCurrProfile().getProperty(ProfileSettingsEnum.filter_InclClones, Boolean.class));
        this.chckbxIncludeDisks.setSelected((Boolean)session.getCurrProfile().getProperty(ProfileSettingsEnum.filter_InclDisks, Boolean.class));
        this.chckbxIncludeSamples.setSelected((Boolean)session.getCurrProfile().getProperty(ProfileSettingsEnum.filter_InclSamples, Boolean.class));
        this.cbbxDriverStatus.setSelectedItem(Driver.StatusType.valueOf((String)session.getCurrProfile().getProperty(ProfileSettingsEnum.filter_DriverStatus)));
        this.cbbxFilterCabinetType.setSelectedItem(Machine.CabinetType.valueOf((String)session.getCurrProfile().getProperty(ProfileSettingsEnum.filter_CabinetType)));
        this.cbbxFilterDisplayOrientation.setSelectedItem(Machine.DisplayOrientation.valueOf((String)session.getCurrProfile().getProperty(ProfileSettingsEnum.filter_DisplayOrientation)));
        this.cbbxSWMinSupportedLvl.setSelectedItem(Software.Supported.valueOf((String)session.getCurrProfile().getProperty(ProfileSettingsEnum.filter_MinSoftwareSupportedLevel)));
        this.cbbxYearMin.setModel(new YearsModel(session.getCurrProfile().getYears()));
        this.cbbxYearMin.setSelectedItem(session.getCurrProfile().getProperty(ProfileSettingsEnum.filter_YearMin));
        this.cbbxYearMax.setModel(new YearsModel(session.getCurrProfile().getYears()));
        this.cbbxYearMax.setSelectedItem(session.getCurrProfile().getProperty(ProfileSettingsEnum.filter_YearMax));
    }
}

