/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import jrm.locale.Messages;
import jrm.misc.EnumWithDefault;
import jrm.misc.ProfileSettings;
import jrm.misc.ProfileSettingsEnum;
import jrm.profile.scan.options.FormatOptions;
import jrm.profile.scan.options.HashCollisionOptions;
import jrm.profile.scan.options.MergeOptions;
import jrm.ui.basic.Popup;
import lombok.Generated;

public class ScannerSettingsPanel
extends JPanel {
    private JPanel scannerSubSettingsPanel;
    private JCheckBox chckbxCreateMissingSets;
    private JCheckBox chckbxCreateOnlyComplete;
    private JCheckBox chckbxIgnoreUnknownContainers;
    private JCheckBox chckbxIgnoreUnneededContainers;
    private JCheckBox chckbxIgnoreUnneededEntries;
    private JCheckBox chckbxNeedSHA1;
    private JCheckBox chckbxUseImplicitMerge;
    private JCheckBox chckbxUseParallelism;
    private JCheckBox chckbxIgnoreMergeNameRoms;
    private JCheckBox chckbxIgnoreMergeNameDisks;
    private JCheckBox chckbxExcludeGames;
    private JCheckBox chckbxExcludeMachines;
    private JCheckBox chckbxBackup;
    private JComboBox<MergeOptions> cbbxMergeMode;
    private JComboBox<FormatOptions> cbCompression;
    private JComboBox<HashCollisionOptions> cbHashCollision;
    private transient ProfileSettings settings;

    public ScannerSettingsPanel() {
        this.setBackground(UIManager.getColor("Panel.background"));
        JPopupMenu popupMenu = new JPopupMenu();
        Popup.addPopup(this, popupMenu);
        JMenu mnPresets = new JMenu(Messages.getString((String)"MainFrame.mnPresets.text"));
        popupMenu.add(mnPresets);
        JMenu mnPdMame = new JMenu(Messages.getString((String)"MainFrame.mnPdMame.text"));
        mnPresets.add(mnPdMame);
        JMenuItem mntmPleasuredome = new JMenuItem(Messages.getString((String)"MainFrame.mntmPleasuredome.text"));
        mnPdMame.add(mntmPleasuredome);
        JMenuItem mntmPdMameNon = new JMenuItem(Messages.getString((String)"MainFrame.mntmPdMameNon.text"));
        mnPdMame.add(mntmPdMameNon);
        JMenuItem mntmPdMameSplit = new JMenuItem(Messages.getString((String)"MainFrame.mntmPdMameSplit.text"));
        mnPdMame.add(mntmPdMameSplit);
        mntmPdMameSplit.addActionListener(e -> {
            this.chckbxCreateMissingSets.setSelected(true);
            this.chckbxCreateOnlyComplete.setSelected(false);
            this.chckbxIgnoreUnneededContainers.setSelected(false);
            this.chckbxIgnoreUnneededEntries.setSelected(false);
            this.chckbxIgnoreUnknownContainers.setSelected(true);
            this.chckbxUseImplicitMerge.setSelected(true);
            this.chckbxIgnoreMergeNameDisks.setSelected(true);
            this.chckbxIgnoreMergeNameRoms.setSelected(false);
            this.cbCompression.setSelectedItem(FormatOptions.TZIP);
            this.cbbxMergeMode.setSelectedItem(MergeOptions.SPLIT);
        });
        mntmPdMameNon.addActionListener(e -> {
            this.chckbxCreateMissingSets.setSelected(true);
            this.chckbxCreateOnlyComplete.setSelected(false);
            this.chckbxIgnoreUnneededContainers.setSelected(false);
            this.chckbxIgnoreUnneededEntries.setSelected(false);
            this.chckbxIgnoreUnknownContainers.setSelected(true);
            this.chckbxUseImplicitMerge.setSelected(true);
            this.chckbxIgnoreMergeNameDisks.setSelected(true);
            this.chckbxIgnoreMergeNameRoms.setSelected(false);
            this.cbCompression.setSelectedItem(FormatOptions.TZIP);
            this.cbbxMergeMode.setSelectedItem(MergeOptions.SUPERFULLNOMERGE);
        });
        mntmPleasuredome.addActionListener(e -> {
            this.chckbxCreateMissingSets.setSelected(true);
            this.chckbxCreateOnlyComplete.setSelected(false);
            this.chckbxIgnoreUnneededContainers.setSelected(false);
            this.chckbxIgnoreUnneededEntries.setSelected(false);
            this.chckbxIgnoreUnknownContainers.setSelected(true);
            this.chckbxUseImplicitMerge.setSelected(true);
            this.chckbxIgnoreMergeNameDisks.setSelected(true);
            this.chckbxIgnoreMergeNameRoms.setSelected(false);
            this.cbCompression.setSelectedItem(FormatOptions.TZIP);
            this.cbbxMergeMode.setSelectedItem(MergeOptions.MERGE);
            this.cbHashCollision.setSelectedItem(HashCollisionOptions.HALFDUMB);
        });
        GridBagLayout gblScannerSettingsPanel = new GridBagLayout();
        gblScannerSettingsPanel.columnWidths = new int[]{0, 0, 0};
        gblScannerSettingsPanel.rowHeights = new int[]{20, 20, 0, 0, 0, 0, 0, 20, 0};
        gblScannerSettingsPanel.columnWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        gblScannerSettingsPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.setLayout(gblScannerSettingsPanel);
        this.chckbxNeedSHA1 = new JCheckBox(Messages.getString((String)"MainFrame.chckbxNeedSHA1.text"));
        this.chckbxNeedSHA1.addItemListener(e -> this.settings.setProperty((Enum)ProfileSettingsEnum.need_sha1_or_md5, e.getStateChange() == 1));
        this.chckbxNeedSHA1.setToolTipText(Messages.getString((String)"MainFrame.chckbxNeedSHA1.toolTipText"));
        GridBagConstraints gbcChckbxNeedSHA1 = new GridBagConstraints();
        gbcChckbxNeedSHA1.fill = 1;
        gbcChckbxNeedSHA1.insets = new Insets(0, 0, 5, 5);
        gbcChckbxNeedSHA1.gridx = 0;
        gbcChckbxNeedSHA1.gridy = 0;
        this.add((Component)this.chckbxNeedSHA1, gbcChckbxNeedSHA1);
        this.chckbxUseParallelism = new JCheckBox(Messages.getString((String)"MainFrame.chckbxUseParallelism.text"));
        this.chckbxUseParallelism.addItemListener(e -> this.settings.setProperty((Enum)ProfileSettingsEnum.use_parallelism, e.getStateChange() == 1));
        this.chckbxUseParallelism.setToolTipText(Messages.getString((String)"MainFrame.chckbxUseParallelism.toolTipText"));
        GridBagConstraints gbcChckbxUseParallelism = new GridBagConstraints();
        gbcChckbxUseParallelism.insets = new Insets(0, 0, 5, 5);
        gbcChckbxUseParallelism.fill = 1;
        gbcChckbxUseParallelism.gridx = 0;
        gbcChckbxUseParallelism.gridy = 1;
        this.add((Component)this.chckbxUseParallelism, gbcChckbxUseParallelism);
        this.chckbxCreateMissingSets = new JCheckBox(Messages.getString((String)"MainFrame.chckbxCreateMissingSets.text"));
        this.chckbxCreateMissingSets.addItemListener(e -> {
            this.settings.setProperty((Enum)ProfileSettingsEnum.create_mode, e.getStateChange() == 1);
            if (e.getStateChange() != 1) {
                this.chckbxCreateOnlyComplete.setSelected(false);
            }
            this.chckbxCreateOnlyComplete.setEnabled(e.getStateChange() == 1);
        });
        GridBagConstraints gbcChckbxCreateMissingSets = new GridBagConstraints();
        gbcChckbxCreateMissingSets.fill = 2;
        gbcChckbxCreateMissingSets.insets = new Insets(0, 0, 5, 0);
        gbcChckbxCreateMissingSets.gridx = 1;
        gbcChckbxCreateMissingSets.gridy = 0;
        this.add((Component)this.chckbxCreateMissingSets, gbcChckbxCreateMissingSets);
        this.chckbxCreateOnlyComplete = new JCheckBox(Messages.getString((String)"MainFrame.chckbxCreateOnlyComplete.text"));
        this.chckbxCreateOnlyComplete.addItemListener(e -> this.settings.setProperty((Enum)ProfileSettingsEnum.createfull_mode, e.getStateChange() == 1));
        GridBagConstraints gbcChckbxCreateOnlyComplete = new GridBagConstraints();
        gbcChckbxCreateOnlyComplete.fill = 2;
        gbcChckbxCreateOnlyComplete.insets = new Insets(0, 0, 5, 0);
        gbcChckbxCreateOnlyComplete.gridx = 1;
        gbcChckbxCreateOnlyComplete.gridy = 1;
        this.add((Component)this.chckbxCreateOnlyComplete, gbcChckbxCreateOnlyComplete);
        this.chckbxIgnoreUnneededContainers = new JCheckBox(Messages.getString((String)"MainFrame.chckbxIgnoreUnneededContainers.text"));
        this.chckbxIgnoreUnneededContainers.addItemListener(e -> this.settings.setProperty((Enum)ProfileSettingsEnum.ignore_unneeded_containers, e.getStateChange() == 1));
        GridBagConstraints gbcChckbxIgnoreUnneededContainers = new GridBagConstraints();
        gbcChckbxIgnoreUnneededContainers.fill = 2;
        gbcChckbxIgnoreUnneededContainers.insets = new Insets(0, 0, 5, 5);
        gbcChckbxIgnoreUnneededContainers.gridx = 0;
        gbcChckbxIgnoreUnneededContainers.gridy = 2;
        this.add((Component)this.chckbxIgnoreUnneededContainers, gbcChckbxIgnoreUnneededContainers);
        this.chckbxIgnoreUnneededEntries = new JCheckBox(Messages.getString((String)"MainFrame.chckbxIgnoreUnneededEntries.text"));
        this.chckbxIgnoreUnneededEntries.addItemListener(e -> this.settings.setProperty((Enum)ProfileSettingsEnum.ignore_unneeded_entries, e.getStateChange() == 1));
        GridBagConstraints gbcchckbxIgnoreUnneededEntries = new GridBagConstraints();
        gbcchckbxIgnoreUnneededEntries.fill = 2;
        gbcchckbxIgnoreUnneededEntries.insets = new Insets(0, 0, 5, 0);
        gbcchckbxIgnoreUnneededEntries.gridx = 1;
        gbcchckbxIgnoreUnneededEntries.gridy = 2;
        this.add((Component)this.chckbxIgnoreUnneededEntries, gbcchckbxIgnoreUnneededEntries);
        this.chckbxIgnoreUnknownContainers = new JCheckBox(Messages.getString((String)"MainFrame.chckbxIgnoreUnknownContainers.text"));
        this.chckbxIgnoreUnknownContainers.addItemListener(e -> this.settings.setProperty((Enum)ProfileSettingsEnum.ignore_unknown_containers, e.getStateChange() == 1));
        GridBagConstraints gbcChckbxIgnoreUnknownContainers = new GridBagConstraints();
        gbcChckbxIgnoreUnknownContainers.fill = 2;
        gbcChckbxIgnoreUnknownContainers.insets = new Insets(0, 0, 5, 5);
        gbcChckbxIgnoreUnknownContainers.gridx = 0;
        gbcChckbxIgnoreUnknownContainers.gridy = 3;
        this.add((Component)this.chckbxIgnoreUnknownContainers, gbcChckbxIgnoreUnknownContainers);
        this.chckbxUseImplicitMerge = new JCheckBox(Messages.getString((String)"MainFrame.chckbxUseImplicitMerge.text"));
        this.chckbxUseImplicitMerge.addItemListener(e -> this.settings.setProperty((Enum)ProfileSettingsEnum.implicit_merge, e.getStateChange() == 1));
        GridBagConstraints gbcChckbxUseImplicitMerge = new GridBagConstraints();
        gbcChckbxUseImplicitMerge.fill = 2;
        gbcChckbxUseImplicitMerge.insets = new Insets(0, 0, 5, 0);
        gbcChckbxUseImplicitMerge.gridx = 1;
        gbcChckbxUseImplicitMerge.gridy = 3;
        this.add((Component)this.chckbxUseImplicitMerge, gbcChckbxUseImplicitMerge);
        this.chckbxIgnoreMergeNameRoms = new JCheckBox(Messages.getString((String)"MainFrame.chckbxIgnoreMergeName.text"));
        this.chckbxIgnoreMergeNameRoms.addItemListener(e -> this.settings.setProperty((Enum)ProfileSettingsEnum.ignore_merge_name_roms, e.getStateChange() == 1));
        GridBagConstraints gbcChckbxIgnoreMergeNameRoms = new GridBagConstraints();
        gbcChckbxIgnoreMergeNameRoms.fill = 2;
        gbcChckbxIgnoreMergeNameRoms.insets = new Insets(0, 0, 5, 5);
        gbcChckbxIgnoreMergeNameRoms.gridx = 0;
        gbcChckbxIgnoreMergeNameRoms.gridy = 4;
        this.add((Component)this.chckbxIgnoreMergeNameRoms, gbcChckbxIgnoreMergeNameRoms);
        this.chckbxIgnoreMergeNameDisks = new JCheckBox(Messages.getString((String)"MainFrame.chckbxIgnoreMergeName_1.text"));
        this.chckbxIgnoreMergeNameDisks.addItemListener(e -> this.settings.setProperty((Enum)ProfileSettingsEnum.ignore_merge_name_disks, e.getStateChange() == 1));
        GridBagConstraints gbcChckbxIgnoreMergeNameDisks = new GridBagConstraints();
        gbcChckbxIgnoreMergeNameDisks.fill = 2;
        gbcChckbxIgnoreMergeNameDisks.insets = new Insets(0, 0, 5, 0);
        gbcChckbxIgnoreMergeNameDisks.gridx = 1;
        gbcChckbxIgnoreMergeNameDisks.gridy = 4;
        this.add((Component)this.chckbxIgnoreMergeNameDisks, gbcChckbxIgnoreMergeNameDisks);
        this.chckbxExcludeGames = new JCheckBox(Messages.getString((String)"MainFrame.chckbxExcludeGames.text"));
        this.chckbxExcludeGames.addItemListener(e -> this.settings.setProperty((Enum)ProfileSettingsEnum.exclude_games, e.getStateChange() == 1));
        GridBagConstraints gbcChckbxExcludeGames = new GridBagConstraints();
        gbcChckbxExcludeGames.fill = 2;
        gbcChckbxExcludeGames.insets = new Insets(0, 0, 5, 5);
        gbcChckbxExcludeGames.gridx = 0;
        gbcChckbxExcludeGames.gridy = 5;
        this.add((Component)this.chckbxExcludeGames, gbcChckbxExcludeGames);
        this.chckbxExcludeMachines = new JCheckBox(Messages.getString((String)"MainFrame.chckbxExcludeMachines.text"));
        this.chckbxExcludeMachines.addItemListener(e -> this.settings.setProperty((Enum)ProfileSettingsEnum.exclude_machines, e.getStateChange() == 1));
        GridBagConstraints gbcChckbxExcludeMachines = new GridBagConstraints();
        gbcChckbxExcludeMachines.fill = 2;
        gbcChckbxExcludeMachines.insets = new Insets(0, 0, 5, 0);
        gbcChckbxExcludeMachines.gridx = 1;
        gbcChckbxExcludeMachines.gridy = 5;
        this.add((Component)this.chckbxExcludeMachines, gbcChckbxExcludeMachines);
        this.chckbxBackup = new JCheckBox(Messages.getString((String)"MainFrame.chckbxBackup.text"));
        this.chckbxBackup.addItemListener(e -> this.settings.setProperty((Enum)ProfileSettingsEnum.backup, e.getStateChange() == 1));
        GridBagConstraints gbcChckbxBackup = new GridBagConstraints();
        gbcChckbxBackup.fill = 2;
        gbcChckbxBackup.insets = new Insets(0, 0, 5, 5);
        gbcChckbxBackup.gridx = 0;
        gbcChckbxBackup.gridy = 6;
        this.add((Component)this.chckbxBackup, gbcChckbxBackup);
        this.scannerSubSettingsPanel = new JPanel();
        GridBagConstraints gbcScannerSubSettingsPanel = new GridBagConstraints();
        gbcScannerSubSettingsPanel.gridwidth = 2;
        gbcScannerSubSettingsPanel.fill = 1;
        gbcScannerSubSettingsPanel.gridx = 0;
        gbcScannerSubSettingsPanel.gridy = 7;
        this.add((Component)this.scannerSubSettingsPanel, gbcScannerSubSettingsPanel);
        GridBagLayout gblScannerSubSettingsPanel = new GridBagLayout();
        gblScannerSubSettingsPanel.columnWidths = new int[]{0, 0, 0, 0};
        gblScannerSubSettingsPanel.rowHeights = new int[]{0, 0, 0, 8, 100, 0};
        gblScannerSubSettingsPanel.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gblScannerSubSettingsPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.scannerSubSettingsPanel.setLayout(gblScannerSubSettingsPanel);
        JLabel lblCompression = new JLabel(Messages.getString((String)"MainFrame.lblCompression.text"));
        GridBagConstraints gbcLblCompression = new GridBagConstraints();
        gbcLblCompression.anchor = 13;
        gbcLblCompression.insets = new Insets(0, 5, 5, 5);
        gbcLblCompression.gridx = 0;
        gbcLblCompression.gridy = 0;
        this.scannerSubSettingsPanel.add((Component)lblCompression, gbcLblCompression);
        this.cbCompression = new JComboBox();
        this.cbCompression.setModel(new DefaultComboBoxModel<FormatOptions>(FormatOptions.values()));
        this.cbCompression.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(((FormatOptions)value).getDesc());
                return this;
            }
        });
        this.cbCompression.addActionListener(e -> this.settings.setProperty((Enum)ProfileSettingsEnum.format, this.cbCompression.getSelectedItem().toString()));
        GridBagConstraints gbcCBCompression = new GridBagConstraints();
        gbcCBCompression.gridwidth = 2;
        gbcCBCompression.insets = new Insets(0, 0, 5, 5);
        gbcCBCompression.fill = 2;
        gbcCBCompression.gridx = 1;
        gbcCBCompression.gridy = 0;
        this.scannerSubSettingsPanel.add(this.cbCompression, gbcCBCompression);
        JLabel lblMergeMode = new JLabel(Messages.getString((String)"MainFrame.lblMergeMode.text"));
        GridBagConstraints gbcLblMergeMode = new GridBagConstraints();
        gbcLblMergeMode.insets = new Insets(0, 0, 5, 5);
        gbcLblMergeMode.anchor = 13;
        gbcLblMergeMode.gridx = 0;
        gbcLblMergeMode.gridy = 1;
        this.scannerSubSettingsPanel.add((Component)lblMergeMode, gbcLblMergeMode);
        this.cbbxMergeMode = new JComboBox();
        GridBagConstraints gbcCbbxMergeMode = new GridBagConstraints();
        gbcCbbxMergeMode.insets = new Insets(0, 0, 5, 5);
        gbcCbbxMergeMode.gridwidth = 2;
        gbcCbbxMergeMode.fill = 2;
        gbcCbbxMergeMode.gridx = 1;
        gbcCbbxMergeMode.gridy = 1;
        this.scannerSubSettingsPanel.add(this.cbbxMergeMode, gbcCbbxMergeMode);
        this.cbbxMergeMode.setToolTipText(Messages.getString((String)"MainFrame.cbbxMergeMode.toolTipText"));
        this.cbbxMergeMode.setModel(new DefaultComboBoxModel<MergeOptions>(MergeOptions.values()));
        this.cbbxMergeMode.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(((MergeOptions)value).getDesc());
                return this;
            }
        });
        this.cbbxMergeMode.addActionListener(e -> {
            this.settings.setProperty((Enum)ProfileSettingsEnum.merge_mode, this.cbbxMergeMode.getSelectedItem().toString());
            this.cbHashCollision.setEnabled(((MergeOptions)this.cbbxMergeMode.getSelectedItem()).isMerge());
        });
        JLabel lblHashCollision = new JLabel(Messages.getString((String)"MainFrame.lblHashCollision.text"));
        GridBagConstraints gbcLblHashCollision = new GridBagConstraints();
        gbcLblHashCollision.insets = new Insets(0, 0, 5, 5);
        gbcLblHashCollision.anchor = 13;
        gbcLblHashCollision.gridx = 0;
        gbcLblHashCollision.gridy = 2;
        this.scannerSubSettingsPanel.add((Component)lblHashCollision, gbcLblHashCollision);
        this.cbHashCollision = new JComboBox();
        this.cbHashCollision.setModel(new DefaultComboBoxModel<HashCollisionOptions>(HashCollisionOptions.values()));
        this.cbHashCollision.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(((HashCollisionOptions)value).getDesc());
                return this;
            }
        });
        this.cbHashCollision.addActionListener(e -> this.settings.setProperty((Enum)ProfileSettingsEnum.hash_collision_mode, this.cbHashCollision.getSelectedItem().toString()));
        GridBagConstraints gbcCbHashCollision = new GridBagConstraints();
        gbcCbHashCollision.gridwidth = 2;
        gbcCbHashCollision.insets = new Insets(0, 0, 5, 5);
        gbcCbHashCollision.fill = 2;
        gbcCbHashCollision.gridx = 1;
        gbcCbHashCollision.gridy = 2;
        this.scannerSubSettingsPanel.add(this.cbHashCollision, gbcCbHashCollision);
    }

    public void initProfileSettings(ProfileSettings settings) {
        this.settings = settings;
        this.chckbxNeedSHA1.setSelected((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.need_sha1_or_md5, Boolean.class));
        this.chckbxUseParallelism.setSelected((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.use_parallelism, Boolean.class));
        this.chckbxCreateMissingSets.setSelected((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.create_mode, Boolean.class));
        this.chckbxCreateOnlyComplete.setSelected((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.createfull_mode, Boolean.class) != false && this.chckbxCreateMissingSets.isSelected());
        this.chckbxIgnoreUnneededContainers.setSelected((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.ignore_unneeded_containers, Boolean.class));
        this.chckbxIgnoreUnneededEntries.setSelected((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.ignore_unneeded_entries, Boolean.class));
        this.chckbxIgnoreUnknownContainers.setSelected((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.ignore_unknown_containers, Boolean.class));
        this.chckbxUseImplicitMerge.setSelected((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.implicit_merge, Boolean.class));
        this.chckbxIgnoreMergeNameRoms.setSelected((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.ignore_merge_name_roms, Boolean.class));
        this.chckbxIgnoreMergeNameDisks.setSelected((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.ignore_merge_name_disks, Boolean.class));
        this.chckbxExcludeGames.setSelected((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.exclude_games, Boolean.class));
        this.chckbxExcludeMachines.setSelected((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.exclude_machines, Boolean.class));
        this.chckbxBackup.setSelected((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.backup, Boolean.class));
        this.cbCompression.setSelectedItem(FormatOptions.valueOf((String)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.format)));
        this.cbbxMergeMode.setSelectedItem(MergeOptions.valueOf((String)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.merge_mode)));
        this.cbHashCollision.setSelectedItem(HashCollisionOptions.valueOf((String)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.hash_collision_mode)));
        this.cbHashCollision.setEnabled(((MergeOptions)this.cbbxMergeMode.getSelectedItem()).isMerge());
        this.chckbxCreateOnlyComplete.setEnabled(this.chckbxCreateMissingSets.isSelected());
    }

    @Generated
    public ProfileSettings getSettings() {
        return this.settings;
    }
}

