/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.SoftBevelBorder;
import jrm.locale.Messages;
import jrm.misc.EnumWithDefault;
import jrm.misc.Log;
import jrm.misc.SettingsEnum;
import jrm.security.Session;

public class SettingsDbgPanel
extends JPanel {
    private static final String XX_MIB = "%.2f MiB";
    private JComboBox<Level> cbLogLevel;
    private JLabel lblMemoryUsage;
    final transient ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    final Level[] levels = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL};

    public SettingsDbgPanel(Session session) {
        GridBagLayout gblDebug = new GridBagLayout();
        gblDebug.columnWidths = new int[]{50, 0, 0, 10, 0};
        gblDebug.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
        gblDebug.columnWeights = new double[]{1.0, 1.0, 0.0, 1.0, Double.MIN_VALUE};
        gblDebug.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.setLayout(gblDebug);
        JLabel lblLogLevel = new JLabel(Messages.getString((String)"MainFrame.lblLogLevel.text"));
        GridBagConstraints gbcLblLogLevel = new GridBagConstraints();
        gbcLblLogLevel.anchor = 13;
        gbcLblLogLevel.fill = 3;
        gbcLblLogLevel.insets = new Insets(0, 0, 5, 5);
        gbcLblLogLevel.gridx = 0;
        gbcLblLogLevel.gridy = 1;
        this.add((Component)lblLogLevel, gbcLblLogLevel);
        this.cbLogLevel = new JComboBox<Level>(new DefaultComboBoxModel<Level>(this.levels));
        GridBagConstraints gbcCbLogLevel = new GridBagConstraints();
        gbcCbLogLevel.gridwidth = 2;
        gbcCbLogLevel.insets = new Insets(0, 0, 5, 5);
        gbcCbLogLevel.fill = 2;
        gbcCbLogLevel.gridx = 1;
        gbcCbLogLevel.gridy = 1;
        this.add(this.cbLogLevel, gbcCbLogLevel);
        this.cbLogLevel.addActionListener(arg0 -> {
            session.getUser().getSettings().setProperty((Enum)SettingsEnum.debug_level, this.cbLogLevel.getSelectedItem().toString());
            Log.setLevel((Level)Level.parse(this.cbLogLevel.getSelectedItem().toString()));
        });
        this.cbLogLevel.setSelectedItem(Level.parse(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.debug_level)));
        JLabel lblMemory = new JLabel(Messages.getString((String)"MainFrame.lblMemory.text"));
        lblMemory.setHorizontalAlignment(11);
        GridBagConstraints gbcLblMemory = new GridBagConstraints();
        gbcLblMemory.anchor = 13;
        gbcLblMemory.insets = new Insets(0, 0, 5, 5);
        gbcLblMemory.gridx = 0;
        gbcLblMemory.gridy = 2;
        this.add((Component)lblMemory, gbcLblMemory);
        this.lblMemoryUsage = new JLabel(" ");
        this.lblMemoryUsage.setBorder(new SoftBevelBorder(1, null, null, null, null));
        GridBagConstraints gbcLblMemoryUsage = new GridBagConstraints();
        gbcLblMemoryUsage.fill = 1;
        gbcLblMemoryUsage.insets = new Insets(0, 0, 5, 5);
        gbcLblMemoryUsage.gridx = 1;
        gbcLblMemoryUsage.gridy = 2;
        this.add((Component)this.lblMemoryUsage, gbcLblMemoryUsage);
        JButton btnGc = new JButton(Messages.getString((String)"MainFrame.btnGc.text"));
        btnGc.addActionListener(e -> {
            System.gc();
            this.updateMemory();
        });
        GridBagConstraints gbcBtnGc = new GridBagConstraints();
        gbcBtnGc.fill = 2;
        gbcBtnGc.insets = new Insets(0, 0, 5, 5);
        gbcBtnGc.gridx = 2;
        gbcBtnGc.gridy = 2;
        this.add((Component)btnGc, gbcBtnGc);
        this.scheduler.scheduleAtFixedRate(this::updateMemory, 0L, 20L, TimeUnit.SECONDS);
    }

    void updateMemory() {
        Runtime rt = Runtime.getRuntime();
        this.lblMemoryUsage.setText(String.format(Messages.getString((String)"MainFrame.MemoryUsage"), String.format(XX_MIB, (double)rt.totalMemory() / 1048576.0), String.format(XX_MIB, (double)(rt.totalMemory() - rt.freeMemory()) / 1048576.0), String.format(XX_MIB, (double)rt.freeMemory() / 1048576.0), String.format(XX_MIB, (double)rt.maxMemory() / 1048576.0)));
    }
}

