/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jrm.locale.Messages;
import jrm.misc.EnumWithDefault;
import jrm.misc.ProfileSettingsEnum;
import jrm.misc.SettingsEnum;
import jrm.security.Session;
import jrm.ui.MainFrame;
import jrm.ui.basic.JFileDropMode;
import jrm.ui.basic.JFileDropTextField;
import jrm.ui.basic.JRMFileChooser;
import jrm.ui.basic.JTextFieldHintUI;
import lombok.Generated;

public class SettingsGenPanel
extends JPanel {
    private JComboBox<ThreadCnt> cbThreading;
    final transient ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public SettingsGenPanel(Session session) {
        GridBagLayout gblDebug = new GridBagLayout();
        gblDebug.columnWidths = new int[]{50, 0, 10, 10, 50};
        gblDebug.rowHeights = new int[]{0, 0, 0, 0, 0};
        gblDebug.columnWeights = new double[]{1.0, 1.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        gblDebug.rowWeights = new double[]{1.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.setLayout(gblDebug);
        JLabel lblThreading = new JLabel(Messages.getString((String)"SettingsGenPanel.lblThreading.text"));
        GridBagConstraints gbcLblThreading = new GridBagConstraints();
        gbcLblThreading.anchor = 13;
        gbcLblThreading.fill = 3;
        gbcLblThreading.insets = new Insets(0, 0, 5, 5);
        gbcLblThreading.gridx = 0;
        gbcLblThreading.gridy = 1;
        this.add((Component)lblThreading, gbcLblThreading);
        this.cbThreading = new JComboBox<ThreadCnt>(new DefaultComboBoxModel<ThreadCnt>(ThreadCnt.build()));
        GridBagConstraints gbcCBThreading = new GridBagConstraints();
        gbcCBThreading.insets = new Insets(0, 0, 5, 5);
        gbcCBThreading.fill = 2;
        gbcCBThreading.gridx = 1;
        gbcCBThreading.gridy = 1;
        gbcCBThreading.gridwidth = 3;
        this.add(this.cbThreading, gbcCBThreading);
        this.cbThreading.addActionListener(arg0 -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.thread_count, ((ThreadCnt)this.cbThreading.getSelectedItem()).getCnt()));
        this.cbThreading.setSelectedItem(new ThreadCnt((Integer)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.thread_count, Integer.class)));
        JFileDropTextField tfBackupDest = new JFileDropTextField(txt -> session.getUser().getSettings().setProperty((Enum)ProfileSettingsEnum.backup_dest_dir, txt));
        tfBackupDest.setMode(JFileDropMode.DIRECTORY);
        tfBackupDest.setEnabled((Boolean)session.getUser().getSettings().getProperty((EnumWithDefault)ProfileSettingsEnum.backup_dest_dir_enabled, Boolean.class));
        tfBackupDest.setUI(new JTextFieldHintUI(Messages.getString((String)"MainFrame.DropDirHint"), Color.gray));
        tfBackupDest.setText(session.getUser().getSettings().getProperty((EnumWithDefault)ProfileSettingsEnum.backup_dest_dir));
        JButton btnBackupDest = new JButton("");
        btnBackupDest.addActionListener(e -> {
            File workdir = session.getUser().getSettings().getWorkPath().toFile();
            new JRMFileChooser<Boolean>(0, 1, new File(session.getUser().getSettings().getProperty("MainFrame.ChooseBackupGDestination", workdir.getAbsolutePath())), new File(tfBackupDest.getText()), null, Messages.getString((String)"MainFrame.ChooseBackupDestination"), false).show(SwingUtilities.getWindowAncestor(this), chooser -> {
                session.getUser().getSettings().setProperty("MainFrame.ChooseBackupGDestination", chooser.getCurrentDirectory().getAbsolutePath());
                tfBackupDest.setText(chooser.getSelectedFile().getAbsolutePath());
                session.getUser().getSettings().setProperty((Enum)ProfileSettingsEnum.backup_dest_dir, tfBackupDest.getText());
                return true;
            });
        });
        btnBackupDest.setEnabled((Boolean)session.getUser().getSettings().getProperty((EnumWithDefault)ProfileSettingsEnum.backup_dest_dir_enabled, Boolean.class));
        btnBackupDest.setIcon(MainFrame.getIcon("/jrm/resicons/icons/disk.png"));
        JCheckBox lblBackupDest = new JCheckBox(Messages.getString((String)"MainFrame.lblBackupDest.text"));
        lblBackupDest.addItemListener(e -> {
            tfBackupDest.setEnabled(e.getStateChange() == 1);
            btnBackupDest.setEnabled(e.getStateChange() == 1);
            session.getUser().getSettings().setProperty((Enum)ProfileSettingsEnum.backup_dest_dir_enabled, e.getStateChange() == 1);
        });
        lblBackupDest.setHorizontalAlignment(11);
        lblBackupDest.setSelected((Boolean)session.getUser().getSettings().getProperty((EnumWithDefault)ProfileSettingsEnum.backup_dest_dir_enabled, Boolean.class));
        GridBagConstraints gbcLblBackupDest = new GridBagConstraints();
        gbcLblBackupDest.fill = 2;
        gbcLblBackupDest.insets = new Insets(0, 0, 5, 5);
        gbcLblBackupDest.gridx = 0;
        gbcLblBackupDest.gridy = 2;
        this.add((Component)lblBackupDest, gbcLblBackupDest);
        GridBagConstraints gbcTFBackupDest = new GridBagConstraints();
        gbcTFBackupDest.insets = new Insets(0, 0, 5, 0);
        gbcTFBackupDest.fill = 1;
        gbcTFBackupDest.gridx = 1;
        gbcTFBackupDest.gridy = 2;
        this.add((Component)tfBackupDest, gbcTFBackupDest);
        tfBackupDest.setColumns(10);
        GridBagConstraints gbcBtnBackupDest = new GridBagConstraints();
        gbcBtnBackupDest.insets = new Insets(0, 0, 5, 5);
        gbcBtnBackupDest.gridx = 2;
        gbcBtnBackupDest.gridy = 2;
        this.add((Component)btnBackupDest, gbcBtnBackupDest);
    }

    private static class ThreadCnt {
        final int cnt;
        final String name;

        public ThreadCnt(int cnt) {
            this.cnt = cnt;
            this.name = null;
        }

        public String toString() {
            return this.name != null ? this.name : Integer.toString(this.cnt);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof ThreadCnt) {
                ThreadCnt tc = (ThreadCnt)obj;
                return this.cnt == tc.cnt;
            }
            return super.equals(obj);
        }

        static ThreadCnt[] build() {
            ArrayList<ThreadCnt> list = new ArrayList<ThreadCnt>();
            list.add(new ThreadCnt(-1, "Adaptive"));
            list.add(new ThreadCnt(0, "Max available"));
            for (int i = 1; i <= Runtime.getRuntime().availableProcessors(); ++i) {
                list.add(new ThreadCnt(i));
            }
            return (ThreadCnt[])list.toArray(ThreadCnt[]::new);
        }

        @Generated
        public ThreadCnt(int cnt, String name) {
            this.cnt = cnt;
            this.name = name;
        }

        @Generated
        public int getCnt() {
            return this.cnt;
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }
}

