/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.basic;

import java.awt.Color;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import jrm.aui.basic.AbstractSrcDstResult;
import jrm.aui.basic.ResultColUpdater;
import jrm.aui.basic.SDRList;
import jrm.aui.basic.SrcDstResult;
import jrm.misc.Log;
import jrm.ui.basic.SDRTableModel;

public class JSDRDropTable
extends JTable
implements DropTargetListener,
ResultColUpdater {
    private final Color color;
    private transient SDRTableModel model;
    private final transient AddDelCallBack addCallBack;

    public JSDRDropTable(SDRTableModel model, AddDelCallBack callback) {
        super(model);
        int i;
        this.setCellSelectionEnabled(true);
        this.addCallBack = callback;
        this.model = model;
        for (i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            this.getColumnModel().getColumn(i).setCellRenderer(model.getCellRenderers()[i]);
        }
        for (i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            this.getColumnModel().getColumn(i).setCellEditor(model.getCellEditors()[i]);
        }
        this.color = this.getBackground();
        new DropTarget(this, this);
        this.model.addTableModelListener(e -> {
            if (e.getColumn() >= 0 && model.getColumnClass(e.getColumn()).equals(Boolean.class) && e.getType() == 0) {
                this.addCallBack.call(model.getData());
            }
        });
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                return ((SDRTableModel)JSDRDropTable.this.getModel()).getColumnTT(realIndex);
            }
        };
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        Transferable transferable = dtde.getTransferable();
        if (this.isEnabled() && transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            Point point = dtde.getLocation();
            int oldRow = this.model.getCurrentRow();
            int oldCol = this.model.getCurrentCol();
            int row = this.model.setCurrentRow(this.rowAtPoint(point));
            int col = this.model.setCurrentCol(this.columnAtPoint(point));
            if (oldCol != col || oldRow != row) {
                if (row == -1) {
                    this.model.setCurrentRow(-1);
                    this.setBackground(Color.decode("#DDFFDD"));
                    this.model.fireTableChanged(new TableModelEvent(this.model));
                } else {
                    this.setBackground(Color.white);
                    this.model.fireTableChanged(new TableModelEvent(this.model, row, row, col));
                    if (oldRow != -1) {
                        this.model.fireTableChanged(new TableModelEvent(this.model, oldRow, oldRow, oldCol));
                    }
                }
            }
            dtde.acceptDrag(1);
        } else {
            this.model.setCurrentRow(-1);
            this.setBackground(Color.decode("#FFDDDD"));
            this.model.fireTableChanged(new TableModelEvent(this.model));
            dtde.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.model.setCurrentRow(-1);
        this.setBackground(this.color);
        this.model.fireTableChanged(new TableModelEvent(this.model));
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        this.model.setCurrentRow(-1);
        this.setBackground(this.color);
        this.model.fireTableChanged(new TableModelEvent(this.model));
        try {
            Transferable transferable = dtde.getTransferable();
            if (!transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.rejectDrop();
                return;
            }
            dtde.acceptDrop(1);
            Point point = dtde.getLocation();
            int row = this.rowAtPoint(point);
            int col = this.columnAtPoint(point);
            List files = ((List)transferable.getTransferData(DataFlavor.javaFileListFlavor)).stream().filter(f -> this.dropFilter(col, (File)f)).collect(Collectors.toList());
            if (!files.isEmpty()) {
                int startSize = this.model.getData().size();
                for (int i = 0; i < files.size(); ++i) {
                    this.model.addFile((File)files.get(i), row, col, i);
                }
                if (row != -1) {
                    this.model.fireTableChanged(new TableModelEvent(this.model, row, startSize - 1, col));
                }
                if (startSize != this.model.getData().size()) {
                    this.model.fireTableChanged(new TableModelEvent(this.model, startSize, this.model.getData().size() - 1, -1, 1));
                }
                this.addCallBack.call(this.model.getData());
                dtde.getDropTargetContext().dropComplete(true);
            } else {
                dtde.getDropTargetContext().dropComplete(false);
            }
        }
        catch (UnsupportedFlavorException e) {
            dtde.rejectDrop();
        }
        catch (Exception e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            dtde.rejectDrop();
        }
    }

    private boolean dropFilter(int col, File f) {
        FileFilter filter = null;
        if (col == 1) {
            filter = this.model.getDstFilter();
        } else if (col == 0) {
            filter = this.model.getSrcFilter();
        }
        if (filter != null) {
            return filter.accept(f);
        }
        return true;
    }

    public SDRTableModel getSDRModel() {
        return this.model;
    }

    public void updateResult(int row, String result) {
        ((SrcDstResult)this.model.getData().get(row)).setResult(result);
        this.model.fireTableChanged(new TableModelEvent(this.model, row, row, 2));
        this.addCallBack.call(this.model.getData());
    }

    public void del(SDRList<SrcDstResult> sdrl) {
        for (AbstractSrcDstResult sdr : sdrl) {
            this.model.getData().remove((Object)sdr);
        }
        this.model.fireTableChanged(new TableModelEvent(this.model));
        this.addCallBack.call(this.model.getData());
    }

    public SDRList<SrcDstResult> getSelectedValuesList() {
        int[] rows = this.getSelectedRows();
        SDRList list = new SDRList();
        for (int row : rows) {
            list.add((Object)((SrcDstResult)this.model.getData().get(row)));
        }
        return list;
    }

    public void clearResults() {
        this.model.getData().forEach(r -> r.setResult(""));
        this.model.fireTableChanged(new TableModelEvent(this.model, 0, this.model.getRowCount() - 1, 2));
        this.addCallBack.call(this.model.getData());
    }

    public void call() {
        this.addCallBack.call(this.model.getData());
    }

    @FunctionalInterface
    public static interface AddDelCallBack {
        public void call(SDRList<SrcDstResult> var1);
    }
}

