/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.basic;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class JTableButton
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private transient List<TableButtonPressedHandler> handlers = new ArrayList<TableButtonPressedHandler>();
    private Map<Integer, JButton> buttons = new HashMap<Integer, JButton>();

    public void addHandler(TableButtonPressedHandler handler) {
        if (this.handlers != null) {
            this.handlers.add(handler);
        }
    }

    public void removeHandler(TableButtonPressedHandler handler) {
        if (this.handlers != null) {
            this.handlers.remove(handler);
        }
    }

    public void removeRow(int row) {
        if (this.buttons.containsKey(row)) {
            this.buttons.remove(row);
        }
    }

    public void moveRow(int oldRow, int newRow) {
        if (this.buttons.containsKey(oldRow)) {
            JButton button = this.buttons.remove(oldRow);
            this.buttons.put(newRow, button);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int column) {
        JButton button = null;
        if (this.buttons.containsKey(row)) {
            button = this.buttons.get(row);
        } else {
            button = new JButton();
            if (value instanceof String) {
                String s = (String)value;
                button.setText(s);
            }
            button.addActionListener(e -> {
                if (this.handlers != null) {
                    for (TableButtonPressedHandler handler : this.handlers) {
                        handler.onButtonPress(row, column);
                    }
                }
            });
            this.buttons.put(row, button);
        }
        return button;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int row, int column) {
        JButton button = null;
        if (this.buttons.containsKey(row)) {
            button = this.buttons.get(row);
        } else {
            button = new JButton();
            if (value instanceof String) {
                String s = (String)value;
                button.setText(s);
            }
            this.buttons.put(row, button);
        }
        return button;
    }

    public void setButtonText(int row, String text) {
        JButton button = null;
        if (this.buttons.containsKey(row)) {
            button = this.buttons.get(row);
            button.setText(text);
        }
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    public void dispose() {
        if (this.handlers != null) {
            this.handlers.clear();
        }
    }

    public static interface TableButtonPressedHandler {
        public void onButtonPress(int var1, int var2);
    }
}

