/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.batch;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import jrm.JRomManager;
import jrm.aui.basic.AbstractSrcDstResult;
import jrm.aui.basic.ResultColUpdater;
import jrm.aui.basic.SDRList;
import jrm.aui.basic.SrcDstResult;
import jrm.aui.progress.ProgressHandler;
import jrm.batch.DirUpdater;
import jrm.batch.DirUpdaterResults;
import jrm.locale.Messages;
import jrm.misc.EnumWithDefault;
import jrm.misc.Log;
import jrm.misc.ProfileSettings;
import jrm.misc.SettingsEnum;
import jrm.security.PathAbstractor;
import jrm.security.Session;
import jrm.ui.MainFrame;
import jrm.ui.basic.JFileDropList;
import jrm.ui.basic.JFileDropMode;
import jrm.ui.basic.JListHintUI;
import jrm.ui.basic.JRMFileChooser;
import jrm.ui.basic.JSDRDropTable;
import jrm.ui.basic.Popup;
import jrm.ui.basic.SDRTableModel;
import jrm.ui.batch.BatchDirUpd8rResultsDialog;
import jrm.ui.batch.BatchDirUpd8rSettingsDialog;
import jrm.ui.batch.BatchTableModel;
import jrm.ui.progress.SwingWorkerProgress;
import one.util.streamex.StreamEx;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class BatchDirUpd8rPanel
extends JPanel {
    private JFileDropList listBatchToolsDat2DirSrc;
    private JSDRDropTable tableBatchToolsDat2Dir;
    private JMenu mnDat2DirPresets;
    private Point popupPoint;

    public BatchDirUpd8rPanel(Session session) {
        GridBagLayout gblPanelBatchToolsDat2Dir = new GridBagLayout();
        gblPanelBatchToolsDat2Dir.columnWidths = new int[]{0, 0, 0, 0};
        gblPanelBatchToolsDat2Dir.rowHeights = new int[]{0, 0, 0};
        gblPanelBatchToolsDat2Dir.columnWeights = new double[]{1.0, 0.0, 0.0, Double.MIN_VALUE};
        gblPanelBatchToolsDat2Dir.rowWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gblPanelBatchToolsDat2Dir);
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.3);
        splitPane.setOrientation(0);
        GridBagConstraints gbcSplitPane = new GridBagConstraints();
        gbcSplitPane.gridwidth = 3;
        gbcSplitPane.insets = new Insets(0, 0, 5, 0);
        gbcSplitPane.fill = 1;
        gbcSplitPane.gridx = 0;
        gbcSplitPane.gridy = 0;
        this.add((Component)splitPane, gbcSplitPane);
        JScrollPane scrollPaneLeft = new JScrollPane();
        splitPane.setLeftComponent(scrollPaneLeft);
        scrollPaneLeft.setBorder(new TitledBorder(null, Messages.getString((String)"MainFrame.SrcDirs"), 4, 2, null, null));
        this.listBatchToolsDat2DirSrc = new JFileDropList(files -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.dat2dir_srcdirs, String.join((CharSequence)"|", files.stream().map(File::getAbsolutePath).toList())));
        this.listBatchToolsDat2DirSrc.setMode(JFileDropMode.DIRECTORY);
        this.listBatchToolsDat2DirSrc.setUI(new JListHintUI(Messages.getString((String)"MainFrame.DropDirHint"), Color.gray));
        this.listBatchToolsDat2DirSrc.setToolTipText(Messages.getString((String)"MainFrame.listBatchToolsDat2DirSrc.toolTipText"));
        scrollPaneLeft.setViewportView(this.listBatchToolsDat2DirSrc);
        JPopupMenu popupMenuSrc = new JPopupMenu();
        Popup.addPopup(this.listBatchToolsDat2DirSrc, popupMenuSrc);
        JMenuItem mnDat2DirAddSrcDir = new JMenuItem(Messages.getString((String)"MainFrame.AddSrcDir"));
        mnDat2DirAddSrcDir.addActionListener(e -> this.addSrcDir());
        popupMenuSrc.add(mnDat2DirAddSrcDir);
        JMenuItem mnDat2DirDelSrcDir = new JMenuItem(Messages.getString((String)"MainFrame.DelSrcDir"));
        mnDat2DirDelSrcDir.addActionListener(e -> this.listBatchToolsDat2DirSrc.del(this.listBatchToolsDat2DirSrc.getSelectedValuesList()));
        popupMenuSrc.add(mnDat2DirDelSrcDir);
        JScrollPane scrollPaneRight = new JScrollPane();
        splitPane.setRightComponent(scrollPaneRight);
        BatchTableModel model = new BatchTableModel();
        this.tableBatchToolsDat2Dir = new JSDRDropTable(model, files -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.dat2dir_sdr, AbstractSrcDstResult.toJSON((List)files)));
        model.setButtonHandler((row, column) -> this.showResult(session, model, row));
        if (session != null) {
            this.tableBatchToolsDat2Dir.getSDRModel().setData((SDRList<SrcDstResult>)SrcDstResult.fromJSON((String)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dat2dir_sdr)));
        }
        this.tableBatchToolsDat2Dir.setCellSelectionEnabled(false);
        this.tableBatchToolsDat2Dir.setRowSelectionAllowed(true);
        this.tableBatchToolsDat2Dir.getSDRModel().setSrcFilter(this::srcFilter);
        this.tableBatchToolsDat2Dir.getSDRModel().setDstFilter(File::isDirectory);
        this.tableBatchToolsDat2Dir.setSelectionMode(2);
        this.tableBatchToolsDat2Dir.setFillsViewportHeight(true);
        ((BatchTableModel)this.tableBatchToolsDat2Dir.getModel()).applyColumnsWidths(this.tableBatchToolsDat2Dir);
        scrollPaneRight.setViewportView(this.tableBatchToolsDat2Dir);
        this.tableBatchToolsDat2Dir.addMouseListener(new Dir2DatMouseAdapter(session));
        JPopupMenu popupMenu = new JPopupMenu();
        Popup.addPopup(this.tableBatchToolsDat2Dir, popupMenu);
        final JMenuItem mnDat2DirAddDat = new JMenuItem(Messages.getString((String)"MainFrame.AddDat"));
        mnDat2DirAddDat.addActionListener(e -> this.addDat());
        popupMenu.add(mnDat2DirAddDat);
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                BatchDirUpd8rPanel.this.mnDat2DirPresets.setEnabled(BatchDirUpd8rPanel.this.tableBatchToolsDat2Dir.getSelectedRowCount() > 0);
                mnDat2DirAddDat.setEnabled(BatchDirUpd8rPanel.this.tableBatchToolsDat2Dir.columnAtPoint(BatchDirUpd8rPanel.this.popupPoint) <= 1);
            }
        });
        JMenuItem mnDat2DirDelDat = new JMenuItem(Messages.getString((String)"MainFrame.DelDat"));
        mnDat2DirDelDat.addActionListener(e -> this.tableBatchToolsDat2Dir.del(this.tableBatchToolsDat2Dir.getSelectedValuesList()));
        popupMenu.add(mnDat2DirDelDat);
        this.mnDat2DirPresets = new JMenu(Messages.getString((String)"MainFrame.Presets"));
        popupMenu.add(this.mnDat2DirPresets);
        JMenu mnDat2DirD2D = new JMenu(Messages.getString((String)"MainFrame.Dir2DatMenu"));
        this.mnDat2DirPresets.add(mnDat2DirD2D);
        JMenuItem mntmDat2DirD2DTzip = new JMenuItem(Messages.getString((String)"MainFrame.TZIP"));
        mntmDat2DirD2DTzip.addActionListener(e -> {
            for (AbstractSrcDstResult sdr : this.tableBatchToolsDat2Dir.getSelectedValuesList()) {
                ProfileSettings.TZIP((Session)session, (File)PathAbstractor.getAbsolutePath((Session)session, (String)sdr.getSrc()).toFile());
            }
        });
        mnDat2DirD2D.add(mntmDat2DirD2DTzip);
        JMenuItem mntmDat2DirD2DDir = new JMenuItem(Messages.getString((String)"MainFrame.DIR"));
        mntmDat2DirD2DDir.addActionListener(e -> {
            for (AbstractSrcDstResult sdr : this.tableBatchToolsDat2Dir.getSelectedValuesList()) {
                ProfileSettings.DIR((Session)session, (File)PathAbstractor.getAbsolutePath((Session)session, (String)sdr.getSrc()).toFile());
            }
        });
        mnDat2DirD2D.add(mntmDat2DirD2DDir);
        JMenuItem mntmCustom = new JMenuItem(Messages.getString((String)"BatchToolsDirUpd8rPanel.mntmCustom.text"));
        mntmCustom.addActionListener(e -> this.customPreset(session));
        this.mnDat2DirPresets.add(mntmCustom);
        if (session != null) {
            for (String s : StringUtils.split((String)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dat2dir_srcdirs), (char)'|')) {
                if (s.isEmpty()) continue;
                ((DefaultListModel)this.listBatchToolsDat2DirSrc.getModel()).addElement(new File(s));
            }
        }
        JCheckBox cbBatchToolsDat2DirDryRun = new JCheckBox(Messages.getString((String)"MainFrame.cbBatchToolsDat2DirDryRun.text"));
        if (session != null) {
            cbBatchToolsDat2DirDryRun.setSelected((Boolean)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dat2dir_dry_run, Boolean.class));
        }
        cbBatchToolsDat2DirDryRun.addItemListener(e -> session.getUser().getSettings().setProperty((Enum)SettingsEnum.dat2dir_dry_run, e.getStateChange() == 1));
        JButton btnBatchToolsDir2DatStart = new JButton(Messages.getString((String)"MainFrame.btnStart.text"));
        btnBatchToolsDir2DatStart.setIcon(MainFrame.getIcon("/jrm/resicons/icons/bullet_go.png"));
        btnBatchToolsDir2DatStart.addActionListener(e -> this.dat2dir(session, cbBatchToolsDat2DirDryRun.isSelected()));
        GridBagConstraints gbcCBBatchToolsDat2DirDryRun = new GridBagConstraints();
        gbcCBBatchToolsDat2DirDryRun.insets = new Insets(0, 0, 0, 5);
        gbcCBBatchToolsDat2DirDryRun.gridx = 1;
        gbcCBBatchToolsDat2DirDryRun.gridy = 1;
        this.add((Component)cbBatchToolsDat2DirDryRun, gbcCBBatchToolsDat2DirDryRun);
        GridBagConstraints gbcBtnBatchToolsDir2DatStart = new GridBagConstraints();
        gbcBtnBatchToolsDir2DatStart.fill = 2;
        gbcBtnBatchToolsDir2DatStart.gridx = 2;
        gbcBtnBatchToolsDir2DatStart.gridy = 1;
        this.add((Component)btnBatchToolsDir2DatStart, gbcBtnBatchToolsDir2DatStart);
    }

    private void customPreset(Session session) throws SecurityException {
        SDRList<SrcDstResult> list = this.tableBatchToolsDat2Dir.getSelectedValuesList();
        if (!list.isEmpty()) {
            BatchDirUpd8rSettingsDialog dialog = new BatchDirUpd8rSettingsDialog(SwingUtilities.getWindowAncestor(this));
            AbstractSrcDstResult entry = (AbstractSrcDstResult)list.get(0);
            dialog.settingsPanel.initProfileSettings(session.getUser().getSettings().loadProfileSettings(PathAbstractor.getAbsolutePath((Session)session, (String)entry.getSrc()).toFile(), null));
            dialog.setVisible(true);
            if (dialog.isSuccess()) {
                for (AbstractSrcDstResult sdr : list) {
                    session.getUser().getSettings().saveProfileSettings(PathAbstractor.getAbsolutePath((Session)session, (String)sdr.getSrc()).toFile(), dialog.settingsPanel.getSettings());
                }
            }
        }
    }

    private void addDat() {
        int mode;
        int col = this.tableBatchToolsDat2Dir.columnAtPoint(this.popupPoint);
        int row = this.tableBatchToolsDat2Dir.rowAtPoint(this.popupPoint);
        SDRList<SrcDstResult> list = this.tableBatchToolsDat2Dir.getSelectedValuesList();
        int type = col == 0 ? 0 : 1;
        int n = mode = col == 0 ? 2 : 1;
        File currdir = !list.isEmpty() ? (File)Optional.ofNullable(col == 0 ? ((SrcDstResult)list.get(0)).getSrc() : ((SrcDstResult)list.get(0)).getDst()).map(f -> new File((String)f).getParentFile()).orElse(null) : null;
        List<javax.swing.filechooser.FileFilter> filters = Collections.singletonList(new Dir2DatFileFilter(col));
        String title = col == 0 ? "Choose XML/DAT files or the parent directory in case of software lists" : "Choose destination directories";
        JRMFileChooser<Void> fchooser = new JRMFileChooser<Void>(type, mode, currdir, null, filters, title, true);
        fchooser.show(SwingUtilities.windowForComponent(this), chooser -> this.chosen(col, row, chooser));
    }

    private Void chosen(int col, int row, JRMFileChooser<Void> chooser) {
        File[] files = chooser.getSelectedFiles();
        if (files.length <= 0) {
            return null;
        }
        SDRTableModel sdrmodel = this.tableBatchToolsDat2Dir.getSDRModel();
        int startSize = sdrmodel.getData().size();
        FileFilter filter = col == 0 ? sdrmodel.getSrcFilter() : sdrmodel.getDstFilter();
        for (int i = 0; i < files.length; ++i) {
            SrcDstResult line;
            File file = files[i];
            if (!filter.accept(file)) continue;
            if (row == -1 || row + i >= sdrmodel.getData().size()) {
                line = new SrcDstResult();
                sdrmodel.getData().add((Object)line);
            } else {
                line = (SrcDstResult)sdrmodel.getData().get(row + i);
            }
            if (col == 1) {
                line.setDst(file.getPath());
                continue;
            }
            line.setSrc(file.getPath());
        }
        this.chosenTablechanged(col, row, sdrmodel, startSize);
        this.tableBatchToolsDat2Dir.call();
        return null;
    }

    private void chosenTablechanged(int col, int row, SDRTableModel sdrmodel, int startSize) {
        if (row != -1) {
            sdrmodel.fireTableChanged(new TableModelEvent(sdrmodel, row, startSize - 1, col));
        }
        if (startSize != sdrmodel.getData().size()) {
            sdrmodel.fireTableChanged(new TableModelEvent(sdrmodel, startSize, sdrmodel.getData().size() - 1, -1, 1));
        }
    }

    private boolean srcFilter(File file) throws IllegalArgumentException {
        List<String> exts = Arrays.asList("xml", "dat");
        if (file.isFile()) {
            return exts.contains(FilenameUtils.getExtension((String)file.getName()));
        }
        if (file.isDirectory()) {
            return file.listFiles(f -> f.isFile() && exts.contains(FilenameUtils.getExtension((String)f.getName()))).length > 0;
        }
        return false;
    }

    private void showResult(final Session session, SDRTableModel model, int row) {
        final AbstractSrcDstResult sdr = (AbstractSrcDstResult)model.getData().get(row);
        new SwingWorkerProgress<DirUpdaterResults, Void>(SwingUtilities.getWindowAncestor(this)){

            @Override
            protected DirUpdaterResults doInBackground() throws Exception {
                this.setProgress("Loading...");
                return DirUpdaterResults.load((Session)session, (File)new File(sdr.getSrc()), (ProgressHandler)this);
            }

            @Override
            protected void done() {
                this.close();
                try {
                    new BatchDirUpd8rResultsDialog(session, SwingUtilities.getWindowAncestor(BatchDirUpd8rPanel.this), (DirUpdaterResults)this.get());
                }
                catch (InterruptedException e) {
                    Log.err((String)e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    Log.err((String)e.getMessage(), (Throwable)e);
                }
            }
        }.execute();
    }

    private void addSrcDir() {
        List list = this.listBatchToolsDat2DirSrc.getSelectedValuesList();
        new JRMFileChooser<Void>(0, 1, !list.isEmpty() ? ((File)list.get(0)).getParentFile() : null, null, null, "Choose source directories", true).show(SwingUtilities.windowForComponent(this), chooser -> {
            File[] files = chooser.getSelectedFiles();
            if (files.length > 0) {
                this.listBatchToolsDat2DirSrc.add(files);
            }
            return null;
        });
    }

    private void dat2dir(final Session session, final boolean dryrun) {
        if (((DefaultListModel)this.listBatchToolsDat2DirSrc.getModel()).getSize() > 0) {
            final SDRList<SrcDstResult> sdrl = ((SDRTableModel)this.tableBatchToolsDat2Dir.getModel()).getData();
            if (sdrl.stream().filter(sdr -> !session.getUser().getSettings().getProfileSettingsFile(PathAbstractor.getAbsolutePath((Session)session, (String)sdr.getSrc()).toFile()).exists()).count() > 0L) {
                JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), Messages.getString((String)"MainFrame.AllDatsPresetsAssigned"));
            } else {
                new SwingWorkerProgress<DirUpdater, Void>(SwingUtilities.getWindowAncestor(this)){

                    @Override
                    protected DirUpdater doInBackground() throws Exception {
                        return new DirUpdater(session, (List)sdrl, (ProgressHandler)this, StreamEx.of(((DefaultListModel)BatchDirUpd8rPanel.this.listBatchToolsDat2DirSrc.getModel()).elements()).map(f -> PathAbstractor.getAbsolutePath((Session)session, (String)f.toString()).toFile()).toList(), (ResultColUpdater)BatchDirUpd8rPanel.this.tableBatchToolsDat2Dir, dryrun);
                    }

                    @Override
                    protected void done() {
                        this.close();
                        session.setCurrProfile(null);
                        session.setCurrScan(null);
                        session.getReport().setProfile(session.getCurrProfile());
                        if (MainFrame.getProfileViewer() != null) {
                            MainFrame.getProfileViewer().dispose();
                            MainFrame.setProfileViewer(null);
                        }
                        if (MainFrame.getReportFrame() != null) {
                            MainFrame.getReportFrame().setVisible(false);
                        }
                        JRomManager.getMainFrame().getMainPane().setEnabledAt(1, false);
                    }
                }.execute();
            }
        } else {
            JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this), Messages.getString((String)"MainFrame.AtLeastOneSrcDir"));
        }
    }

    private final class Dir2DatMouseAdapter
    extends MouseAdapter {
        private final Session session;

        private Dir2DatMouseAdapter(Session session) {
            this.session = session;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTable target;
            int row;
            if (e.getClickCount() == 2 && (row = (target = (JTable)e.getSource()).getSelectedRow()) >= 0) {
                BatchDirUpd8rPanel.this.showResult(this.session, BatchDirUpd8rPanel.this.tableBatchToolsDat2Dir.getSDRModel(), row);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                BatchDirUpd8rPanel.this.popupPoint = e.getPoint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                BatchDirUpd8rPanel.this.popupPoint = e.getPoint();
            }
        }
    }

    private final class Dir2DatFileFilter
    extends javax.swing.filechooser.FileFilter {
        private final int col;

        private Dir2DatFileFilter(int col) {
            this.col = col;
        }

        @Override
        public boolean accept(File f) {
            FileFilter filter = null;
            if (this.col == 1) {
                filter = BatchDirUpd8rPanel.this.tableBatchToolsDat2Dir.getSDRModel().getDstFilter();
            } else if (this.col == 0) {
                filter = file -> {
                    List<String> exts = Arrays.asList("xml", "dat");
                    if (file.isFile()) {
                        return exts.contains(FilenameUtils.getExtension((String)file.getName()));
                    }
                    return true;
                };
            }
            if (filter != null) {
                return filter.accept(f);
            }
            return true;
        }

        @Override
        public String getDescription() {
            return this.col == 0 ? "Dat/XML files or directories of Dat/XML files" : "Destination directories";
        }
    }
}

