/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.batch;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jrm.batch.DirUpdaterResults;
import jrm.security.Session;
import jrm.ui.basic.EnhTableModel;
import jrm.ui.basic.JTableButton;
import jrm.ui.profile.report.ReportLite;

public class BatchDirUpdResultsView
extends JScrollPane {
    private JTable table = new JTable();

    public BatchDirUpdResultsView(Session session, DirUpdaterResults results) {
        int i;
        this.setViewportView(this.table);
        this.setPreferredSize(new Dimension(700, 400));
        BatchDirUpdResultsViewModel model = new BatchDirUpdResultsViewModel(results, session);
        this.table.setModel(model);
        for (i = 0; i < this.table.getColumnModel().getColumnCount(); ++i) {
            this.table.getColumnModel().getColumn(i).setCellRenderer(model.getCellRenderers()[i]);
        }
        for (i = 0; i < this.table.getColumnModel().getColumnCount(); ++i) {
            this.table.getColumnModel().getColumn(i).setCellEditor(model.getCellEditors()[i]);
        }
        model.applyColumnsWidths(this.table);
    }

    private final class BatchDirUpdResultsViewModel
    implements EnhTableModel {
        private final DirUpdaterResults results;
        private JTableButton buttons = new JTableButton();
        private final String[] headers = new String[]{"DAT/XML", "Have", "Create", "Fix", "Miss", "Total", "Report"};
        private final Class<?>[] types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class};
        private final int[] widths = new int[]{400, 40, 40, 40, 40, 40, -70};
        final TableCellRenderer[] renderers = new TableCellRenderer[]{null, new ColorRenderer(new Color(0, 180, 0)), new ColorRenderer(new Color(0, 0, 180)), new ColorRenderer(new Color(127, 0, 180)), new ColorRenderer(new Color(180, 0, 0)), null, this.buttons};
        final TableCellEditor[] editors = new TableCellEditor[]{null, null, null, null, null, null, this.buttons};

        private BatchDirUpdResultsViewModel(DirUpdaterResults results, Session session) {
            this.results = results;
            this.buttons.addHandler((row, column) -> new ReportLite(session, SwingUtilities.getWindowAncestor(BatchDirUpdResultsView.this), ((DirUpdaterResults.DirUpdaterResult)results.getResults().get(row)).getDat()));
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 6;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.results != null) {
                DirUpdaterResults.DirUpdaterResult result = (DirUpdaterResults.DirUpdaterResult)this.results.getResults().get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return result.getDat().toString();
                    }
                    case 1: {
                        return result.getStats().getSetFoundOk();
                    }
                    case 2: {
                        return result.getStats().getSetCreateComplete();
                    }
                    case 3: {
                        return result.getStats().getSetFoundFixComplete();
                    }
                    case 4: {
                        return result.getStats().getSetCreate() + result.getStats().getSetFound() + result.getStats().getSetMissing() - (result.getStats().getSetCreateComplete() + result.getStats().getSetFoundFixComplete() + result.getStats().getSetFoundOk());
                    }
                    case 5: {
                        return result.getStats().getSetCreate() + result.getStats().getSetFound() + result.getStats().getSetMissing();
                    }
                    case 6: {
                        return "Report";
                    }
                }
                return null;
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.results != null ? this.results.getResults().size() : 0;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.headers[columnIndex];
        }

        @Override
        public int getColumnCount() {
            return this.headers.length;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.types[columnIndex];
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public TableCellRenderer[] getCellRenderers() {
            return this.renderers;
        }

        @Override
        public TableCellEditor[] getCellEditors() {
            return this.editors;
        }

        @Override
        public int getColumnWidth(int columnIndex) {
            return this.widths[columnIndex];
        }

        @Override
        public String getColumnTT(int columnIndex) {
            return this.headers[columnIndex];
        }
    }

    private static class ColorRenderer
    extends DefaultTableCellRenderer {
        private Color color;

        public ColorRenderer(Color color) {
            this.color = color;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setForeground(this.color);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

