/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.data;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jrm.locale.Messages;
import jrm.profile.data.MachineList;
import jrm.profile.data.SoftwareList;
import jrm.ui.MainFrame;
import jrm.ui.basic.CenteredTableCellRenderer;

public final class AnywareListListRenderer {
    protected static final String[] columns = new String[]{Messages.getString((String)"SoftwareListListRenderer.Name"), Messages.getString((String)"SoftwareListListRenderer.Description"), Messages.getString((String)"SoftwareListListRenderer.Have")};
    protected static final Class<?>[] columnsTypes = new Class[]{Object.class, String.class, String.class};
    protected static final int[] columnsWidths = new int[]{70, 150, -80};
    protected static final TableCellRenderer[] columnsRenderers = new TableCellRenderer[]{new DefaultTableCellRenderer(){
        final ImageIcon diskMultipleGreen = MainFrame.getIcon("/jrm/resicons/disk_multiple_green.png");
        final ImageIcon diskMultipleOrange = MainFrame.getIcon("/jrm/resicons/disk_multiple_orange.png");
        final ImageIcon diskMultipleRed = MainFrame.getIcon("/jrm/resicons/disk_multiple_red.png");
        final ImageIcon diskMultipleGray = MainFrame.getIcon("/jrm/resicons/disk_multiple_gray.png");

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof SoftwareList) {
                SoftwareList sl = (SoftwareList)value;
                super.getTableCellRendererComponent(table, sl.getBaseName(), isSelected, hasFocus, row, column);
                switch (sl.getStatus()) {
                    case COMPLETE: {
                        this.setIcon(this.diskMultipleGreen);
                        break;
                    }
                    case MISSING: {
                        this.setIcon(this.diskMultipleRed);
                        break;
                    }
                    case PARTIAL: {
                        this.setIcon(this.diskMultipleOrange);
                        break;
                    }
                    default: {
                        this.setIcon(this.diskMultipleGray);
                    }
                }
                return this;
            }
            if (value instanceof MachineList) {
                MachineList ml = (MachineList)value;
                super.getTableCellRendererComponent(table, Messages.getString((String)"MachineListListRenderer.*"), isSelected, hasFocus, row, column);
                switch (ml.getStatus()) {
                    case COMPLETE: {
                        this.setIcon(this.diskMultipleGreen);
                        break;
                    }
                    case MISSING: {
                        this.setIcon(this.diskMultipleRed);
                        break;
                    }
                    case PARTIAL: {
                        this.setIcon(this.diskMultipleOrange);
                        break;
                    }
                    default: {
                        this.setIcon(this.diskMultipleGray);
                    }
                }
                return this;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }, new DefaultTableCellRenderer(), new CenteredTableCellRenderer()};

    private AnywareListListRenderer() {
    }
}

