/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.data;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jrm.locale.Messages;
import jrm.profile.data.Anyware;
import jrm.profile.data.AnywareStatus;
import jrm.profile.data.Machine;
import jrm.profile.data.Samples;
import jrm.ui.MainFrame;
import jrm.ui.basic.CenteredTableCellRenderer;

public final class MachineListRenderer {
    private static final ImageIcon folder_closed_green = MainFrame.getIcon("/jrm/resicons/folder_closed_green.png");
    private static final ImageIcon folder_closed_orange = MainFrame.getIcon("/jrm/resicons/folder_closed_orange.png");
    private static final ImageIcon folder_closed_red = MainFrame.getIcon("/jrm/resicons/folder_closed_red.png");
    private static final ImageIcon folder_closed_gray = MainFrame.getIcon("/jrm/resicons/folder_closed_gray.png");
    protected static final String[] columns = new String[]{Messages.getString((String)"MachineListRenderer.Status"), Messages.getString((String)"MachineListRenderer.Name"), Messages.getString((String)"MachineListRenderer.Description"), Messages.getString((String)"MachineListRenderer.Have"), Messages.getString((String)"MachineListRenderer.CloneOf"), Messages.getString((String)"MachineListRenderer.RomOf"), Messages.getString((String)"MachineListRenderer.SampleOf"), Messages.getString((String)"MachineListRenderer.Selected")};
    protected static final Class<?>[] columnsTypes = new Class[]{Object.class, Object.class, String.class, String.class, Object.class, Object.class, String.class, Boolean.class};
    protected static final int[] columnsWidths = new int[]{-20, 40, 200, -45, 40, 40, 40, -20};
    protected static final TableCellRenderer[] columnsRenderers = new TableCellRenderer[]{new AnywareCellRenderer(), new MachineCellRenderer(), new ToolTipCellRenderer(), new CenteredTableCellRenderer(), new AnywareCellRenderer(), new AnywareCellRenderer(), new SamplesCellRenderer(), null};

    private MachineListRenderer() {
    }

    private static final class AnywareCellRenderer
    extends StatusCellRenderer {
        private AnywareCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Anyware) {
                Anyware a = (Anyware)value;
                super.getTableCellRendererComponent(table, a.getBaseName(), isSelected, hasFocus, row, column);
                this.setIcon(a.getStatus());
                return this;
            }
            this.setIcon((Icon)null);
            if (value != null) {
                this.setIcon(folder_closed_gray);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private static final class MachineCellRenderer
    extends DefaultTableCellRenderer {
        final ImageIcon applicationOSXTerminal = MainFrame.getIcon("/jrm/resicons/icons/application_osx_terminal.png");
        final ImageIcon computer = MainFrame.getIcon("/jrm/resicons/icons/computer.png");
        final ImageIcon wrench = MainFrame.getIcon("/jrm/resicons/icons/wrench.png");
        final ImageIcon joystick = MainFrame.getIcon("/jrm/resicons/icons/joystick.png");

        private MachineCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Machine) {
                Machine m = (Machine)value;
                super.getTableCellRendererComponent(table, m.getBaseName(), isSelected, hasFocus, row, column);
                if (m.isIsbios()) {
                    this.setIcon(this.applicationOSXTerminal);
                } else if (m.isIsdevice()) {
                    this.setIcon(this.computer);
                } else if (m.isIsmechanical()) {
                    this.setIcon(this.wrench);
                } else {
                    this.setIcon(this.joystick);
                }
                this.setText(m.getBaseName());
                return this;
            }
            this.setIcon(null);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private static final class ToolTipCellRenderer
    extends DefaultTableCellRenderer {
        private ToolTipCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setToolTipText(this.getText());
            return this;
        }
    }

    private static final class SamplesCellRenderer
    extends StatusCellRenderer {
        private SamplesCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Samples) {
                Samples s = (Samples)value;
                super.getTableCellRendererComponent(table, s.getBaseName(), isSelected, hasFocus, row, column);
                this.setIcon(s.getStatus());
                return this;
            }
            this.setIcon((Icon)null);
            if (value != null) {
                this.setIcon(folder_closed_gray);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private static abstract class StatusCellRenderer
    extends DefaultTableCellRenderer {
        private StatusCellRenderer() {
        }

        protected void setIcon(AnywareStatus status) {
            switch (status) {
                case COMPLETE: {
                    this.setIcon(folder_closed_green);
                    break;
                }
                case PARTIAL: {
                    this.setIcon(folder_closed_orange);
                    break;
                }
                case MISSING: {
                    this.setIcon(folder_closed_red);
                    break;
                }
                default: {
                    this.setIcon(folder_closed_gray);
                }
            }
        }
    }
}

