/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.data;

import java.util.Set;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import jrm.profile.data.AnywareStatus;
import jrm.profile.data.Software;
import jrm.profile.data.SoftwareList;
import jrm.ui.profile.data.AnywareListModel;
import jrm.ui.profile.data.SoftwareListRenderer;

public class SoftwareListModel
extends AnywareListModel<Software> {
    private SoftwareList softwareList;

    public SoftwareListModel(SoftwareList softwareList) {
        this.softwareList = softwareList;
    }

    @Override
    public TableCellRenderer[] getCellRenderers() {
        return SoftwareListRenderer.columnsRenderers;
    }

    @Override
    public int getColumnWidth(int columnIndex) {
        return SoftwareListRenderer.columnsWidths[columnIndex];
    }

    @Override
    public String getColumnTT(int columnIndex) {
        return SoftwareListRenderer.columns[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.softwareList.getFilteredList().size();
    }

    @Override
    public int getColumnCount() {
        return SoftwareListRenderer.columns.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return SoftwareListRenderer.columns[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return SoftwareListRenderer.columnsTypes[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 5;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Software software = (Software)this.softwareList.getFilteredList().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return software;
            }
            case 1: {
                return software;
            }
            case 2: {
                return software.description.toString();
            }
            case 3: {
                return String.format("%d/%d", software.countHave(), software.getRoms().size() + software.getDisks().size());
            }
            case 4: {
                return software.getCloneof() != null ? this.softwareList.getByName(software.getCloneof()) : null;
            }
            case 5: {
                return software.isSelected();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 5 && aValue instanceof Boolean) {
            Boolean b = (Boolean)aValue;
            Software software = (Software)this.softwareList.getFilteredList().get(rowIndex);
            software.setSelected(b.booleanValue());
        }
    }

    @Override
    public void reset() {
        this.softwareList.resetCache();
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public TableCellRenderer getColumnRenderer(int columnIndex) {
        return SoftwareListRenderer.columnsRenderers[columnIndex];
    }

    public SoftwareList getList() {
        return this.softwareList;
    }

    @Override
    public void setFilter(Set<AnywareStatus> filter) {
        this.softwareList.setFilterCache(filter);
        this.reset();
    }
}

