/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.filter;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.tree.TreeNode;
import jrm.profile.filter.CatVer;
import jrm.ui.basic.AbstractNGTreeNode;

public class CatVerNode
extends AbstractNGTreeNode {
    private final CatVer catver;
    private final Map<String, CategoryNode> categoryNodeCache = new HashMap<String, CategoryNode>();

    public CatVerNode(CatVer catver) {
        this.catver = catver;
    }

    public CategoryNode getNode(CatVer.Category cat) {
        return this.categoryNodeCache.computeIfAbsent(cat.getPropertyName(), pptname -> new CategoryNode(cat));
    }

    @Override
    public Object getUserObject() {
        return this.catver.getUserObject();
    }

    @Override
    public boolean isSelected() {
        return this.catver.isSelected();
    }

    @Override
    public void setSelected(boolean selected) {
        this.catver.setSelected(selected);
    }

    @Override
    public CategoryNode getChildAt(int childIndex) {
        return this.getNode((CatVer.Category)this.catver.getListCategories().get(childIndex));
    }

    @Override
    public int getChildCount() {
        return this.catver.getListCategories().size();
    }

    @Override
    public TreeNode getParent() {
        return null;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.catver.getListCategories().indexOf(((CategoryNode)node).category);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.catver.getListCategories().isEmpty();
    }

    public Enumeration<CategoryNode> children() {
        return new Enumeration<CategoryNode>(){
            private Iterator<CatVer.Category> iterator;
            {
                this.iterator = CatVerNode.this.catver.getListCategories().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public CategoryNode nextElement() {
                return CatVerNode.this.getNode(this.iterator.next());
            }
        };
    }

    public final class CategoryNode
    extends AbstractNGTreeNode {
        private final CatVer.Category category;
        private final Map<String, SubCategoryNode> subcategoryNodeCache = new HashMap<String, SubCategoryNode>();

        public CategoryNode(CatVer.Category category) {
            this.category = category;
        }

        public SubCategoryNode getNode(CatVer.Category.SubCategory subcat) {
            return this.subcategoryNodeCache.computeIfAbsent(subcat.getPropertyName(), pptname -> new SubCategoryNode(subcat));
        }

        @Override
        public Object getUserObject() {
            return this.category.getUserObject();
        }

        @Override
        public boolean isSelected() {
            return this.category.isSelected();
        }

        @Override
        public void setSelected(boolean selected) {
            this.category.setSelected(selected);
        }

        @Override
        public SubCategoryNode getChildAt(int childIndex) {
            return this.getNode((CatVer.Category.SubCategory)this.category.getListSubCategories().get(childIndex));
        }

        @Override
        public int getChildCount() {
            return this.category.getListSubCategories().size();
        }

        @Override
        public CatVerNode getParent() {
            return CatVerNode.this;
        }

        @Override
        public int getIndex(TreeNode node) {
            return this.category.getListSubCategories().indexOf(((SubCategoryNode)node).subcategory);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return this.category.getListSubCategories().isEmpty();
        }

        public Enumeration<SubCategoryNode> children() {
            return new Enumeration<SubCategoryNode>(){
                private Iterator<CatVer.Category.SubCategory> iterator;
                {
                    this.iterator = CategoryNode.this.category.getListSubCategories().iterator();
                }

                @Override
                public SubCategoryNode nextElement() {
                    return CategoryNode.this.getNode(this.iterator.next());
                }

                @Override
                public boolean hasMoreElements() {
                    return this.iterator.hasNext();
                }
            };
        }

        public final class SubCategoryNode
        extends AbstractNGTreeNode {
            private final CatVer.Category.SubCategory subcategory;

            public SubCategoryNode(CatVer.Category.SubCategory subcategory) {
                this.subcategory = subcategory;
            }

            @Override
            public Object getUserObject() {
                return this.subcategory.getUserObject();
            }

            @Override
            public boolean isSelected() {
                return this.subcategory.isSelected();
            }

            @Override
            public void setSelected(boolean selected) {
                this.subcategory.setSelected(selected);
            }

            @Override
            public CategoryNode getParent() {
                return CategoryNode.this;
            }
        }
    }
}

