/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.report;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.tree.TreeNode;
import jrm.profile.report.Note;
import jrm.profile.report.Report;
import jrm.profile.report.Subject;
import jrm.ui.basic.AbstractNGTreeNode;
import jrm.ui.profile.report.ReportNodeGeneric;
import lombok.Generated;

public class ReportNode
extends ReportNodeGeneric<Report> {
    private final Map<Integer, SubjectNode> subjectNodeCache = new HashMap<Integer, SubjectNode>();

    public ReportNode(Report report) {
        super(report);
    }

    public SubjectNode getNode(Subject subject) {
        return this.subjectNodeCache.computeIfAbsent(subject.getId(), id -> new SubjectNode(subject));
    }

    @Override
    public SubjectNode getChildAt(int childIndex) {
        return this.getNode((Subject)((Report)this.report).getSubjects().get(childIndex));
    }

    @Override
    public int getChildCount() {
        return ((Report)this.report).getSubjects().size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return ((Report)this.report).getSubjects().indexOf(((SubjectNode)node).subject);
    }

    @Override
    public boolean isLeaf() {
        return ((Report)this.report).getSubjects().isEmpty();
    }

    public Enumeration<SubjectNode> children() {
        return new Enumeration<SubjectNode>(){
            private Iterator<Subject> iterator;
            {
                this.iterator = ((Report)ReportNode.this.report).getSubjects().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public SubjectNode nextElement() {
                return ReportNode.this.getNode(this.iterator.next());
            }
        };
    }

    public final class SubjectNode
    implements TreeNode {
        private final Subject subject;
        private final Map<Integer, NoteNode> noteNodeCache = new HashMap<Integer, NoteNode>();

        public SubjectNode(Subject subject) {
            this.subject = subject;
        }

        public NoteNode getNode(Note note) {
            return this.noteNodeCache.computeIfAbsent(note.getId(), id -> new NoteNode(note));
        }

        @Override
        public NoteNode getChildAt(int childIndex) {
            return this.getNode((Note)this.subject.getNotes().get(childIndex));
        }

        @Override
        public int getChildCount() {
            return this.subject.getNotes().size();
        }

        @Override
        public TreeNode getParent() {
            return ReportNode.this;
        }

        @Override
        public int getIndex(TreeNode node) {
            return this.subject.getNotes().indexOf(((NoteNode)node).note);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return this.subject.getNotes().isEmpty();
        }

        public Enumeration<NoteNode> children() {
            return new Enumeration<NoteNode>(){
                private Iterator<Note> iterator;
                {
                    this.iterator = SubjectNode.this.subject.getNotes().iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.iterator.hasNext();
                }

                @Override
                public NoteNode nextElement() {
                    return SubjectNode.this.getNode(this.iterator.next());
                }
            };
        }

        @Generated
        public Subject getSubject() {
            return this.subject;
        }

        public final class NoteNode
        extends AbstractNGTreeNode {
            private final Note note;

            public NoteNode(Note note) {
                this.note = note;
            }

            @Override
            public SubjectNode getParent() {
                return SubjectNode.this;
            }

            @Generated
            public Note getNote() {
                return this.note;
            }
        }
    }
}

