/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import jrm.aui.progress.ProgressHandler;
import jrm.locale.Messages;
import jrm.misc.EnumWithDefault;
import jrm.misc.Log;
import jrm.misc.ProfileSettingsEnum;
import jrm.profile.Profile;
import jrm.profile.fix.Fix;
import jrm.profile.manager.ProfileNFO;
import jrm.profile.scan.Scan;
import jrm.profile.scan.options.ScanAutomation;
import jrm.security.Session;
import jrm.ui.MainFrame;
import jrm.ui.ProfileLoader;
import jrm.ui.ScannerAdvFilterPanel;
import jrm.ui.ScannerAutomationPanel;
import jrm.ui.ScannerDirPanel;
import jrm.ui.ScannerFiltersPanel;
import jrm.ui.ScannerSettingsPanel;
import jrm.ui.basic.JRMFileChooser;
import jrm.ui.profile.ProfileViewer;
import jrm.ui.profile.data.SourcesModel;
import jrm.ui.profile.data.SystmsModel;
import jrm.ui.progress.SwingWorkerProgress;

public class ScannerPanel
extends JPanel
implements ProfileLoader {
    private static final String ERROR_STR = "Error";
    private JTabbedPane scannerTabbedPane;
    private ScannerSettingsPanel scannerSettingsPanel;
    private ScannerDirPanel scannerDirPanel;
    private ScannerFiltersPanel scannerFilters;
    private ScannerAdvFilterPanel scannerAdvFilters;
    private ScannerAutomationPanel scannerAutomation;
    private JButton btnFix;
    private JButton btnScan;
    private JLabel lblProfileinfo;
    private JTabbedPane mainPane;
    private JSeparator separator2;
    private JButton btnLoadPreset;
    private JButton btnSavePreset;
    private JSeparator separator1;

    public ScannerPanel(Session session) {
        GridBagLayout gblScannerTab = new GridBagLayout();
        gblScannerTab.columnWidths = new int[]{104, 0};
        gblScannerTab.rowHeights = new int[]{0, 0, 24, 0};
        gblScannerTab.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gblScannerTab.rowWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gblScannerTab);
        JPanel scannerBtnPanel = new JPanel();
        GridBagConstraints gbcScannerBtnPanel = new GridBagConstraints();
        gbcScannerBtnPanel.insets = new Insets(0, 0, 5, 0);
        gbcScannerBtnPanel.fill = 1;
        gbcScannerBtnPanel.gridx = 0;
        gbcScannerBtnPanel.gridy = 0;
        this.add((Component)scannerBtnPanel, gbcScannerBtnPanel);
        JButton btnInfo = new JButton(Messages.getString((String)"MainFrame.btnInfo.text"));
        btnInfo.addActionListener(e -> {
            if (MainFrame.getProfileViewer() == null) {
                MainFrame.setProfileViewer(new ProfileViewer(session, SwingUtilities.getWindowAncestor(this), session.getCurrProfile()));
            }
            MainFrame.getProfileViewer().setVisible(true);
        });
        btnInfo.setIcon(MainFrame.getIcon("/jrm/resicons/icons/information.png"));
        scannerBtnPanel.add(btnInfo);
        this.separator1 = new JSeparator();
        this.separator1.setOrientation(1);
        this.separator1.setSize(new Dimension(2, 20));
        this.separator1.setPreferredSize(new Dimension(2, 20));
        scannerBtnPanel.add(this.separator1);
        this.btnScan = new JButton(Messages.getString((String)"MainFrame.btnScan.text"));
        this.btnScan.setIcon(MainFrame.getIcon("/jrm/resicons/icons/magnifier.png"));
        scannerBtnPanel.add(this.btnScan);
        this.btnScan.setEnabled(false);
        JButton btnReport = new JButton(Messages.getString((String)"MainFrame.btnReport.text"));
        btnReport.setIcon(MainFrame.getIcon("/jrm/resicons/icons/report.png"));
        btnReport.addActionListener(e -> EventQueue.invokeLater(() -> MainFrame.getReportFrame().setVisible(true)));
        scannerBtnPanel.add(btnReport);
        this.btnFix = new JButton(Messages.getString((String)"MainFrame.btnFix.text"));
        this.btnFix.setIcon(MainFrame.getIcon("/jrm/resicons/icons/tick.png"));
        scannerBtnPanel.add(this.btnFix);
        this.btnFix.addActionListener(e -> this.fix(session));
        this.btnFix.setEnabled(false);
        this.separator2 = new JSeparator();
        this.separator2.setOrientation(1);
        this.separator2.setSize(new Dimension(2, 20));
        this.separator2.setPreferredSize(new Dimension(2, 20));
        scannerBtnPanel.add(this.separator2);
        this.btnLoadPreset = new JButton("Import Settings");
        this.btnLoadPreset.setIcon(MainFrame.getIcon("/jrm/resicons/icons/table_refresh.png"));
        this.btnLoadPreset.addActionListener(e -> {
            List<FileFilter> filters = Arrays.asList(new FileNameExtensionFilter("Properties", "properties"));
            Path presets = session.getUser().getSettings().getWorkPath().resolve("presets");
            try {
                Files.createDirectories(presets, new FileAttribute[0]);
                new JRMFileChooser<Void>(0, 0, presets.toFile(), null, filters, "Import Settings", true).show(SwingUtilities.getWindowAncestor(this), chooser -> {
                    session.getCurrProfile().loadSettings(chooser.getSelectedFile());
                    session.getCurrProfile().loadCatVer(null);
                    session.getCurrProfile().loadNPlayers(null);
                    this.initProfileSettings(session);
                    return null;
                });
            }
            catch (IOException e1) {
                Log.err((String)e1.getMessage(), (Throwable)e1);
            }
        });
        scannerBtnPanel.add(this.btnLoadPreset);
        this.btnSavePreset = new JButton("Export Settings");
        this.btnSavePreset.setIcon(MainFrame.getIcon("/jrm/resicons/icons/table_save.png"));
        this.btnSavePreset.addActionListener(e -> {
            List<FileFilter> filters = Arrays.asList(new FileNameExtensionFilter("Properties", "properties"));
            Path presets = session.getUser().getSettings().getWorkPath().resolve("presets");
            try {
                Files.createDirectories(presets, new FileAttribute[0]);
                new JRMFileChooser<Void>(1, 0, presets.toFile(), null, filters, "Export Settings", true).show(SwingUtilities.getWindowAncestor(this), chooser -> {
                    session.getCurrProfile().saveSettings(chooser.getSelectedFile());
                    return null;
                });
            }
            catch (IOException e1) {
                Log.err((String)e1.getMessage(), (Throwable)e1);
            }
        });
        scannerBtnPanel.add(this.btnSavePreset);
        this.btnScan.addActionListener(e -> this.scan(session, true));
        this.scannerTabbedPane = new JTabbedPane(1);
        GridBagConstraints gbcScannerTabbedPane = new GridBagConstraints();
        gbcScannerTabbedPane.fill = 1;
        gbcScannerTabbedPane.gridx = 0;
        gbcScannerTabbedPane.gridy = 1;
        this.add((Component)this.scannerTabbedPane, gbcScannerTabbedPane);
        this.buildScannerDirTab(session);
        this.buildScannerSettingsTab(session);
        this.buildScannerFiltersTab(session);
        this.buildScannerAdvFiltersTab(session);
        this.buildScannerAutomationTab(session);
        this.lblProfileinfo = new JLabel("");
        this.lblProfileinfo.setBorder(new BevelBorder(1, null, null, null, null));
        GridBagConstraints gbcLblProfileinfo = new GridBagConstraints();
        gbcLblProfileinfo.insets = new Insets(0, 2, 0, 2);
        gbcLblProfileinfo.fill = 1;
        gbcLblProfileinfo.gridx = 0;
        gbcLblProfileinfo.gridy = 2;
        this.add((Component)this.lblProfileinfo, gbcLblProfileinfo);
    }

    private void buildScannerDirTab(Session session) {
        this.scannerDirPanel = new ScannerDirPanel(session);
        this.scannerTabbedPane.addTab(Messages.getString((String)"MainFrame.scannerDirectories.title"), MainFrame.getIcon("/jrm/resicons/icons/folder.png"), this.scannerDirPanel, null);
    }

    private void buildScannerSettingsTab(Session session) {
        this.scannerSettingsPanel = new ScannerSettingsPanel();
        this.scannerTabbedPane.addTab(Messages.getString((String)"MainFrame.scannerSettingsPanel.title"), MainFrame.getIcon("/jrm/resicons/icons/cog.png"), this.scannerSettingsPanel, null);
    }

    private void buildScannerFiltersTab(Session session) {
        this.scannerFilters = new ScannerFiltersPanel(session);
        this.scannerTabbedPane.addTab(Messages.getString((String)"MainFrame.Filters"), MainFrame.getIcon("/jrm/resicons/icons/arrow_join.png"), this.scannerFilters, null);
    }

    private void buildScannerAdvFiltersTab(Session session) {
        this.scannerAdvFilters = new ScannerAdvFilterPanel(session);
        this.scannerTabbedPane.addTab(Messages.getString((String)"MainFrame.AdvFilters"), MainFrame.getIcon("/jrm/resicons/icons/arrow_in.png"), this.scannerAdvFilters, null);
    }

    private void buildScannerAutomationTab(Session session) {
        this.scannerAutomation = new ScannerAutomationPanel();
        this.scannerTabbedPane.addTab(Messages.getString((String)"MainFrame.Automation"), MainFrame.getIcon("/jrm/resicons/icons/link.png"), this.scannerAutomation, null);
    }

    private void scan(final Session session, final boolean automate) {
        String txtdstdir = this.scannerDirPanel.txtRomsDest.getText();
        if (txtdstdir.isEmpty()) {
            this.scannerDirPanel.btnRomsDest.doClick();
            txtdstdir = this.scannerDirPanel.txtRomsDest.getText();
        }
        if (txtdstdir.isEmpty()) {
            return;
        }
        new SwingWorkerProgress<Void, Void>(SwingUtilities.getWindowAncestor(this)){

            @Override
            protected Void doInBackground() throws Exception {
                session.setCurrScan(new Scan(session.getCurrProfile(), (ProgressHandler)this));
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    ScannerPanel.this.btnFix.setEnabled(session.getCurrScan() != null && session.getCurrScan().actions.stream().mapToInt(Collection::size).sum() > 0);
                    this.close();
                    if (MainFrame.getProfileViewer() != null) {
                        MainFrame.getProfileViewer().reload();
                    }
                    ScanAutomation automation = ScanAutomation.valueOf((String)session.getCurrProfile().getSettings().getProperty((EnumWithDefault)ProfileSettingsEnum.automation_scan));
                    if (MainFrame.getReportFrame() != null) {
                        if (automation.hasReport()) {
                            MainFrame.getReportFrame().setVisible(true);
                        }
                        MainFrame.getReportFrame().setNeedUpdate(true);
                    }
                    if (automate && ScannerPanel.this.btnFix.isEnabled() && automation.hasFix()) {
                        ScannerPanel.this.fix(session);
                    }
                }
                catch (InterruptedException e) {
                    Log.err((String)e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    Optional.ofNullable(e.getCause()).ifPresentOrElse(cause -> {
                        Log.err((String)cause.getMessage(), (Throwable)cause);
                        JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(ScannerPanel.this), cause.getMessage(), ScannerPanel.ERROR_STR, 0);
                    }, () -> {
                        Log.err((String)e.getMessage(), (Throwable)e);
                        JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(ScannerPanel.this), e.getMessage(), ScannerPanel.ERROR_STR, 0);
                    });
                }
            }
        }.execute();
    }

    private void fix(final Session session) {
        new SwingWorkerProgress<Void, Void>(SwingUtilities.getWindowAncestor(this)){
            private boolean toFix;
            {
                super(owner);
                this.toFix = false;
            }

            @Override
            protected Void doInBackground() throws Exception {
                Fix fix;
                if (session.getCurrProfile().hasPropsChanged()) {
                    switch (JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(ScannerPanel.this), Messages.getString((String)"MainFrame.WarnSettingsChanged"), Messages.getString((String)"MainFrame.RescanBeforeFix"), 1)) {
                        case 0: {
                            session.setCurrScan(new Scan(session.getCurrProfile(), (ProgressHandler)this));
                            boolean bl = this.toFix = session.getCurrScan().actions.stream().mapToInt(Collection::size).sum() > 0;
                            if (this.toFix) break;
                            return null;
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                }
                this.toFix = (fix = new Fix(session.getCurrProfile(), session.getCurrScan(), (ProgressHandler)this)).getActionsRemain() > 0;
                return null;
            }

            @Override
            protected void done() {
                try {
                    ScanAutomation automation;
                    this.get();
                    ScannerPanel.this.btnFix.setEnabled(this.toFix);
                    this.close();
                    if (MainFrame.getProfileViewer() != null) {
                        MainFrame.getProfileViewer().reload();
                    }
                    if ((automation = ScanAutomation.valueOf((String)session.getCurrProfile().getSettings().getProperty((EnumWithDefault)ProfileSettingsEnum.automation_scan))).hasScanAgain()) {
                        ScannerPanel.this.scan(session, false);
                    }
                }
                catch (InterruptedException e) {
                    Log.err((String)e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    Optional.ofNullable(e.getCause()).ifPresentOrElse(cause -> {
                        Log.err((String)cause.getMessage(), (Throwable)cause);
                        JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(ScannerPanel.this), cause.getMessage(), ScannerPanel.ERROR_STR, 0);
                    }, () -> {
                        Log.err((String)e.getMessage(), (Throwable)e);
                        JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(ScannerPanel.this), e.getMessage(), ScannerPanel.ERROR_STR, 0);
                    });
                }
            }
        }.execute();
    }

    public void initProfileSettings(Session session) {
        this.scannerSettingsPanel.initProfileSettings(session.getCurrProfile().getSettings());
        this.scannerDirPanel.initProfileSettings(session);
        this.scannerFilters.initProfileSettings(session);
        this.scannerAdvFilters.initProfileSettings(session);
        this.scannerAutomation.initProfileSettings(session.getCurrProfile().getSettings());
    }

    @Override
    public void loadProfile(final Session session, final ProfileNFO profile) {
        if (session.getCurrProfile() != null) {
            session.getCurrProfile().saveSettings();
        }
        if (MainFrame.getProfileViewer() != null) {
            MainFrame.getProfileViewer().clear();
        }
        new SwingWorkerProgress<Void, Void>(SwingUtilities.getWindowAncestor(this)){
            private boolean success;
            {
                super(owner);
                this.success = false;
            }

            @Override
            protected Void doInBackground() throws Exception {
                this.success = null != Profile.load((Session)session, (ProfileNFO)profile, (ProgressHandler)this);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    session.getReport().setProfile(session.getCurrProfile());
                    if (MainFrame.getProfileViewer() != null) {
                        MainFrame.getProfileViewer().reset(session.getCurrProfile());
                    }
                    ScannerPanel.this.mainPane.setEnabledAt(1, this.success);
                    ScannerPanel.this.btnScan.setEnabled(this.success);
                    ScannerPanel.this.btnFix.setEnabled(false);
                    if (this.success && session.getCurrProfile() != null) {
                        ScannerPanel.this.lblProfileinfo.setText(session.getCurrProfile().getName());
                        ScannerPanel.this.scannerFilters.checkBoxListSystems.setModel(new SystmsModel(session.getCurrProfile().getSystems()));
                        ScannerPanel.this.scannerFilters.checkBoxListSources.setModel(new SourcesModel(session.getCurrProfile().getSources()));
                        ScannerPanel.this.initProfileSettings(session);
                        ScannerPanel.this.mainPane.setSelectedIndex(1);
                    }
                    this.close();
                }
                catch (InterruptedException e) {
                    Log.err((String)e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    Optional.ofNullable(e.getCause()).ifPresentOrElse(cause -> {
                        Log.err((String)cause.getMessage(), (Throwable)cause);
                        JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(ScannerPanel.this), cause.getMessage(), ScannerPanel.ERROR_STR, 0);
                    }, () -> {
                        Log.err((String)e.getMessage(), (Throwable)e);
                        JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(ScannerPanel.this), e.getMessage(), ScannerPanel.ERROR_STR, 0);
                    });
                }
            }
        }.execute();
    }

    JTabbedPane getMainPane() {
        return this.mainPane;
    }

    void setMainPane(JTabbedPane mainPane) {
        this.mainPane = mainPane;
    }
}

