/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.basic;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import jrm.misc.Log;
import jrm.ui.basic.JFileDropMode;

interface JFileDrop
extends DropTargetListener {
    public JFileDropMode getMode();

    public FilenameFilter getFilter();

    @Override
    default public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    default public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    default public List<File> getTransferData(Transferable transferable) throws UnsupportedFlavorException, IOException {
        return ((List)transferable.getTransferData(DataFlavor.javaFileListFlavor)).stream().filter(f -> {
            if (this.getMode() == JFileDropMode.DIRECTORY && !f.isDirectory()) {
                return false;
            }
            if (this.getMode() == JFileDropMode.FILE && !f.isFile()) {
                return false;
            }
            if (this.getFilter() != null) {
                return this.getFilter().accept(f.getParentFile(), f.getName());
            }
            return true;
        }).collect(Collectors.toList());
    }

    public boolean checkValid(List<File> var1);

    public boolean isFlavorSupported(Transferable var1);

    default public void drop(DropTargetDropEvent dtde, CallBack cb) {
        try {
            Transferable transferable = dtde.getTransferable();
            if (this.isFlavorSupported(transferable)) {
                dtde.acceptDrop(1);
                List<File> files = this.getTransferData(transferable);
                if (this.checkValid(files)) {
                    cb.apply(files);
                    dtde.getDropTargetContext().dropComplete(true);
                } else {
                    dtde.getDropTargetContext().dropComplete(false);
                }
            } else {
                dtde.rejectDrop();
            }
        }
        catch (UnsupportedFlavorException e) {
            Log.warn((Object)e.getMessage());
            dtde.rejectDrop();
        }
        catch (Exception e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            dtde.rejectDrop();
        }
    }

    @FunctionalInterface
    public static interface CallBack {
        public void apply(List<File> var1);
    }
}

