/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.batch;

import java.util.Set;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import jrm.batch.TrntChkReport;
import jrm.locale.Messages;
import jrm.profile.report.FilterOptions;
import jrm.security.Session;
import jrm.ui.MainFrame;
import jrm.ui.basic.Popup;
import jrm.ui.batch.BatchTrrntChkReportTreeCellRenderer;
import jrm.ui.batch.BatchTrrntChkReportTreeModel;

public class BatchTrrntChkReportView
extends JScrollPane {
    public BatchTrrntChkReportView(Session session, TrntChkReport report) {
        JTree tree = new JTree();
        tree.setShowsRootHandles(true);
        tree.setRootVisible(false);
        tree.setModel(new BatchTrrntChkReportTreeModel(report));
        tree.setCellRenderer(new BatchTrrntChkReportTreeCellRenderer());
        this.setViewportView(tree);
        JPopupMenu popupMenu = new JPopupMenu();
        Popup.addPopup(tree, popupMenu);
        JMenuItem mntmOpenAllNodes = new JMenuItem(Messages.getString((String)"ReportFrame.mntmOpenAllNodes.text"));
        mntmOpenAllNodes.setIcon(MainFrame.getIcon("/jrm/resicons/folder_open.png"));
        mntmOpenAllNodes.addActionListener(e -> {
            tree.invalidate();
            int j = tree.getRowCount();
            for (int i = 0; i < j; ++i) {
                tree.expandRow(i);
                j = tree.getRowCount();
            }
            tree.validate();
        });
        popupMenu.add(mntmOpenAllNodes);
        JMenuItem mntmCloseAllNodes = new JMenuItem(Messages.getString((String)"ReportFrame.mntmCloseAllNodes.text"));
        mntmCloseAllNodes.setIcon(MainFrame.getIcon("/jrm/resicons/folder_closed.png"));
        mntmCloseAllNodes.addActionListener(e -> {
            tree.invalidate();
            int j = tree.getRowCount();
            for (int i = 0; i < j; ++i) {
                tree.collapseRow(i);
                j = tree.getRowCount();
            }
            tree.validate();
        });
        popupMenu.add(mntmCloseAllNodes);
        JCheckBoxMenuItem chckbxmntmShowOkEntries = new JCheckBoxMenuItem(Messages.getString((String)"ReportFrame.chckbxmntmShowOkEntries.text"));
        chckbxmntmShowOkEntries.setIcon(MainFrame.getIcon("/jrm/resicons/folder_closed_green.png"));
        chckbxmntmShowOkEntries.addItemListener(e -> {
            Set options = report.getHandler().getFilterOptions();
            if (e.getStateChange() == 1) {
                options.add(FilterOptions.SHOWOK);
            } else {
                options.remove(FilterOptions.SHOWOK);
            }
            report.getHandler().filter(options.toArray(new FilterOptions[0]));
        });
        popupMenu.add(chckbxmntmShowOkEntries);
        JCheckBoxMenuItem chckbxmntmHideFullyMissing = new JCheckBoxMenuItem(Messages.getString((String)"ReportFrame.chckbxmntmHideFullyMissing.text"));
        chckbxmntmHideFullyMissing.setIcon(MainFrame.getIcon("/jrm/resicons/folder_closed_red.png"));
        chckbxmntmHideFullyMissing.addItemListener(e -> {
            Set options = report.getHandler().getFilterOptions();
            if (e.getStateChange() == 1) {
                options.add(FilterOptions.HIDEMISSING);
            } else {
                options.remove(FilterOptions.HIDEMISSING);
            }
            report.getHandler().filter(options.toArray(new FilterOptions[0]));
        });
        popupMenu.add(chckbxmntmHideFullyMissing);
    }
}

