/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.batch;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class FileCellRenderer
extends DefaultTableCellRenderer {
    FileCellRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setBackground(Color.white);
        if (value instanceof File) {
            File f = (File)value;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setText(FileCellRenderer.trimmedStringCalculator(f.getPath(), table, this, table.getColumnModel().getColumn(column).getWidth() - 10));
            return this;
        }
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    protected static String trimmedStringCalculator(String inputText, JTable table, JLabel component, int width) {
        String ellipses = "...";
        StringBuilder textToBeDisplayed = new StringBuilder();
        FontMetrics fm = table.getFontMetrics(component.getFont());
        for (int i = inputText.length() - 1; i >= 0; --i) {
            if (fm.stringWidth(ellipses + String.valueOf(textToBeDisplayed)) > width) continue;
            textToBeDisplayed.insert(0, inputText);
        }
        if (0 != CharSequence.compare(textToBeDisplayed, inputText)) {
            return String.join((CharSequence)ellipses, textToBeDisplayed);
        }
        return inputText;
    }
}

