/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jrm.aui.progress.ProgressHandler;
import jrm.locale.Messages;
import jrm.misc.Log;
import jrm.misc.ProfileSettingsEnum;
import jrm.profile.Profile;
import jrm.profile.data.Anyware;
import jrm.profile.data.AnywareList;
import jrm.profile.data.AnywareStatus;
import jrm.profile.data.Device;
import jrm.profile.data.EntityStatus;
import jrm.profile.data.Machine;
import jrm.profile.data.MachineList;
import jrm.profile.data.Software;
import jrm.profile.data.SoftwareList;
import jrm.profile.filter.Keywords;
import jrm.profile.manager.Export;
import jrm.profile.manager.ProfileNFOMame;
import jrm.security.Session;
import jrm.ui.MainFrame;
import jrm.ui.basic.JRMFileChooser;
import jrm.ui.basic.Popup;
import jrm.ui.profile.data.AnywareListListModel;
import jrm.ui.profile.data.AnywareListModel;
import jrm.ui.profile.data.AnywareModel;
import jrm.ui.profile.data.MachineListListModel;
import jrm.ui.profile.data.MachineListModel;
import jrm.ui.profile.data.SoftwareListModel;
import jrm.ui.profile.filter.KeywordFilter;
import jrm.ui.progress.SwingWorkerProgress;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.SerializationUtils;

public class ProfileViewer
extends JDialog {
    private static final String PROFILE_VIEWER_AS_SW_LISTS_DAT = "ProfileViewer.AsSWListsDat";
    private static final String PROFILE_VIEWER_ERROR = "ProfileViewer.Error";
    private JTable tableEntity;
    private JTable tableW;
    private JTable tableWL;
    private JTextField txtSearch;

    public ProfileViewer(final Session session, Window owner, Profile profile) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                session.getUser().getSettings().setProperty("ProfileViewer.Bounds", Hex.encodeHexString((byte[])SerializationUtils.serialize((Serializable)ProfileViewer.this.getBounds())));
            }
        });
        this.setIconImage(MainFrame.getIcon("/jrm/resicons/rom.png").getImage());
        this.setTitle(Messages.getString((String)"ProfileViewer.this.title"));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setResizeWeight(0.5);
        splitPane.setOrientation(0);
        this.getContentPane().add((Component)splitPane, "Center");
        JPanel panelWare = new JPanel();
        splitPane.setLeftComponent(panelWare);
        panelWare.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPaneWLW = new JSplitPane();
        splitPaneWLW.setOneTouchExpandable(true);
        splitPaneWLW.setContinuousLayout(true);
        splitPaneWLW.setResizeWeight(0.25);
        panelWare.add((Component)splitPaneWLW, "Center");
        this.tableEntity = new JTable();
        this.tableEntity.setSelectionMode(0);
        this.tableEntity.setPreferredScrollableViewportSize(new Dimension(1200, 300));
        this.tableEntity.setShowGrid(false);
        this.tableEntity.setShowHorizontalLines(false);
        this.tableEntity.setShowVerticalLines(false);
        this.tableEntity.setRowSelectionAllowed(true);
        this.tableEntity.setFillsViewportHeight(true);
        this.tableEntity.setAutoResizeMode(4);
        JPanel panelW = new JPanel();
        splitPaneWLW.setRightComponent(panelW);
        panelW.setLayout(new BorderLayout(0, 0));
        JToolBar toolBarW = new JToolBar();
        panelW.add((Component)toolBarW, "South");
        JToggleButton tglbtnMissingW = new JToggleButton("");
        tglbtnMissingW.setSelected(true);
        tglbtnMissingW.setToolTipText(Messages.getString((String)"ProfileViewer.tglbtnMissingW.toolTipText"));
        tglbtnMissingW.setIcon(MainFrame.getIcon("/jrm/resicons/folder_closed_red.png"));
        toolBarW.add(tglbtnMissingW);
        JToggleButton tglbtnPartialW = new JToggleButton("");
        tglbtnPartialW.setSelected(true);
        tglbtnPartialW.setToolTipText(Messages.getString((String)"ProfileViewer.tglbtnPartialW.toolTipText"));
        tglbtnPartialW.setIcon(MainFrame.getIcon("/jrm/resicons/folder_closed_orange.png"));
        toolBarW.add(tglbtnPartialW);
        JToggleButton tglbtnCompleteW = new JToggleButton("");
        tglbtnCompleteW.setSelected(true);
        tglbtnCompleteW.setIcon(MainFrame.getIcon("/jrm/resicons/folder_closed_green.png"));
        tglbtnCompleteW.setToolTipText(Messages.getString((String)"ProfileViewer.tglbtnCompleteW.toolTipText"));
        toolBarW.add(tglbtnCompleteW);
        JPanel panelSearch = new JPanel();
        panelSearch.setBorder(null);
        toolBarW.add(panelSearch);
        GridBagLayout gblPanelSearch = new GridBagLayout();
        gblPanelSearch.columnWidths = new int[]{286, 166, 0};
        gblPanelSearch.rowHeights = new int[]{20, 0};
        gblPanelSearch.columnWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        gblPanelSearch.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        panelSearch.setLayout(gblPanelSearch);
        JLabel lblSearch = new JLabel(Messages.getString((String)"ProfileViewer.lblSearch.text"));
        GridBagConstraints gbcLblSearch = new GridBagConstraints();
        gbcLblSearch.insets = new Insets(0, 0, 0, 5);
        gbcLblSearch.anchor = 13;
        gbcLblSearch.gridx = 0;
        gbcLblSearch.gridy = 0;
        panelSearch.add((Component)lblSearch, gbcLblSearch);
        this.txtSearch = new JTextField();
        this.txtSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ProfileViewer.this.search();
            }
        });
        GridBagConstraints gbcTxtSearch = new GridBagConstraints();
        gbcTxtSearch.fill = 3;
        gbcTxtSearch.anchor = 17;
        gbcTxtSearch.gridx = 1;
        gbcTxtSearch.gridy = 0;
        panelSearch.add((Component)this.txtSearch, gbcTxtSearch);
        this.txtSearch.setText("");
        this.txtSearch.setColumns(20);
        tglbtnMissingW.addItemListener(e -> this.setFilterW(tglbtnMissingW.isSelected(), tglbtnPartialW.isSelected(), tglbtnCompleteW.isSelected()));
        tglbtnPartialW.addItemListener(e -> this.setFilterW(tglbtnMissingW.isSelected(), tglbtnPartialW.isSelected(), tglbtnCompleteW.isSelected()));
        tglbtnCompleteW.addItemListener(e -> this.setFilterW(tglbtnMissingW.isSelected(), tglbtnPartialW.isSelected(), tglbtnCompleteW.isSelected()));
        JScrollPane scrollPaneW = new JScrollPane();
        panelW.add(scrollPaneW);
        this.tableW = new JTable();
        scrollPaneW.setViewportView(this.tableW);
        this.tableW.setPreferredScrollableViewportSize(new Dimension(600, 400));
        this.tableW.setFillsViewportHeight(true);
        this.tableW.setSelectionMode(0);
        this.tableW.setShowGrid(false);
        this.tableW.setShowHorizontalLines(false);
        this.tableW.setShowVerticalLines(false);
        this.tableW.setAutoResizeMode(4);
        JPopupMenu popupWMenu = new JPopupMenu();
        Popup.addPopup(this.tableW, popupWMenu);
        JMenuItem mntmCollectKeywords = new JMenuItem(Messages.getString((String)"ProfileViewer.mntmCollectKeywords.text"));
        mntmCollectKeywords.addActionListener(e -> new KW().filter(((AnywareListModel)this.tableW.getModel()).getList()));
        popupWMenu.add(mntmCollectKeywords);
        JMenuItem mntmSelectNone = new JMenuItem(Messages.getString((String)"ProfileViewer.mntmSelectNone.text"));
        mntmSelectNone.addActionListener(e -> {
            AnywareListModel list = (AnywareListModel)this.tableW.getModel();
            list.getList().getFilteredStream().forEach(ware -> ware.setSelected(false));
            list.fireTableChanged(new TableModelEvent(list, 0, list.getRowCount() - 1, -1, 0));
        });
        popupWMenu.add(mntmSelectNone);
        JMenuItem mntmSelectAll = new JMenuItem(Messages.getString((String)"ProfileViewer.mntmSelectAll.text"));
        mntmSelectAll.addActionListener(e -> {
            AnywareListModel list = (AnywareListModel)this.tableW.getModel();
            list.getList().getFilteredStream().forEach(ware -> ware.setSelected(true));
            list.fireTableChanged(new TableModelEvent(list, 0, list.getRowCount() - 1, -1, 0));
        });
        popupWMenu.add(mntmSelectAll);
        JMenuItem mntmSelectInvert = new JMenuItem(Messages.getString((String)"ProfileViewer.mntmSelectInvert.text"));
        mntmSelectInvert.addActionListener(e -> {
            AnywareListModel list = (AnywareListModel)this.tableW.getModel();
            list.getList().getFilteredStream().forEach(ware -> ware.setSelected(!ware.isSelected()));
            list.fireTableChanged(new TableModelEvent(list, 0, list.getRowCount() - 1, -1, 0));
        });
        popupWMenu.add(mntmSelectInvert);
        JPanel panel = new JPanel();
        splitPaneWLW.setLeftComponent(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPaneWL = new JScrollPane();
        panel.add(scrollPaneWL);
        this.tableWL = new JTable();
        scrollPaneWL.setViewportView(this.tableWL);
        this.tableWL.setPreferredScrollableViewportSize(new Dimension(300, 400));
        this.tableWL.setModel(new MachineListListModel(profile.getMachineListList()));
        this.tableWL.setTableHeader(new JTableHeader(this.tableWL.getColumnModel()){

            @Override
            public String getToolTipText(MouseEvent e) {
                return this.columnModel.getColumn(this.columnModel.getColumnIndexAtX(e.getPoint().x)).getHeaderValue().toString();
            }
        });
        this.tableWL.setFillsViewportHeight(true);
        this.tableWL.setShowGrid(false);
        this.tableWL.setShowHorizontalLines(false);
        this.tableWL.setShowVerticalLines(false);
        this.tableWL.setSelectionMode(0);
        JPopupMenu popupMenu = new JPopupMenu();
        Popup.addPopup(this.tableWL, popupMenu);
        JMenu mnExportAll = new JMenu(Messages.getString((String)"ProfileViewer.ExportAll"));
        popupMenu.add(mnExportAll);
        JMenu mnExportAllFiltered = new JMenu(Messages.getString((String)"ProfileViewer.Filtered"));
        mnExportAll.add(mnExportAllFiltered);
        final JMenuItem mntmFilteredAsLogiqxDat = new JMenuItem(Messages.getString((String)"ProfileViewer.AsLogiqxDat"));
        mnExportAllFiltered.add(mntmFilteredAsLogiqxDat);
        mntmFilteredAsLogiqxDat.addActionListener(e -> this.export(session, Export.ExportType.DATAFILE, true, null));
        final JMenuItem mntmFilteredAsMameDat = new JMenuItem(Messages.getString((String)"ProfileViewer.AsMameDat"));
        mnExportAllFiltered.add(mntmFilteredAsMameDat);
        mntmFilteredAsMameDat.addActionListener(e -> this.export(session, Export.ExportType.MAME, true, null));
        final JMenuItem mntmFilteredAsSoftwareLists = new JMenuItem(Messages.getString((String)PROFILE_VIEWER_AS_SW_LISTS_DAT));
        mnExportAllFiltered.add(mntmFilteredAsSoftwareLists);
        mntmFilteredAsSoftwareLists.addActionListener(e -> this.export(session, Export.ExportType.SOFTWARELIST, true, null));
        final JMenuItem mntmAllAsLogiqxDat = new JMenuItem(Messages.getString((String)"ProfileViewer.AsLogiqxDat"));
        mntmAllAsLogiqxDat.setEnabled(false);
        mnExportAll.add(mntmAllAsLogiqxDat);
        mntmAllAsLogiqxDat.addActionListener(e -> this.export(session, Export.ExportType.DATAFILE, false, null));
        final JMenuItem mntmAllAsMameDat = new JMenuItem(Messages.getString((String)"ProfileViewer.AsMameDat"));
        mntmAllAsMameDat.setEnabled(false);
        mnExportAll.add(mntmAllAsMameDat);
        mntmAllAsMameDat.addActionListener(e -> this.export(session, Export.ExportType.MAME, false, null));
        final JMenuItem mntmAllAsSoftwareLists = new JMenuItem(Messages.getString((String)PROFILE_VIEWER_AS_SW_LISTS_DAT));
        mntmAllAsSoftwareLists.setEnabled(false);
        mnExportAll.add(mntmAllAsSoftwareLists);
        mntmAllAsSoftwareLists.addActionListener(e -> this.export(session, Export.ExportType.SOFTWARELIST, false, null));
        JMenu mnExportSelected = new JMenu(Messages.getString((String)"ProfileViewer.ExportSelected"));
        popupMenu.add(mnExportSelected);
        JMenu mnExportSelectedFiltered = new JMenu(Messages.getString((String)"ProfileViewer.Filtered"));
        mnExportSelected.add(mnExportSelectedFiltered);
        final JMenuItem mntmSelectedFilteredAsSoftwareList = new JMenuItem(Messages.getString((String)"ProfileViewer.AsSWListDat"));
        mnExportSelectedFiltered.add(mntmSelectedFilteredAsSoftwareList);
        mntmSelectedFilteredAsSoftwareList.addActionListener(e -> this.export(session, Export.ExportType.SOFTWARELIST, true, (SoftwareList)this.tableWL.getModel().getValueAt(this.tableWL.getSelectedRow(), 0)));
        final JMenuItem mntmSelectedAsSoftwareLists = new JMenuItem(Messages.getString((String)PROFILE_VIEWER_AS_SW_LISTS_DAT));
        mntmSelectedAsSoftwareLists.setEnabled(false);
        mnExportSelected.add(mntmSelectedAsSoftwareLists);
        mntmSelectedAsSoftwareLists.addActionListener(e -> this.export(session, Export.ExportType.SOFTWARELIST, false, (SoftwareList)this.tableWL.getModel().getValueAt(this.tableWL.getSelectedRow(), 0)));
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                MachineListListModel model;
                TableModel tableModel;
                boolean has_machines = session.getCurrProfile().getMachineListList().getList().stream().mapToInt(ml -> ml.getList().size()).sum() > 0;
                boolean has_filtered_machines = session.getCurrProfile().getMachineListList().getFilteredStream().mapToInt(m -> (int)m.countAll()).sum() > 0;
                boolean has_selected_swlist = ProfileViewer.this.tableWL.getSelectedRowCount() == 1 && (tableModel = ProfileViewer.this.tableWL.getModel()) instanceof MachineListListModel && (model = (MachineListListModel)tableModel).getValueAt(ProfileViewer.this.tableWL.getSelectedRow(), 0) instanceof SoftwareList;
                mntmAllAsMameDat.setEnabled(has_machines);
                mntmAllAsLogiqxDat.setEnabled(has_machines);
                mntmAllAsSoftwareLists.setEnabled(!session.getCurrProfile().getMachineListList().getSoftwareListList().isEmpty());
                mntmFilteredAsMameDat.setEnabled(has_filtered_machines);
                mntmFilteredAsLogiqxDat.setEnabled(has_filtered_machines);
                mntmFilteredAsSoftwareLists.setEnabled(session.getCurrProfile().getMachineListList().getSoftwareListList().getFilteredStream().count() > 0L);
                mntmSelectedAsSoftwareLists.setEnabled(has_selected_swlist);
                mntmSelectedFilteredAsSoftwareList.setEnabled(has_selected_swlist);
            }
        });
        JToolBar toolBarWL = new JToolBar();
        panel.add((Component)toolBarWL, "South");
        JToggleButton tglbtnMissingWL = new JToggleButton("");
        tglbtnMissingWL.setSelected(true);
        tglbtnMissingWL.setIcon(MainFrame.getIcon("/jrm/resicons/disk_multiple_red.png"));
        tglbtnMissingWL.setToolTipText(Messages.getString((String)"ProfileViewer.tglbtnMissingWL.toolTipText"));
        toolBarWL.add(tglbtnMissingWL);
        JToggleButton tglbtnPartialWL = new JToggleButton("");
        tglbtnPartialWL.setSelected(true);
        tglbtnPartialWL.setIcon(MainFrame.getIcon("/jrm/resicons/disk_multiple_orange.png"));
        tglbtnPartialWL.setToolTipText(Messages.getString((String)"ProfileViewer.tglbtnPartialWL.toolTipText"));
        toolBarWL.add(tglbtnPartialWL);
        JToggleButton tglbtnCompleteWL = new JToggleButton("");
        tglbtnCompleteWL.setSelected(true);
        tglbtnCompleteWL.setIcon(MainFrame.getIcon("/jrm/resicons/disk_multiple_green.png"));
        tglbtnCompleteWL.setToolTipText(Messages.getString((String)"ProfileViewer.tglbtnCompleteWL.toolTipText"));
        toolBarWL.add(tglbtnCompleteWL);
        tglbtnMissingWL.addItemListener(e -> this.setFilterWL(tglbtnMissingWL.isSelected(), tglbtnPartialWL.isSelected(), tglbtnCompleteWL.isSelected()));
        tglbtnPartialWL.addItemListener(e -> this.setFilterWL(tglbtnMissingWL.isSelected(), tglbtnPartialWL.isSelected(), tglbtnCompleteWL.isSelected()));
        tglbtnCompleteWL.addItemListener(e -> this.setFilterWL(tglbtnMissingWL.isSelected(), tglbtnPartialWL.isSelected(), tglbtnCompleteWL.isSelected()));
        this.tableWL.getSelectionModel().addListSelectionListener(this::selectItemWL);
        this.tableW.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ProfileViewer.this.clickItemW(session, e);
            }
        });
        this.tableW.getSelectionModel().addListSelectionListener(this::selecteItemW);
        JPanel panelEntity = new JPanel();
        splitPane.setRightComponent(panelEntity);
        panelEntity.setLayout(new BorderLayout(0, 0));
        JToolBar toolBarEntity = new JToolBar();
        panelEntity.add((Component)toolBarEntity, "South");
        JToggleButton tglbtnBad = new JToggleButton("");
        tglbtnBad.setSelected(true);
        tglbtnBad.setIcon(MainFrame.getIcon("/jrm/resicons/icons/bullet_red.png"));
        tglbtnBad.setToolTipText(Messages.getString((String)"ProfileViewer.tglbtnBad.toolTipText"));
        toolBarEntity.add(tglbtnBad);
        JToggleButton tglbtnOK = new JToggleButton("");
        tglbtnOK.setSelected(true);
        tglbtnOK.setToolTipText(Messages.getString((String)"ProfileViewer.tglbtnOK.toolTipText"));
        tglbtnOK.setIcon(MainFrame.getIcon("/jrm/resicons/icons/bullet_green.png"));
        toolBarEntity.add(tglbtnOK);
        tglbtnBad.addItemListener(e -> this.setFilterE(tglbtnBad.isSelected(), tglbtnOK.isSelected()));
        tglbtnOK.addItemListener(e -> this.setFilterE(tglbtnBad.isSelected(), tglbtnOK.isSelected()));
        JScrollPane scrollPaneEntity = new JScrollPane();
        panelEntity.add((Component)scrollPaneEntity, "Center");
        scrollPaneEntity.setViewportView(this.tableEntity);
        JPopupMenu popupEntMenu = new JPopupMenu();
        Popup.addPopup(this.tableEntity, popupEntMenu);
        final JMenuItem mntmCopyCRC = new JMenuItem("Copy CRC");
        mntmCopyCRC.addActionListener(e -> this.copyHash(3));
        popupEntMenu.add(mntmCopyCRC);
        final JMenuItem mntmCopySHA1 = new JMenuItem("Copy SHA1");
        mntmCopySHA1.addActionListener(e -> this.copyHash(5));
        popupEntMenu.add(mntmCopySHA1);
        final JMenuItem mntmCopyName = new JMenuItem("Copy Name");
        mntmCopyName.addActionListener(e -> this.copyHash(1));
        popupEntMenu.add(mntmCopyName);
        final JMenuItem mntmSearchWeb = new JMenuItem("Search on the Web");
        mntmSearchWeb.addActionListener(e -> {
            int index = this.tableEntity.getSelectedRow();
            if (index >= 0 && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                try {
                    String name = this.tableEntity.getModel().getValueAt(index, 1).toString();
                    Object crc = this.tableEntity.getModel().getValueAt(index, 3);
                    Object sha1 = this.tableEntity.getModel().getValueAt(index, 5);
                    String hash = Optional.ofNullable(Optional.ofNullable(crc).orElse(sha1)).map(h -> "+" + h.toString()).orElse("");
                    Desktop.getDesktop().browse(new URI("https://www.google.com/search?q=" + URLEncoder.encode("\"" + name + "\"", "UTF-8") + hash));
                }
                catch (IOException | URISyntaxException e1) {
                    Log.err((String)e1.getMessage(), (Throwable)e1);
                }
            }
        });
        popupEntMenu.add(mntmSearchWeb);
        popupEntMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                boolean has_selected_entity = ProfileViewer.this.tableEntity.getSelectedRowCount() > 0;
                mntmCopyCRC.setEnabled(has_selected_entity);
                mntmCopySHA1.setEnabled(has_selected_entity);
                mntmCopyName.setEnabled(has_selected_entity);
                mntmSearchWeb.setEnabled(has_selected_entity);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.reset(profile);
        this.pack();
        try {
            this.setBounds((Rectangle)SerializationUtils.deserialize((byte[])Hex.decodeHex((String)session.getUser().getSettings().getProperty("ProfileViewer.Bounds", Hex.encodeHexString((byte[])SerializationUtils.serialize((Serializable)this.getBounds()))))));
        }
        catch (DecoderException e1) {
            Log.err((String)e1.getMessage(), (Throwable)e1);
        }
        this.setVisible(true);
    }

    private void copyHash(int col) throws HeadlessException {
        Object hash;
        int index = this.tableEntity.getSelectedRow();
        if (index >= 0 && (hash = this.tableEntity.getModel().getValueAt(index, col)) != null) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(hash.toString()), null);
        }
    }

    private void selecteItemW(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            ListSelectionModel model = (ListSelectionModel)e.getSource();
            TableModel tablemodel = this.tableW.getModel();
            if (model != null && tablemodel != null) {
                if (!model.isSelectionEmpty()) {
                    AnywareModel anyware = new AnywareModel((Anyware)tablemodel.getValueAt(model.getMinSelectionIndex(), 0));
                    anyware.reset();
                    this.tableEntity.setModel(anyware);
                    this.tableEntity.setTableHeader(new JTableHeader(this.tableEntity.getColumnModel()){

                        @Override
                        public String getToolTipText(MouseEvent e) {
                            return this.columnModel.getColumn(this.columnModel.getColumnIndexAtX(e.getPoint().x)).getHeaderValue().toString();
                        }
                    });
                    this.readjustColumnsE(anyware);
                } else {
                    this.tableEntity.setModel(new DefaultTableModel());
                }
            }
        }
    }

    private void readjustColumnsE(AnywareModel anyware) {
        for (int i = 0; i < this.tableEntity.getColumnModel().getColumnCount(); ++i) {
            TableColumn column = this.tableEntity.getColumnModel().getColumn(i);
            column.setCellRenderer(anyware.getColumnRenderer(i));
            int width = anyware.getColumnWidth(i);
            if (width > 0) {
                column.setMinWidth(width / 2);
                column.setPreferredWidth(width);
                continue;
            }
            if (width >= 0) continue;
            Component component = column.getCellRenderer().getTableCellRendererComponent(this.tableEntity, null, false, false, 0, i);
            String format = "%0" + -width + "d";
            int pixwidth = component.getFontMetrics(component.getFont()).stringWidth(String.format(format, 0));
            column.setMinWidth(pixwidth / 2);
            column.setPreferredWidth(pixwidth);
            column.setMaxWidth(pixwidth);
        }
    }

    private void clickItemW(Session session, MouseEvent e) throws HeadlessException {
        int column;
        if (e.getClickCount() != 2) {
            return;
        }
        int row = this.tableW.getSelectedRow();
        if (row < 0) {
            return;
        }
        AnywareListModel tablemodel = (AnywareListModel)this.tableW.getModel();
        Object obj = tablemodel.getValueAt(row, column = this.tableW.columnAtPoint(e.getPoint()));
        if (!(obj instanceof Anyware)) {
            return;
        }
        Anyware ware = (Anyware)obj;
        if (column > 1) {
            this.jumpTo(this.tableW, tablemodel.getList().find(ware));
        } else if (ware.getStatus() == AnywareStatus.COMPLETE) {
            if (session.getCurrProfile() != null) {
                Profile profile = session.getCurrProfile();
                if (profile.getNfo().getMame().getStatus() == ProfileNFOMame.MameStatus.UPTODATE) {
                    this.launchMame(ware, profile);
                } else {
                    JOptionPane.showMessageDialog(this, String.format(Messages.getString((String)"ProfileViewer.MameNotAvailableOrObsolete"), profile.getNfo().getMame().getStatus()), Messages.getString((String)PROFILE_VIEWER_ERROR), 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, Messages.getString((String)"ProfileViewer.NoProfile"), Messages.getString((String)PROFILE_VIEWER_ERROR), 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, String.format(Messages.getString((String)"ProfileViewer.CantLaunchIncompleteSet"), ware.getStatus()), Messages.getString((String)PROFILE_VIEWER_ERROR), 0);
        }
    }

    private void jumpTo(JTable target, int row) {
        if (row >= 0) {
            target.setRowSelectionInterval(row, row);
            target.scrollRectToVisible(target.getCellRect(row, 0, true));
        }
    }

    private void launchMame(Anyware ware, Profile profile) throws HeadlessException {
        ProfileNFOMame mame = profile.getNfo().getMame();
        String[] args = null;
        args = ware instanceof Software ? this.getMameArgsSofware(ware, profile, mame, args) : this.getMameArgsMachine(ware, profile, mame);
        if (args != null) {
            ProcessBuilder pb = new ProcessBuilder(args).directory(mame.getFile().getParentFile()).redirectErrorStream(true).redirectOutput(new File(mame.getFile().getParentFile(), "JRomManager.log"));
            try {
                pb.start().waitFor();
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(this, e1.getMessage(), Messages.getString((String)"ProfileViewer.Exception"), 0);
            }
            catch (InterruptedException e1) {
                JOptionPane.showMessageDialog(this, e1.getMessage(), Messages.getString((String)"ProfileViewer.Exception"), 0);
                Thread.currentThread().interrupt();
            }
        }
    }

    private String[] getMameArgsMachine(Anyware ware, Profile profile, ProfileNFOMame mame) {
        ArrayList<String> rompaths = new ArrayList<String>(Collections.singletonList(profile.getProperty(ProfileSettingsEnum.roms_dest_dir)));
        if (Boolean.TRUE.equals(profile.getProperty(ProfileSettingsEnum.disks_dest_dir_enabled, Boolean.class))) {
            rompaths.add(profile.getProperty(ProfileSettingsEnum.disks_dest_dir));
        }
        String[] args = new String[]{mame.getFile().getAbsolutePath(), ware.getBaseName(), "-homepath", mame.getFile().getParent(), "-rompath", rompaths.stream().collect(Collectors.joining(";"))};
        return args;
    }

    private String[] getMameArgsSofware(Anyware ware, Profile profile, ProfileNFOMame mame, String[] args) throws HeadlessException {
        ArrayList<String> rompaths = new ArrayList<String>(Collections.singletonList(profile.getProperty(ProfileSettingsEnum.roms_dest_dir)));
        if (Boolean.TRUE.equals(profile.getProperty(ProfileSettingsEnum.swroms_dest_dir_enabled, Boolean.class))) {
            rompaths.add(profile.getProperty(ProfileSettingsEnum.swroms_dest_dir));
        }
        if (Boolean.TRUE.equals(profile.getProperty(ProfileSettingsEnum.disks_dest_dir_enabled, Boolean.class))) {
            rompaths.add(profile.getProperty(ProfileSettingsEnum.disks_dest_dir));
        }
        if (Boolean.TRUE.equals(profile.getProperty(ProfileSettingsEnum.swdisks_dest_dir_enabled, Boolean.class))) {
            rompaths.add(profile.getProperty(ProfileSettingsEnum.swdisks_dest_dir));
        }
        Log.debug(() -> ((Software)ware).getSl().getBaseName() + ", " + ((Software)ware).getCompatibility());
        JList<Machine> machines = new JList<Machine>(profile.getMachineListList().getSortedMachines(((Software)ware).getSl().getBaseName(), ((Software)ware).getCompatibility()).toArray(new Machine[0]));
        machines.setSelectionMode(0);
        if (machines.getModel().getSize() > 0) {
            machines.setSelectedIndex(0);
        }
        JOptionPane.showMessageDialog(this, machines);
        Machine machine = machines.getSelectedValue();
        if (machine != null) {
            StringBuilder device = new StringBuilder();
            for (Device dev : machine.getDevices()) {
                if (!Objects.equals(((Software.Part)((Software)ware).getParts().get(0)).getIntrface(), dev.getIntrface()) || dev.getInstance() == null) continue;
                device.append("-" + dev.getInstance().getName());
                break;
            }
            Log.debug(() -> "-> " + machine.getBaseName() + " " + String.valueOf(device) + " " + ware.getBaseName());
            args = new String[]{mame.getFile().getAbsolutePath(), machine.getBaseName(), device.toString(), ware.getBaseName(), "-homepath", mame.getFile().getParent(), "-rompath", rompaths.stream().collect(Collectors.joining(";"))};
        }
        return args;
    }

    private void selectItemWL(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel model = (ListSelectionModel)e.getSource();
        TableModel tablemodel = this.tableWL.getModel();
        if (model != null && tablemodel != null) {
            if (!model.isSelectionEmpty()) {
                AnywareListModel anywareListModel;
                AnywareList awlist = (AnywareList)tablemodel.getValueAt(model.getMinSelectionIndex(), 0);
                if (awlist instanceof MachineList) {
                    MachineList ml = (MachineList)awlist;
                    anywareListModel = new MachineListModel(ml);
                } else {
                    anywareListModel = new SoftwareListModel((SoftwareList)awlist);
                }
                AnywareListModel anywarelist = anywareListModel;
                anywarelist.reset();
                this.tableW.setModel(anywarelist);
                this.tableW.setTableHeader(new JTableHeader(this.tableW.getColumnModel()){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        return this.columnModel.getColumn(this.columnModel.getColumnIndexAtX(e.getPoint().x)).getHeaderValue().toString();
                    }
                });
                if (this.tableW.getRowCount() > 0) {
                    this.tableW.setRowSelectionInterval(0, 0);
                }
                this.readjustColumnsW(anywarelist);
            } else {
                this.tableW.setModel(new DefaultTableModel());
                this.tableEntity.setModel(new DefaultTableModel());
            }
        }
    }

    private void readjustColumnsW(AnywareListModel<?> anywarelist) {
        for (int i = 0; i < this.tableW.getColumnModel().getColumnCount(); ++i) {
            TableColumn column = this.tableW.getColumnModel().getColumn(i);
            column.setCellRenderer(anywarelist.getColumnRenderer(i));
            int width = anywarelist.getColumnWidth(i);
            if (width > 0) {
                column.setMinWidth(width / 2);
                column.setPreferredWidth(width);
                continue;
            }
            if (width >= 0) continue;
            column.setMinWidth(-width);
            column.setMaxWidth(-width);
        }
    }

    private void export(final Session session, final Export.ExportType type, final boolean filtered, final SoftwareList selection) {
        FileNameExtensionFilter fnef = new FileNameExtensionFilter(Messages.getString((String)"MainFrame.DatFile"), "xml", "dat");
        new JRMFileChooser<Void>(1, 0, Optional.ofNullable(session.getUser().getSettings().getProperty("MainFrame.ChooseExeOrDatToExport", (String)null)).map(File::new).orElse(null), null, Arrays.asList(fnef), Messages.getString((String)"ProfileViewer.ChooseDestinationFile"), false).show(this, chooser -> {
            session.getUser().getSettings().setProperty("MainFrame.ChooseExeOrDatToExport", chooser.getCurrentDirectory().getAbsolutePath());
            File selectedfile = chooser.getSelectedFile();
            final File file = fnef.accept(selectedfile) ? selectedfile : new File(selectedfile.getAbsolutePath() + ".xml");
            new SwingWorkerProgress<Void, Void>(this, (Window)this){

                @Override
                protected Void doInBackground() throws Exception {
                    Export.export((Profile)session.getCurrProfile(), (File)file, (Export.ExportType)type, (boolean)filtered, (SoftwareList)selection, (ProgressHandler)this);
                    return null;
                }

                @Override
                public void done() {
                    this.close();
                }
            }.execute();
            return null;
        });
    }

    public void setFilterWL(boolean missing, boolean partial, boolean complete) {
        EnumSet<AnywareStatus> filter = EnumSet.of(AnywareStatus.UNKNOWN);
        if (missing) {
            filter.add(AnywareStatus.MISSING);
        }
        if (partial) {
            filter.add(AnywareStatus.PARTIAL);
        }
        if (complete) {
            filter.add(AnywareStatus.COMPLETE);
        }
        ((AnywareListListModel)this.tableWL.getModel()).setFilter(filter);
        if (this.tableWL.getRowCount() > 0) {
            this.tableWL.setRowSelectionInterval(0, 0);
        }
    }

    public void setFilterW(boolean missing, boolean partial, boolean complete) {
        EnumSet<AnywareStatus> filter = EnumSet.of(AnywareStatus.UNKNOWN);
        if (missing) {
            filter.add(AnywareStatus.MISSING);
        }
        if (partial) {
            filter.add(AnywareStatus.PARTIAL);
        }
        if (complete) {
            filter.add(AnywareStatus.COMPLETE);
        }
        ((AnywareListModel)this.tableW.getModel()).setFilter(filter);
        if (this.tableW.getRowCount() > 0) {
            this.tableW.setRowSelectionInterval(0, 0);
        }
    }

    public void setFilterE(boolean ko, boolean ok) {
        EnumSet<EntityStatus> filter = EnumSet.of(EntityStatus.UNKNOWN);
        if (ko) {
            filter.add(EntityStatus.KO);
        }
        if (ok) {
            filter.add(EntityStatus.OK);
        }
        ((AnywareModel)this.tableEntity.getModel()).setFilter(filter);
        if (this.tableEntity.getRowCount() > 0) {
            this.tableEntity.setRowSelectionInterval(0, 0);
        }
    }

    public void clear() {
        this.tableEntity.setModel(new DefaultTableModel());
        this.tableW.setModel(new DefaultTableModel());
        this.tableWL.setModel(new DefaultTableModel());
    }

    public void reset(Profile profile) {
        MachineListListModel model = new MachineListListModel(profile.getMachineListList());
        model.reset();
        if (this.tableWL.getModel() != model) {
            this.tableWL.setModel(model);
        }
        for (int i = 0; i < this.tableWL.getColumnModel().getColumnCount(); ++i) {
            TableColumn column = this.tableWL.getColumnModel().getColumn(i);
            column.setCellRenderer(model.getColumnRenderer(i));
            int width = model.getColumnWidth(i);
            if (width > 0) {
                column.setMinWidth(width / 2);
                column.setPreferredWidth(width);
                continue;
            }
            if (width >= 0) continue;
            column.setMinWidth(-width);
            column.setMaxWidth(-width);
        }
        if (this.tableWL.getRowCount() > 0) {
            this.tableWL.setRowSelectionInterval(0, 0);
        }
    }

    public void reload() {
        TableModel tablemodel = this.tableWL.getModel();
        if (tablemodel instanceof MachineListListModel) {
            MachineListListModel mlm = (MachineListListModel)tablemodel;
            mlm.fireTableChanged(new TableModelEvent(tablemodel, 0, mlm.getRowCount() - 1, -1, 0));
        }
        if ((tablemodel = this.tableW.getModel()) instanceof AnywareListModel) {
            AnywareListModel alm = (AnywareListModel)tablemodel;
            alm.fireTableChanged(new TableModelEvent(tablemodel, 0, alm.getRowCount() - 1, -1, 0));
        }
        if ((tablemodel = this.tableEntity.getModel()) instanceof AnywareModel) {
            AnywareModel am = (AnywareModel)tablemodel;
            am.fireTableChanged(new TableModelEvent(tablemodel, 0, am.getRowCount() - 1, -1, 0));
        }
    }

    private void search() {
        String search = this.txtSearch.getText();
        int row = ((AnywareListModel)this.tableW.getModel()).getList().find(search);
        if (row >= 0) {
            this.tableW.setRowSelectionInterval(row, row);
            this.tableW.scrollRectToVisible(this.tableW.getCellRect(row, 0, true));
        }
    }

    private class KW
    extends Keywords {
        final AnywareListModel<Anyware> list;

        private KW() {
            this.list = (AnywareListModel)ProfileViewer.this.tableW.getModel();
        }

        protected void showFilter(String[] keywords, Keywords.KFCallBack callback) {
            new KeywordFilter((Window)ProfileViewer.this, keywords, this.list.getList(), (arg_0, arg_1) -> ((KW)this).filterCallBack(arg_0, arg_1));
        }

        protected void updateList() {
            this.list.fireTableChanged(new TableModelEvent(this.list, 0, this.list.getRowCount() - 1, -1, 0));
        }
    }
}

