/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.data;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jrm.locale.Messages;
import jrm.profile.data.Anyware;
import jrm.profile.data.Software;
import jrm.ui.MainFrame;
import jrm.ui.basic.CenteredTableCellRenderer;
import lombok.Generated;

public final class SoftwareListRenderer {
    protected static final String[] columns = new String[]{Messages.getString((String)"SoftwareListRenderer.Status"), Messages.getString((String)"SoftwareListRenderer.Name"), Messages.getString((String)"SoftwareListRenderer.Description"), Messages.getString((String)"SoftwareListRenderer.Have"), Messages.getString((String)"SoftwareListRenderer.CloneOf"), Messages.getString((String)"SoftwareListRenderer.Selected")};
    protected static final Class<?>[] columnsTypes = new Class[]{Object.class, Object.class, String.class, String.class, Object.class, Boolean.class};
    protected static final int[] columnsWidths = new int[]{-20, 40, 200, -45, 40, -20};
    protected static final TableCellRenderer[] columnsRenderers = new TableCellRenderer[]{new SoftwareCellRenderer(false), new AnywareCellRenderer(), null, new CenteredTableCellRenderer(), new SoftwareCellRenderer(true), null};

    private SoftwareListRenderer() {
    }

    private static final class SoftwareCellRenderer
    extends DefaultTableCellRenderer {
        private static final ImageIcon folder_closed_green = MainFrame.getIcon("/jrm/resicons/folder_closed_green.png");
        private static final ImageIcon folder_closed_orange = MainFrame.getIcon("/jrm/resicons/folder_closed_orange.png");
        private static final ImageIcon folder_closed_red = MainFrame.getIcon("/jrm/resicons/folder_closed_red.png");
        private static final ImageIcon folder_closed_gray = MainFrame.getIcon("/jrm/resicons/folder_closed_gray.png");
        private final boolean withName;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Software) {
                Software sw = (Software)value;
                super.getTableCellRendererComponent(table, this.withName ? sw.getBaseName() : "", isSelected, hasFocus, row, column);
                switch (((Software)value).getStatus()) {
                    case COMPLETE: {
                        this.setIcon(folder_closed_green);
                        break;
                    }
                    case PARTIAL: {
                        this.setIcon(folder_closed_orange);
                        break;
                    }
                    case MISSING: {
                        this.setIcon(folder_closed_red);
                        break;
                    }
                    default: {
                        this.setIcon(folder_closed_gray);
                    }
                }
                return this;
            }
            this.setIcon(null);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        @Generated
        public SoftwareCellRenderer(boolean withName) {
            this.withName = withName;
        }
    }

    private static final class AnywareCellRenderer
    extends DefaultTableCellRenderer {
        private AnywareCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Anyware) {
                Anyware aw = (Anyware)value;
                return super.getTableCellRendererComponent(table, aw.getBaseName(), isSelected, hasFocus, row, column);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

