/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.filter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataHandler;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.TransferHandler;
import javax.swing.border.TitledBorder;
import jrm.locale.Messages;
import jrm.misc.Log;
import jrm.profile.data.Anyware;
import jrm.profile.data.AnywareList;
import jrm.profile.filter.Keywords;
import jrm.ui.MainFrame;

public class KeywordFilter
extends JDialog {
    private JList<String> keywordSrc;
    private JList<String> keywordDst;
    private DefaultListModel<String> dstmodel = new DefaultListModel();

    public KeywordFilter(Window owner, String[] src, AnywareList<Anyware> list, Keywords.KFCallBack callback) {
        super(owner, Messages.getString((String)"KeywordFilter.Title"), Dialog.ModalityType.APPLICATION_MODAL);
        this.setIconImage(MainFrame.getIcon("/jrm/resicons/rom.png").getImage());
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "South");
        GridBagLayout gblPanel = new GridBagLayout();
        gblPanel.columnWidths = new int[]{217, 217, 0};
        gblPanel.rowHeights = new int[]{23, 0};
        gblPanel.columnWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        gblPanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel.setLayout(gblPanel);
        JButton btnCancel = new JButton(Messages.getString((String)"KeywordFilter.Cancel"));
        btnCancel.addActionListener(e -> this.dispose());
        btnCancel.setHorizontalAlignment(10);
        GridBagConstraints gbcBtnCancel = new GridBagConstraints();
        gbcBtnCancel.anchor = 17;
        gbcBtnCancel.fill = 3;
        gbcBtnCancel.insets = new Insets(5, 5, 5, 5);
        gbcBtnCancel.gridx = 0;
        gbcBtnCancel.gridy = 0;
        panel.add((Component)btnCancel, gbcBtnCancel);
        JButton btnFilter = new JButton(Messages.getString((String)"KeywordFilter.Filter"));
        btnFilter.addActionListener(e -> {
            callback.call(list, this.getFilter());
            this.dispose();
        });
        btnFilter.setHorizontalAlignment(11);
        GridBagConstraints gbcBtnFilter = new GridBagConstraints();
        gbcBtnFilter.insets = new Insets(5, 5, 5, 5);
        gbcBtnFilter.anchor = 13;
        gbcBtnFilter.fill = 3;
        gbcBtnFilter.gridx = 1;
        gbcBtnFilter.gridy = 0;
        panel.add((Component)btnFilter, gbcBtnFilter);
        JSplitPane keywordSplitPane = new JSplitPane();
        keywordSplitPane.setResizeWeight(0.5);
        keywordSplitPane.setOneTouchExpandable(true);
        keywordSplitPane.setContinuousLayout(true);
        this.getContentPane().add((Component)keywordSplitPane, "Center");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(new TitledBorder(null, Messages.getString((String)"KeywordFilter.Available"), 4, 2, null, new Color(0, 0, 0)));
        keywordSplitPane.setLeftComponent(scrollPane);
        this.keywordSrc = new JList();
        this.keywordSrc.setVisibleRowCount(16);
        scrollPane.setViewportView(this.keywordSrc);
        this.keywordSrc.setDragEnabled(true);
        this.keywordSrc.setDropMode(DropMode.INSERT);
        StringMoveHandler.createFor(this.keywordSrc);
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (String s : src) {
            model.addElement(s);
        }
        this.keywordSrc.setModel(model);
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setBorder(new TitledBorder(null, Messages.getString((String)"KeywordFilter.Used"), 4, 2, null, new Color(0, 0, 0)));
        keywordSplitPane.setRightComponent(scrollPane1);
        this.keywordDst = new JList();
        this.keywordDst.setVisibleRowCount(16);
        scrollPane1.setViewportView(this.keywordDst);
        this.keywordDst.setDragEnabled(true);
        this.keywordDst.setDropMode(DropMode.INSERT);
        StringMoveHandler.createFor(this.keywordDst);
        this.keywordDst.setModel(this.dstmodel);
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    public List<String> getFilter() {
        return Collections.list(this.dstmodel.elements());
    }

    private static class StringMoveHandler
    extends TransferHandler {
        private DataFlavor objectArrayFlavor = new ActivationDataFlavor(Object[].class, "application/x-java-jvm-local-objectref", "Array of items");
        private JList<String> list;

        private StringMoveHandler() {
        }

        public static StringMoveHandler createFor(JList<String> list) {
            StringMoveHandler handler = new StringMoveHandler();
            list.setTransferHandler(handler);
            handler.list = list;
            return handler;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(this.objectArrayFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            Transferable t = transferSupport.getTransferable();
            boolean success = false;
            try {
                Object[] importedData = (Object[])t.getTransferData(this.objectArrayFlavor);
                this.addToListModel(importedData);
                success = true;
            }
            catch (UnsupportedFlavorException | IOException e) {
                Log.err((String)e.getMessage(), (Throwable)e);
            }
            return success;
        }

        private void addToListModel(Object[] importedData) {
            JList.DropLocation loc = this.list.getDropLocation();
            int dropIndex = loc.getIndex();
            DefaultListModel listModel = (DefaultListModel)this.list.getModel();
            for (int i = 0; i < importedData.length; ++i) {
                Object elem = importedData[i];
                if (elem instanceof String) {
                    String s = (String)elem;
                    listModel.add(dropIndex + i, s);
                    continue;
                }
                Log.err(() -> "Imported data contained something else than strings: " + String.valueOf(elem));
            }
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        public Transferable createTransferable(JComponent source) {
            Object[] valuesToTransfer = this.list.getSelectedValues();
            return new DataHandler((Object)valuesToTransfer, this.objectArrayFlavor.getMimeType());
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            if (action == 2) {
                try {
                    Object[] exportedData = (Object[])data.getTransferData(this.objectArrayFlavor);
                    this.removeFromListModel(exportedData);
                }
                catch (UnsupportedFlavorException | IOException e) {
                    Log.err((String)e.getMessage(), (Throwable)e);
                }
            }
        }

        private void removeFromListModel(Object[] dataToRemove) {
            DefaultListModel listModel = (DefaultListModel)this.list.getModel();
            for (Object elemToRemove : dataToRemove) {
                boolean removedSuccessfully = listModel.removeElement(elemToRemove);
                if (removedSuccessfully) continue;
                Log.err((Object)"Source model did not contain exported data");
            }
        }
    }

    public static interface CallBack {
        public void call(KeywordFilter var1);
    }
}

