/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.report;

import java.awt.Desktop;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ItemEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jrm.aui.profile.report.ReportTreeHandler;
import jrm.locale.Messages;
import jrm.misc.Log;
import jrm.profile.report.FilterOptions;
import jrm.profile.report.Report;
import jrm.ui.MainFrame;
import jrm.ui.basic.Popup;
import jrm.ui.profile.report.ReportNode;
import jrm.ui.profile.report.ReportTreeCellRenderer;
import jrm.ui.profile.report.ReportTreeModel;

public class ReportView
extends JScrollPane
implements Popup {
    private final Report report;
    private final JLabel wait;
    private final JTree tree;

    public ReportView(Report report) {
        this.report = report;
        this.tree = new JTree();
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        DefaultTreeSelectionModel selmodel = new DefaultTreeSelectionModel();
        selmodel.setSelectionMode(1);
        this.tree.setSelectionModel(selmodel);
        this.wait = new JLabel("Building tree...");
        this.wait.setFont(this.getFont().deriveFont(14.0f));
        this.wait.setHorizontalAlignment(0);
        this.wait.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setViewportView(this.wait);
        this.build(report);
        JPopupMenu popupMenu = new JPopupMenu();
        Popup.addPopup(this.tree, popupMenu);
        JMenuItem mntmOpenAllNodes = new JMenuItem(Messages.getString((String)"ReportFrame.mntmOpenAllNodes.text"));
        mntmOpenAllNodes.setIcon(MainFrame.getIcon("/jrm/resicons/folder_open.png"));
        mntmOpenAllNodes.addActionListener(e -> this.openAllNodes());
        popupMenu.add(mntmOpenAllNodes);
        JCheckBoxMenuItem chckbxmntmShowOkEntries = new JCheckBoxMenuItem(Messages.getString((String)"ReportFrame.chckbxmntmShowOkEntries.text"));
        chckbxmntmShowOkEntries.setIcon(MainFrame.getIcon("/jrm/resicons/folder_closed_green.png"));
        chckbxmntmShowOkEntries.addItemListener(e -> this.showOKEntries(report, e));
        JMenuItem mntmCloseAllNodes = new JMenuItem(Messages.getString((String)"ReportFrame.mntmCloseAllNodes.text"));
        mntmCloseAllNodes.addActionListener(e -> this.closeAllNodes());
        mntmCloseAllNodes.setIcon(MainFrame.getIcon("/jrm/resicons/folder_closed.png"));
        popupMenu.add(mntmCloseAllNodes);
        popupMenu.add(chckbxmntmShowOkEntries);
        JCheckBoxMenuItem chckbxmntmHideFullyMissing = new JCheckBoxMenuItem(Messages.getString((String)"ReportFrame.chckbxmntmHideFullyMissing.text"));
        chckbxmntmHideFullyMissing.setIcon(MainFrame.getIcon("/jrm/resicons/folder_closed_red.png"));
        chckbxmntmHideFullyMissing.addItemListener(e -> this.hideFullyMissing(report, e));
        popupMenu.add(chckbxmntmHideFullyMissing);
        popupMenu.addSeparator();
        JMenuItem mntmDetail = new JMenuItem(Messages.getString((String)"ReportView.mntmDetail.text"));
        mntmDetail.addActionListener(e -> this.showDetail());
        mntmDetail.setEnabled(false);
        popupMenu.add(mntmDetail);
        JMenuItem mntmCopyCRC = new JMenuItem("Copy CRC");
        mntmCopyCRC.setEnabled(false);
        mntmCopyCRC.addActionListener(e -> this.copyCRC());
        popupMenu.add(mntmCopyCRC);
        JMenuItem mntmCopySHA1 = new JMenuItem("Copy SHA1");
        mntmCopySHA1.setEnabled(false);
        mntmCopySHA1.addActionListener(e -> this.copySHA1());
        popupMenu.add(mntmCopySHA1);
        JMenuItem mntmCopyName = new JMenuItem("Copy Name");
        mntmCopyName.setEnabled(false);
        mntmCopyName.addActionListener(e -> this.copyName());
        popupMenu.add(mntmCopyName);
        JMenuItem mntmSearchWeb = new JMenuItem("Search on the Web");
        mntmSearchWeb.setEnabled(false);
        mntmSearchWeb.addActionListener(e -> this.searchOnTheWeb());
        popupMenu.add(mntmSearchWeb);
        this.tree.addTreeSelectionListener(e -> {
            TreePath path = e.getNewLeadSelectionPath();
            if (path != null) {
                Object node = path.getLastPathComponent();
                mntmDetail.setEnabled(node instanceof ReportNode.SubjectNode.NoteNode);
                mntmCopyCRC.setEnabled(node instanceof ReportNode.SubjectNode.NoteNode);
                mntmCopySHA1.setEnabled(node instanceof ReportNode.SubjectNode.NoteNode);
                mntmCopyName.setEnabled(node instanceof ReportNode.SubjectNode.NoteNode);
                mntmSearchWeb.setEnabled(node instanceof ReportNode.SubjectNode.NoteNode);
            } else {
                mntmDetail.setEnabled(false);
                mntmCopyCRC.setEnabled(false);
                mntmCopySHA1.setEnabled(false);
                mntmCopyName.setEnabled(false);
                mntmSearchWeb.setEnabled(false);
            }
        });
    }

    private void searchOnTheWeb() {
        Object node;
        TreePath path = this.tree.getSelectionPath();
        if (path != null && (node = path.getLastPathComponent()) instanceof ReportNode.SubjectNode.NoteNode) {
            ReportNode.SubjectNode.NoteNode nn = (ReportNode.SubjectNode.NoteNode)node;
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                try {
                    String name = nn.getNote().getName();
                    String crc = nn.getNote().getCrc();
                    String sha1 = nn.getNote().getSha1();
                    String hash = Optional.ofNullable(Optional.ofNullable(crc).orElse(sha1)).map(h -> "+" + h).orElse("");
                    Desktop.getDesktop().browse(new URI("https://www.google.com/search?q=" + URLEncoder.encode("\"" + name + "\"", "UTF-8") + hash));
                }
                catch (IOException | URISyntaxException e1) {
                    Log.err((String)e1.getMessage(), (Throwable)e1);
                }
            }
        }
    }

    private void copyName() throws HeadlessException {
        Object node;
        TreePath path = this.tree.getSelectionPath();
        if (path != null && (node = path.getLastPathComponent()) instanceof ReportNode.SubjectNode.NoteNode) {
            ReportNode.SubjectNode.NoteNode nn = (ReportNode.SubjectNode.NoteNode)node;
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(nn.getNote().getName()), null);
        }
    }

    private void copySHA1() throws HeadlessException {
        Object node;
        TreePath path = this.tree.getSelectionPath();
        if (path != null && (node = path.getLastPathComponent()) instanceof ReportNode.SubjectNode.NoteNode) {
            ReportNode.SubjectNode.NoteNode nn = (ReportNode.SubjectNode.NoteNode)node;
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(nn.getNote().getSha1()), null);
        }
    }

    private void copyCRC() throws HeadlessException {
        Object node;
        TreePath path = this.tree.getSelectionPath();
        if (path != null && (node = path.getLastPathComponent()) instanceof ReportNode.SubjectNode.NoteNode) {
            ReportNode.SubjectNode.NoteNode nn = (ReportNode.SubjectNode.NoteNode)node;
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(nn.getNote().getCrc()), null);
        }
    }

    private void showDetail() throws HeadlessException {
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            Object node = path.getLastPathComponent();
            if (node instanceof ReportNode.SubjectNode.NoteNode) {
                ReportNode.SubjectNode.NoteNode nn = (ReportNode.SubjectNode.NoteNode)node;
                String msg = nn.getNote().getDetail();
                JOptionPane.showMessageDialog(this, new JTextArea(msg), "Details", 1);
            } else if (node instanceof ReportNode.SubjectNode) {
                // empty if block
            }
        }
    }

    private void hideFullyMissing(Report report, ItemEvent e) {
        Set options = report.getHandler().getFilterOptions();
        if (e.getStateChange() == 1) {
            options.add(FilterOptions.HIDEMISSING);
        } else {
            options.remove(FilterOptions.HIDEMISSING);
        }
        this.update((FilterOptions[])options.toArray(FilterOptions[]::new));
    }

    private void closeAllNodes() {
        this.tree.invalidate();
        int j = this.tree.getRowCount();
        for (int i = 0; i < j; ++i) {
            this.tree.collapseRow(i);
            j = this.tree.getRowCount();
        }
        this.tree.validate();
    }

    private void showOKEntries(Report report, ItemEvent e) {
        Set options = report.getHandler().getFilterOptions();
        if (e.getStateChange() == 1) {
            options.add(FilterOptions.SHOWOK);
        } else {
            options.remove(FilterOptions.SHOWOK);
        }
        this.update((FilterOptions[])options.toArray(FilterOptions[]::new));
    }

    private void openAllNodes() {
        this.tree.invalidate();
        int j = this.tree.getRowCount();
        for (int i = 0; i < j; ++i) {
            this.tree.expandRow(i);
            j = this.tree.getRowCount();
        }
        this.tree.validate();
    }

    private void build(final Report report) {
        new SwingWorker<TreeModel, Void>(){

            @Override
            protected TreeModel doInBackground() throws Exception {
                return new ReportTreeModel((ReportTreeHandler<Report>)report.getHandler());
            }

            @Override
            protected void done() {
                try {
                    ReportView.this.tree.setModel((TreeModel)this.get());
                    ReportView.this.tree.setCellRenderer(new ReportTreeCellRenderer());
                    ReportView.this.setViewportView(ReportView.this.tree);
                }
                catch (InterruptedException e) {
                    Log.err((String)e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    Log.err((String)e.getMessage(), (Throwable)e);
                }
                finally {
                    ReportView.this.setEnabled(true);
                }
            }
        }.execute();
    }

    public void update() {
        this.update(new FilterOptions[0]);
    }

    private void update(final FilterOptions[] options) {
        this.setViewportView(this.wait);
        new SwingWorker<FilterOptions[], Void>(){

            @Override
            protected FilterOptions[] doInBackground() throws Exception {
                return options;
            }

            @Override
            protected void done() {
                try {
                    ReportView.this.setViewportView(ReportView.this.tree);
                    ReportView.this.report.getHandler().filter((FilterOptions[])this.get());
                }
                catch (InterruptedException e) {
                    Log.err((String)e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    Log.err((String)e.getMessage(), (Throwable)e);
                }
            }
        }.execute();
    }
}

