/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.progress;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import jrm.locale.Messages;
import jrm.ui.MainFrame;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class Progress
extends JDialog {
    private static final String S_OF_S = "%s / %s";
    private static final String HH_MM_SS_FMT = "HH:mm:ss";
    private static final String HH_MM_SS_OF_HH_MM_SS_NONE = "--:--:-- / --:--:--";
    private static final String HH_MM_SS_NONE = "--:--:--";
    private static final Color colorLighter = SystemColor.controlHighlight;
    private static final Color colorLight = SystemColor.controlLtHighlight;
    private static final Color colorNormal = SystemColor.control;
    private JPanel panel;
    private JLabel[] lblInfo;
    private JLabel[] lblSubInfo;
    private final JProgressBar progressBar;
    private final JProgressBar progressBar2;
    private final JProgressBar progressBar3;
    private final JLabel lblTimeleft;
    private final JLabel lblTimeLeft2;
    private final JLabel lblTimeLeft3;
    private final JButton btnCancel;
    private boolean cancel = false;
    private boolean canCancel = false;
    private long startTime = System.currentTimeMillis();
    private static final Integer MOINS_UN = -1;
    private long startTime2 = System.currentTimeMillis();
    private long startTime3 = System.currentTimeMillis();

    public Progress(final Window owner) {
        super(owner, Messages.getString((String)"Progress.Title"), Dialog.ModalityType.MODELESS);
        this.setIconImage(MainFrame.getIcon("/jrm/resicons/rom.png").getImage());
        this.getContentPane().setBackground(UIManager.getColor("Panel.background"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Progress.this.cancel = true;
            }

            @Override
            public void windowOpened(WindowEvent e) {
                owner.setEnabled(false);
                if (owner.getOwner() != null) {
                    owner.getOwner().setEnabled(false);
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
                owner.setEnabled(true);
                owner.toFront();
                if (owner.getOwner() != null) {
                    owner.getOwner().setEnabled(true);
                }
            }
        });
        this.setDefaultCloseOperation(0);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{30, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 1.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        this.panel = new JPanel();
        GridBagConstraints gbcPanel = new GridBagConstraints();
        gbcPanel.insets = new Insets(5, 5, 5, 5);
        gbcPanel.gridwidth = 2;
        gbcPanel.fill = 1;
        gbcPanel.gridx = 0;
        gbcPanel.gridy = 0;
        this.getContentPane().add((Component)this.panel, gbcPanel);
        this.panel.setLayout(new GridLayout(0, 1, 5, 5));
        this.setInfos(1, false);
        this.progressBar = new JProgressBar();
        this.progressBar.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.progressBar.setMinimumSize(new Dimension(300, 20));
        this.progressBar.setPreferredSize(new Dimension(450, 20));
        GridBagConstraints gbcProgressBar = new GridBagConstraints();
        gbcProgressBar.fill = 2;
        gbcProgressBar.anchor = 15;
        gbcProgressBar.insets = new Insets(0, 5, 5, 5);
        gbcProgressBar.gridx = 0;
        gbcProgressBar.gridy = 1;
        this.getContentPane().add((Component)this.progressBar, gbcProgressBar);
        this.lblTimeleft = new JLabel(HH_MM_SS_NONE);
        GridBagConstraints gbcLblTimeleft = new GridBagConstraints();
        gbcLblTimeleft.fill = 0;
        gbcLblTimeleft.anchor = 15;
        gbcLblTimeleft.insets = new Insets(0, 0, 5, 5);
        gbcLblTimeleft.gridx = 1;
        gbcLblTimeleft.gridy = 1;
        this.getContentPane().add((Component)this.lblTimeleft, gbcLblTimeleft);
        this.progressBar2 = new JProgressBar();
        this.progressBar2.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.progressBar2.setVisible(false);
        this.progressBar2.setPreferredSize(new Dimension(450, 20));
        this.progressBar2.setMinimumSize(new Dimension(300, 20));
        GridBagConstraints gbcProgressBar2 = new GridBagConstraints();
        gbcProgressBar2.fill = 2;
        gbcProgressBar2.insets = new Insets(0, 5, 5, 5);
        gbcProgressBar2.gridx = 0;
        gbcProgressBar2.gridy = 2;
        this.getContentPane().add((Component)this.progressBar2, gbcProgressBar2);
        this.lblTimeLeft2 = new JLabel(HH_MM_SS_NONE);
        this.lblTimeLeft2.setVisible(false);
        GridBagConstraints gbcLblTimeLeft2 = new GridBagConstraints();
        gbcLblTimeLeft2.fill = 0;
        gbcLblTimeLeft2.insets = new Insets(0, 0, 5, 5);
        gbcLblTimeLeft2.gridx = 1;
        gbcLblTimeLeft2.gridy = 2;
        this.getContentPane().add((Component)this.lblTimeLeft2, gbcLblTimeLeft2);
        this.progressBar3 = new JProgressBar();
        this.progressBar3.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.progressBar3.setVisible(false);
        this.progressBar3.setPreferredSize(new Dimension(450, 20));
        this.progressBar3.setMinimumSize(new Dimension(300, 20));
        GridBagConstraints gbcProgressBar3 = new GridBagConstraints();
        gbcProgressBar3.fill = 2;
        gbcProgressBar3.insets = new Insets(0, 5, 0, 5);
        gbcProgressBar3.gridx = 0;
        gbcProgressBar3.gridy = 3;
        this.getContentPane().add((Component)this.progressBar3, gbcProgressBar3);
        this.lblTimeLeft3 = new JLabel(HH_MM_SS_NONE);
        this.lblTimeLeft3.setVisible(false);
        GridBagConstraints gbcLblTimeLeft3 = new GridBagConstraints();
        gbcLblTimeLeft3.fill = 0;
        gbcLblTimeLeft3.insets = new Insets(0, 0, 0, 5);
        gbcLblTimeLeft3.gridx = 1;
        gbcLblTimeLeft3.gridy = 3;
        this.getContentPane().add((Component)this.lblTimeLeft3, gbcLblTimeLeft3);
        this.btnCancel = new JButton(Messages.getString((String)"Progress.btnCancel.text"));
        this.btnCancel.setIcon(MainFrame.getIcon("/jrm/resicons/icons/stop.png"));
        this.btnCancel.addActionListener(e -> this.cancel());
        GridBagConstraints gbcBtnCancel = new GridBagConstraints();
        gbcBtnCancel.insets = new Insets(5, 5, 5, 5);
        gbcBtnCancel.gridwidth = 2;
        gbcBtnCancel.anchor = 15;
        gbcBtnCancel.gridx = 0;
        gbcBtnCancel.gridy = 4;
        this.getContentPane().add((Component)this.btnCancel, gbcBtnCancel);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    public void setInfos(int threadCnt, Boolean multipleSubInfos) {
        Integer lblSubInfoCnt = Optional.ofNullable(multipleSubInfos).map(multSubNfo -> multSubNfo != false ? threadCnt : 1).orElse(0);
        if (this.lblInfo != null && this.lblInfo.length == threadCnt && this.lblSubInfo != null && this.lblSubInfo.length == lblSubInfoCnt) {
            return;
        }
        this.panel.removeAll();
        this.lblInfo = new JLabel[threadCnt];
        this.lblSubInfo = new JLabel[lblSubInfoCnt.intValue()];
        for (int i = 0; i < threadCnt; ++i) {
            this.lblInfo[i] = this.buildLabel(i % 2 != 0 ? colorNormal : colorLight);
            this.panel.add(this.lblInfo[i]);
            if (!Boolean.TRUE.equals(multipleSubInfos)) continue;
            this.lblSubInfo[i] = this.buildLabel(i % 2 != 0 ? colorNormal : colorLight);
            this.panel.add(this.lblSubInfo[i]);
        }
        if (Boolean.FALSE.equals(multipleSubInfos)) {
            this.lblSubInfo[0] = this.buildLabel(colorLighter);
            this.panel.add(this.lblSubInfo[0]);
        }
        this.packHeight();
    }

    void extendInfos(int threadCnt, Boolean multipleSubInfos) {
        if (this.lblInfo == null || this.lblInfo.length == threadCnt) {
            return;
        }
        if (Boolean.TRUE.equals(multipleSubInfos) && this.lblSubInfo == null) {
            return;
        }
        int oldThreadCnt = this.lblInfo.length;
        this.lblInfo = Arrays.copyOf(this.lblInfo, threadCnt);
        if (Boolean.TRUE.equals(multipleSubInfos)) {
            this.lblSubInfo = Arrays.copyOf(this.lblSubInfo, threadCnt);
        }
        for (int i = oldThreadCnt; i < threadCnt; ++i) {
            this.lblInfo[i] = this.buildLabel(i % 2 != 0 ? colorNormal : colorLight);
            this.panel.add(this.lblInfo[i]);
            if (!Boolean.TRUE.equals(multipleSubInfos)) continue;
            this.lblSubInfo[i] = this.buildLabel(i % 2 != 0 ? colorNormal : colorLight);
            this.panel.add(this.lblSubInfo[i]);
        }
        this.packHeight();
    }

    public JLabel buildLabel(Color color) {
        JLabel label = new JLabel();
        label.setOpaque(true);
        label.setBackground(color);
        label.setPreferredSize(new Dimension(0, 20));
        label.setMinimumSize(new Dimension(0, 20));
        label.setBorder(new BevelBorder(1, null, null, null, null));
        return label;
    }

    public void clearInfos() {
        for (JLabel label : this.lblInfo) {
            label.setText(null);
        }
        for (JLabel label : this.lblSubInfo) {
            label.setText(null);
        }
    }

    public synchronized void setProgress(int offset, String msg, Integer val, Integer max, String submsg) {
        if (msg != null) {
            this.lblInfo[offset].setText(msg);
        }
        if (val != null) {
            if (val < 0 && this.progressBar.isVisible()) {
                this.progressBar.setVisible(false);
                this.lblTimeleft.setVisible(false);
                this.packHeight();
            } else if (val >= 0 && !this.progressBar.isVisible()) {
                this.progressBar.setVisible(true);
                this.lblTimeleft.setVisible(true);
                this.packHeight();
            }
            this.progressBar.setStringPainted(val != 0);
            this.progressBar.setIndeterminate(val == 0);
            if (max != null) {
                this.progressBar.setMaximum(max);
            }
            if (val >= 0) {
                this.progressBar.setValue(val);
            }
            if (val == 0) {
                this.startTime = System.currentTimeMillis();
            }
            this.showTimeLeft(this.startTime, val, this.progressBar, this.lblTimeleft);
        }
        this.subMsg(offset, val, submsg);
    }

    protected void subMsg(int offset, Integer val, String submsg) {
        if (submsg != null || MOINS_UN.equals(val)) {
            if (this.lblSubInfo.length == 1) {
                this.lblSubInfo[0].setText(submsg);
            } else if (this.lblSubInfo.length > 1) {
                this.lblSubInfo[offset].setText(submsg);
            }
        }
    }

    private void showTimeLeft(long start, int val, JProgressBar pb, JLabel lab) {
        if (val > 0) {
            String left = DurationFormatUtils.formatDuration((long)((System.currentTimeMillis() - start) * (long)(pb.getMaximum() - val) / (long)val), (String)HH_MM_SS_FMT);
            String total = DurationFormatUtils.formatDuration((long)((System.currentTimeMillis() - start) * (long)pb.getMaximum() / (long)val), (String)HH_MM_SS_FMT);
            lab.setText(String.format(S_OF_S, left, total));
        } else {
            lab.setText(HH_MM_SS_OF_HH_MM_SS_NONE);
        }
    }

    public void setProgress2(String msg, Integer val, Integer max) {
        if (msg != null && val != null) {
            if (!this.progressBar2.isVisible()) {
                this.progressBar2.setVisible(true);
                this.lblTimeLeft2.setVisible(true);
                this.packHeight();
            }
            this.progressBar2.setStringPainted(val > 0);
            this.progressBar2.setString(msg);
            this.progressBar2.setIndeterminate(val == 0);
            if (max != null) {
                this.progressBar2.setMaximum(max);
            }
            if (val >= 0) {
                this.progressBar2.setValue(val);
            }
            if (val == 0) {
                this.startTime2 = System.currentTimeMillis();
            }
            this.showTimeLeft(this.startTime2, val, this.progressBar2, this.lblTimeLeft2);
        } else if (this.progressBar2.isVisible()) {
            this.progressBar2.setVisible(false);
            this.lblTimeLeft2.setVisible(false);
            this.packHeight();
        }
    }

    public void setProgress3(String msg, Integer val, Integer max) {
        if (msg != null && val != null) {
            if (!this.progressBar3.isVisible()) {
                this.progressBar3.setVisible(true);
                this.lblTimeLeft3.setVisible(true);
                this.packHeight();
            }
            this.progressBar3.setStringPainted(val > 0);
            this.progressBar3.setString(msg);
            this.progressBar3.setIndeterminate(val == 0);
            if (max != null) {
                this.progressBar3.setMaximum(max);
            }
            if (val >= 0) {
                this.progressBar3.setValue(val);
            }
            if (val == 0) {
                this.startTime3 = System.currentTimeMillis();
            }
            this.showTimeLeft(this.startTime3, val, this.progressBar3, this.lblTimeLeft3);
        } else if (this.progressBar3.isVisible()) {
            this.progressBar3.setVisible(false);
            this.lblTimeLeft3.setVisible(false);
            this.packHeight();
        }
    }

    private void packHeight() {
        this.invalidate();
        Dimension newSize = this.getPreferredSize();
        Rectangle rect = this.getBounds();
        rect.height = Math.max(rect.height, newSize.height);
        this.setBounds(rect);
        this.validate();
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void cancel() {
        this.cancel = true;
        this.btnCancel.setEnabled(false);
        this.btnCancel.setText(Messages.getString((String)"Progress.Canceling"));
    }

    public int getValue() {
        return this.progressBar.getValue();
    }

    public int getValue2() {
        return this.progressBar2.getValue();
    }

    public int getValue3() {
        return this.progressBar3.getValue();
    }

    public void close() {
        this.dispose();
    }

    public void canCancel(boolean canCancel) {
        this.canCancel = canCancel;
        this.btnCancel.setEnabled(canCancel);
    }

    public boolean canCancel() {
        return this.canCancel;
    }
}

