/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import javafx.fxml.Initializable;
import javafx.scene.control.Control;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import jrm.security.PathAbstractor;
import jrm.security.Session;
import jrm.security.Sessions;

abstract class BaseController
implements Initializable {
    protected final Session session = Sessions.getSingleSession();

    BaseController() {
    }

    protected void chooseDir(Control parent, String initialValue, File defdir, Callback cb) {
        DirectoryChooser chooser = this.initDirectoryChooser(initialValue, defdir);
        File chosen = chooser.showDialog(parent.getScene().getWindow());
        if (chosen != null) {
            cb.call(PathAbstractor.getRelativePath((Session)this.session, (Path)chosen.toPath()));
        }
    }

    protected void chooseOpenFile(Control parent, String initialValue, File defdir, Collection<FileChooser.ExtensionFilter> filters, Callback cb) {
        File chosen;
        FileChooser chooser = this.initFileChooser(initialValue, defdir);
        if (filters != null) {
            chooser.getExtensionFilters().addAll(filters);
        }
        if ((chosen = chooser.showOpenDialog(parent.getScene().getWindow())) != null) {
            cb.call(PathAbstractor.getRelativePath((Session)this.session, (Path)chosen.toPath()));
        }
    }

    protected void chooseOpenFileMulti(Control parent, String initialValue, File defdir, Collection<FileChooser.ExtensionFilter> filters, CallbackMulti cb) {
        List chosen;
        FileChooser chooser = this.initFileChooser(initialValue, defdir);
        if (filters != null) {
            chooser.getExtensionFilters().addAll(filters);
        }
        if ((chosen = chooser.showOpenMultipleDialog(parent.getScene().getWindow())) != null) {
            cb.call(chosen.stream().map(f -> PathAbstractor.getRelativePath((Session)this.session, (Path)f.toPath())).toList());
        }
    }

    protected void chooseSaveFile(Control parent, String initialValue, File defdir, Collection<FileChooser.ExtensionFilter> filters, Callback cb) {
        File chosen;
        FileChooser chooser = this.initFileChooser(initialValue, defdir);
        if (filters != null) {
            chooser.getExtensionFilters().addAll(filters);
        }
        if ((chosen = chooser.showSaveDialog(parent.getScene().getWindow())) != null) {
            cb.call(PathAbstractor.getRelativePath((Session)this.session, (Path)chosen.toPath()));
        }
    }

    private FileChooser initFileChooser(String initialValue, File defdir) {
        Path initial;
        FileChooser chooser = new FileChooser();
        boolean initialized = false;
        if (initialValue != null && !initialValue.isBlank() && (initial = PathAbstractor.getAbsolutePath((Session)this.session, (String)initialValue)) != null) {
            if (Files.exists(initial, new LinkOption[0]) && Files.isDirectory(initial, new LinkOption[0])) {
                chooser.setInitialDirectory(initial.toFile());
                initialized = true;
            } else {
                Path parent = initial.getParent();
                if (Files.exists(parent, new LinkOption[0]) && Files.isDirectory(parent, new LinkOption[0])) {
                    chooser.setInitialDirectory(initial.getParent().toFile());
                    initialized = true;
                }
                chooser.setInitialFileName(initial.getFileName().toString());
            }
        }
        if (!initialized && defdir != null && defdir.exists()) {
            chooser.setInitialDirectory(defdir);
        }
        return chooser;
    }

    private DirectoryChooser initDirectoryChooser(String initialValue, File defdir) {
        DirectoryChooser chooser = new DirectoryChooser();
        if (initialValue != null && !initialValue.isBlank()) {
            Path initial = PathAbstractor.getAbsolutePath((Session)this.session, (String)initialValue);
            if (initial != null && Files.exists(initial, new LinkOption[0]) && Files.isDirectory(initial, new LinkOption[0])) {
                chooser.setInitialDirectory(initial.toFile());
            } else if (defdir != null && defdir.exists()) {
                chooser.setInitialDirectory(defdir);
            }
        } else if (defdir != null && defdir.exists()) {
            chooser.setInitialDirectory(defdir);
        }
        return chooser;
    }

    static interface Callback {
        public void call(Path var1);
    }

    static interface CallbackMulti {
        public void call(List<Path> var1);
    }
}

