/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Control;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.image.ImageView;
import javafx.util.StringConverter;
import jrm.compressors.SevenZipOptions;
import jrm.compressors.ZipLevel;
import jrm.compressors.ZipTempThreshold;
import jrm.fx.ui.BaseController;
import jrm.fx.ui.MainFrame;
import jrm.fx.ui.misc.DragNDrop;
import jrm.locale.Messages;
import jrm.misc.EnumWithDefault;
import jrm.misc.Log;
import jrm.misc.ProfileSettingsEnum;
import jrm.misc.SettingsEnum;
import lombok.Generated;

public class SettingsPanelController
extends BaseController {
    @FXML
    TitledPane paneGeneral;
    @FXML
    ChoiceBox<ThreadCnt> cbThreading;
    @FXML
    CheckBox ckbBackupDst;
    @FXML
    TextField tfBackupDst;
    @FXML
    Button btBackupDst;
    @FXML
    TitledPane paneCompressors;
    @FXML
    ChoiceBox<ZipTempThreshold> cbZipTempThreshold;
    @FXML
    ChoiceBox<ZipLevel> cbZipLevel;
    @FXML
    ChoiceBox<SevenZipOptions> cb7zArgs;
    @FXML
    Spinner<Integer> tf7zThreads;
    @FXML
    CheckBox ckb7ZSolid;
    @FXML
    TitledPane paneDebug;
    @FXML
    ChoiceBox<Level> cbDbgLevel;
    @FXML
    Button gc;
    @FXML
    TextField status;
    private static final Level[] levels = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL};
    final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final String XX_MIB = "%.2f MiB";

    public void initialize(URL location, ResourceBundle resources) {
        this.initGeneral();
        this.initCompressors();
        this.initDebug();
    }

    private void initGeneral() {
        this.paneGeneral.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/cog.png")));
        this.cbThreading.getItems().setAll((Object[])ThreadCnt.build());
        this.cbThreading.getSelectionModel().select((Object)new ThreadCnt((Integer)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.thread_count, Integer.class)));
        this.cbThreading.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.thread_count, newValue.getCnt()));
        this.ckbBackupDst.selectedProperty().addListener((observable, oldValue, newValue) -> {
            this.tfBackupDst.setDisable(newValue == false);
            this.btBackupDst.setDisable(newValue == false);
            this.session.getUser().getSettings().setProperty((Enum)ProfileSettingsEnum.backup_dest_dir_enabled, newValue.booleanValue());
        });
        this.ckbBackupDst.setSelected(((Boolean)this.session.getUser().getSettings().getProperty((EnumWithDefault)ProfileSettingsEnum.backup_dest_dir_enabled, Boolean.class)).booleanValue());
        this.btBackupDst.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/disk.png")));
        this.tfBackupDst.setText(this.session.getUser().getSettings().getProperty((EnumWithDefault)ProfileSettingsEnum.backup_dest_dir));
        new DragNDrop((Control)this.btBackupDst).addDir(txt -> this.session.getUser().getSettings().setProperty((Enum)ProfileSettingsEnum.backup_dest_dir, txt));
        this.btBackupDst.setOnAction(e -> this.chooseDir((Control)this.btBackupDst, this.tfBackupDst.getText(), null, path -> {
            this.session.getUser().getSettings().setProperty((Enum)ProfileSettingsEnum.backup_dest_dir_enabled, path.toString());
            this.tfBackupDst.setText(path.toString());
        }));
    }

    private void initCompressors() {
        this.paneCompressors.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/compress.png")));
        this.cbZipTempThreshold.getItems().setAll((Object[])ZipTempThreshold.values());
        this.cbZipTempThreshold.setConverter((StringConverter)new StringConverter<ZipTempThreshold>(this){

            public String toString(ZipTempThreshold object) {
                return object.getDesc();
            }

            public ZipTempThreshold fromString(String string) {
                return null;
            }
        });
        this.cbZipTempThreshold.getSelectionModel().select((Object)((ZipTempThreshold)this.session.getUser().getSettings().getEnumProperty((EnumWithDefault)SettingsEnum.zip_temp_threshold, ZipTempThreshold.class)));
        this.cbZipTempThreshold.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.session.getUser().getSettings().setEnumProperty((Enum)SettingsEnum.zip_temp_threshold, (Enum)newValue));
        this.cbZipLevel.getItems().setAll((Object[])ZipLevel.values());
        this.cbZipLevel.setConverter((StringConverter)new StringConverter<ZipLevel>(this){

            public String toString(ZipLevel object) {
                return object.getName();
            }

            public ZipLevel fromString(String string) {
                return null;
            }
        });
        this.cbZipLevel.getSelectionModel().select((Object)((ZipLevel)this.session.getUser().getSettings().getEnumProperty((EnumWithDefault)SettingsEnum.zip_compression_level, ZipLevel.class)));
        this.cbZipLevel.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.session.getUser().getSettings().setEnumProperty((Enum)SettingsEnum.zip_compression_level, (Enum)newValue));
        this.cb7zArgs.getItems().setAll((Object[])SevenZipOptions.values());
        this.cb7zArgs.setConverter((StringConverter)new StringConverter<SevenZipOptions>(this){

            public String toString(SevenZipOptions object) {
                return object.getName();
            }

            public SevenZipOptions fromString(String string) {
                return null;
            }
        });
        this.cb7zArgs.getSelectionModel().select((Object)((SevenZipOptions)this.session.getUser().getSettings().getEnumProperty((EnumWithDefault)SettingsEnum.sevenzip_level, SevenZipOptions.class)));
        this.tf7zThreads.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory<Integer>(this){

            public void decrement(int steps) {
                this.setValue(Math.max(-1, (Integer)this.getValue() - steps));
            }

            public void increment(int steps) {
                this.setValue((Integer)this.getValue() + steps);
            }
        });
        this.tf7zThreads.getValueFactory().setValue((Object)((Integer)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.sevenzip_threads, Integer.class)));
        this.tf7zThreads.valueProperty().addListener((observable, oldValue, newValue) -> this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.sevenzip_threads, newValue.intValue()));
        this.ckb7ZSolid.setSelected(((Boolean)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.sevenzip_solid, Boolean.class)).booleanValue());
        this.ckb7ZSolid.selectedProperty().addListener((observable, oldValue, newValue) -> this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.sevenzip_solid, newValue.booleanValue()));
    }

    private void initDebug() {
        this.paneDebug.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/bug.png")));
        this.cbDbgLevel.getItems().setAll((Object[])levels);
        this.cbDbgLevel.getSelectionModel().select((Object)Level.parse(this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.debug_level)));
        this.cbDbgLevel.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.debug_level, newValue.toString());
            Log.setLevel((Level)newValue);
        });
        this.gc.setOnAction(e -> {
            System.gc();
            this.updateMemory();
        });
        this.scheduler.scheduleAtFixedRate(this::updateMemory, 0L, 20L, TimeUnit.SECONDS);
    }

    void updateMemory() {
        Runtime rt = Runtime.getRuntime();
        this.status.setText(String.format(Messages.getString((String)"MainFrame.MemoryUsage"), String.format(XX_MIB, (double)rt.totalMemory() / 1048576.0), String.format(XX_MIB, (double)(rt.totalMemory() - rt.freeMemory()) / 1048576.0), String.format(XX_MIB, (double)rt.freeMemory() / 1048576.0), String.format(XX_MIB, (double)rt.maxMemory() / 1048576.0)));
    }

    private static class ThreadCnt {
        final int cnt;
        final String name;

        public ThreadCnt(int cnt) {
            this.cnt = cnt;
            this.name = null;
        }

        public String toString() {
            return this.name != null ? this.name : Integer.toString(this.cnt);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof ThreadCnt) {
                ThreadCnt tc = (ThreadCnt)obj;
                return this.cnt == tc.cnt;
            }
            return super.equals(obj);
        }

        static ThreadCnt[] build() {
            ArrayList<ThreadCnt> list = new ArrayList<ThreadCnt>();
            list.add(new ThreadCnt(-1, "Adaptive"));
            list.add(new ThreadCnt(0, "Max available"));
            for (int i = 1; i <= Runtime.getRuntime().availableProcessors(); ++i) {
                list.add(new ThreadCnt(i));
            }
            return (ThreadCnt[])list.toArray(ThreadCnt[]::new);
        }

        @Generated
        public ThreadCnt(int cnt, String name) {
            this.cnt = cnt;
            this.name = name;
        }

        @Generated
        public int getCnt() {
            return this.cnt;
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }
}

